/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.layout;

import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xissweb.xml.XMLHelper;

public class PageDecorationInfo {
    public static final String HEADER = "Header";
    public static final String LEFT_MARGIN = "Left Margin";
    public static final String RIGHT_MARGIN = "Right Margin";
    public static final String FOOTER = "Footer";
    public static final HashMap elements = new HashMap();
    private String decorationType;
    private Document content;

    public PageDecorationInfo(String decorationType) {
        this(decorationType, XMLHelper.createDocument());
        Element e = this.content.createElement((String)elements.get(decorationType));
        this.content.appendChild(e);
    }

    public PageDecorationInfo(String decorationType, Document content) {
        this.decorationType = decorationType;
        this.content = content;
    }

    public Document getContent() {
        return this.content;
    }

    public void setContent(Document content) {
        this.content = content;
    }

    public String toString() {
        return this.decorationType;
    }

    public String getDecorationType() {
        return this.decorationType;
    }

    public String getElement() {
        return (String)elements.get(this.decorationType);
    }

    public boolean isHeader() {
        return this.decorationType == HEADER;
    }

    public boolean isLeftMargin() {
        return this.decorationType == LEFT_MARGIN;
    }

    public boolean isRightMargin() {
        return this.decorationType == RIGHT_MARGIN;
    }

    public boolean isFooter() {
        return this.decorationType == FOOTER;
    }

    static {
        elements.put(HEADER, "header");
        elements.put(LEFT_MARGIN, "left-margin");
        elements.put(RIGHT_MARGIN, "right-margin");
        elements.put(FOOTER, "footer");
    }
}

