/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.content.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xissweb.data.content.ImageDescInfo;
import org.xissweb.data.content.ImageInfo;
import org.xissweb.data.content.ImageMetaData;
import org.xissweb.data.content.SectionInfo;
import org.xissweb.data.content.SlideShowContentInfo;
import org.xissweb.data.content.SlideShowRefInfo;
import org.xissweb.data.content.xml.ContentSchema;
import org.xissweb.xml.XMLHelper;

public class ContentSerializer
implements ContentSchema {
    private String encoding;

    public ContentSerializer() {
        this(null);
    }

    public ContentSerializer(String encoding) {
        this.encoding = encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void serialize(String fileName, SlideShowContentInfo slideShow) {
        this.serialize(new File(fileName), slideShow);
    }

    public void serialize(File file, SlideShowContentInfo slideShow) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            this.serialize(out, slideShow);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void serialize(SlideShowContentInfo slideshow) {
        this.serialize(slideshow.getFile(), slideshow);
    }

    public void serialize(OutputStream out, SlideShowContentInfo slideShow) {
        Document outDoc = XMLHelper.createDocument();
        this.serialize(outDoc, slideShow);
        if (this.encoding == null) {
            this.encoding = slideShow.getEncoding();
        }
        XMLHelper.serialize(outDoc, out, this.encoding);
    }

    public void serialize(Document outDoc, SlideShowContentInfo slideShow) {
        Element root = outDoc.createElement("slideshow-content");
        outDoc.appendChild(root);
        root.setAttribute("name", slideShow.getName());
        Element eltInfo = outDoc.createElement("info");
        eltInfo.setAttribute("title", slideShow.getTitle().getValue());
        if (slideShow.getDescription().isHtmlContent()) {
            eltInfo.appendChild(XMLHelper.copyDocumentNode(outDoc, slideShow.getDescription().getHtmlValue().getDocumentElement()));
        } else {
            eltInfo.setAttribute("description", slideShow.getDescription().getStringValue());
        }
        root.appendChild(eltInfo);
        if (slideShow.hasPreviousLink()) {
            root.appendChild(this.serialize(outDoc, "previous-show", slideShow.getPrevious()));
        }
        if (slideShow.hasNextLink()) {
            root.appendChild(this.serialize(outDoc, "next-show", slideShow.getNext()));
        }
        Element eltSections = outDoc.createElement("images");
        eltSections.setAttribute("images", slideShow.getImagesDirName());
        eltSections.setAttribute("thumbnails", slideShow.getThumbnailsDirName());
        Iterator i = slideShow.getSections().iterator();
        while (i.hasNext()) {
            eltSections.appendChild(this.serialize(outDoc, (SectionInfo)i.next()));
        }
        root.appendChild(eltSections);
    }

    private Node serialize(Document outDoc, SectionInfo section) {
        Element elt = outDoc.createElement("section");
        String value = section.getTitle();
        if (value != null) {
            elt.setAttribute("title", value);
        }
        Iterator i = section.getImages().iterator();
        while (i.hasNext()) {
            elt.appendChild(this.serialize(outDoc, (ImageInfo)i.next()));
        }
        return elt;
    }

    private Node serialize(Document outDoc, ImageInfo image) {
        Element elt = outDoc.createElement("image");
        elt.setAttribute("number", Integer.toString(image.getNumber()));
        elt.setAttribute("filename", image.getFileName());
        if (image.isHtmlContent()) {
            elt.appendChild(XMLHelper.copyDocumentNode(outDoc, image.getHtmlComment().getDocumentElement()));
        } else {
            elt.setAttribute("comment", image.getComment());
        }
        if (image.getMetaData() != null) {
            elt.appendChild(this.serialise(outDoc, image.getMetaData()));
        }
        elt.appendChild(this.serialize(outDoc, "main-image", image.getMainImageDesc()));
        if (image.hasOriginalImage()) {
            elt.appendChild(this.serialize(outDoc, "original-image", image.getOriginalImageDesc()));
        }
        if (image.hasThumbnail()) {
            elt.appendChild(this.serialize(outDoc, "thumbnail", image.getThumbnailDesc()));
        }
        return elt;
    }

    private Node serialise(Document outDoc, ImageMetaData metaData) {
        Element e = outDoc.createElement("meta-data");
        switch (metaData.getImageType()) {
            case 0: {
                e.setAttribute("type", "digital");
                break;
            }
            case 1: {
                e.setAttribute("type", "film");
                break;
            }
            case 2: {
                e.setAttribute("type", "processing");
                break;
            }
            case 3: {
                e.setAttribute("type", "unknown");
            }
        }
        Iterator<Object> i = metaData.getMetadatas().keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = metaData.get(key);
            if (value == null) continue;
            e.setAttribute(key, value);
        }
        return e;
    }

    private Node serialize(Document outDoc, String tagName, ImageDescInfo imgDesc) {
        Element elt = outDoc.createElement(tagName);
        elt.setAttribute("extention", imgDesc.getExtension());
        elt.setAttribute("width", Integer.toString(imgDesc.getWidth()));
        elt.setAttribute("height", Integer.toString(imgDesc.getHeight()));
        return elt;
    }

    private Node serialize(Document outDoc, String tagName, SlideShowRefInfo refShow) {
        Element elt = outDoc.createElement(tagName);
        elt.setAttribute("href", refShow.getHref());
        elt.setAttribute("text", refShow.getText());
        return elt;
    }
}

