/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.content.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.xerces.parsers.SAXParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xissweb.data.content.ImageDescInfo;
import org.xissweb.data.content.ImageInfo;
import org.xissweb.data.content.ImageMetaData;
import org.xissweb.data.content.SectionInfo;
import org.xissweb.data.content.SlideShowContentInfo;
import org.xissweb.data.content.xml.ContentSchema;
import org.xissweb.xml.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ContentDeserializer
extends DefaultHandler
implements ContentSchema {
    SlideShowContentInfo slideShow = null;
    SectionInfo section = null;
    ArrayList images;
    ArrayList sections;
    ImageInfo image;
    private Document htmlDoc = null;
    private Element currentElement = null;
    private String encoding;

    public SlideShowContentInfo deserialize(File file) {
        this.slideShow = null;
        this.section = null;
        this.encoding = XMLHelper.getEncoding(file);
        try {
            SAXParser parser = XMLHelper.getSAXPerser(this);
            FileInputStream in = new FileInputStream(file);
            parser.parse(new InputSource(in));
            ((InputStream)in).close();
            this.slideShow.setFile(file);
            this.slideShow.setEncoding(this.encoding);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return this.slideShow;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String str;
        if (this.currentElement != null && (str = new String(ch, start, length)).length() > 0) {
            this.currentElement.appendChild(this.htmlDoc.createTextNode(str));
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.htmlDoc != null) {
            Element e = this.htmlDoc.createElement(localName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                e.setAttribute(attributes.getLocalName(i), attributes.getValue(i));
            }
            this.currentElement.appendChild(e);
            this.currentElement = e;
        } else if (localName.equals("slideshow-content")) {
            this.slideShow = new SlideShowContentInfo();
            this.slideShow.setName(attributes.getValue("name"));
            this.sections = new ArrayList();
        } else if (localName.equals("info")) {
            if (XMLHelper.hasAttribute(attributes, "theme")) {
                this.slideShow.getTitle().setValue(attributes.getValue("theme"));
                this.slideShow.getTitle().setValue(attributes.getValue("title"));
            } else {
                this.slideShow.getTitle().setValue(attributes.getValue("title"));
                this.slideShow.getDescription().setStringValue(attributes.getValue("description"));
            }
        } else if (localName.equals("htmlDescription")) {
            this.htmlDoc = this.initHtmlDoc(localName);
        } else if (localName.equals("images")) {
            this.slideShow.setImagesDirName(attributes.getValue("images"));
            this.slideShow.setThumbnailsDirName(attributes.getValue("thumbnails"));
        } else if (localName.equals("previous-show")) {
            this.slideShow.setPrevious(attributes.getValue("href"), attributes.getValue("text"));
        } else if (localName.equals("next-show")) {
            this.slideShow.setNext(attributes.getValue("href"), attributes.getValue("text"));
        } else if (localName.equals("section")) {
            this.deserializeSection(attributes);
        } else if (localName.equals("image")) {
            this.image = this.deserializeImage(attributes);
        } else if (localName.equals("htmlComment")) {
            this.htmlDoc = this.initHtmlDoc(localName);
        } else if (localName.equals("meta-data")) {
            this.image.setMetaData(this.deserializeMetaData(attributes));
        } else if (localName.equals("main-image")) {
            this.image.setMainImageDesc(this.deserializeImageDesc(attributes));
        } else if (localName.equals("original-image")) {
            this.image.setOriginalImageDesc(this.deserializeImageDesc(attributes));
        } else if (localName.equals("thumbnail")) {
            this.image.setThumbnailDesc(this.deserializeImageDesc(attributes));
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (localName.equals("image")) {
            this.images.add(this.image);
            this.image = null;
        } else if (localName.equals("section")) {
            this.section.setImages(this.images);
            this.images = null;
        } else if (localName.equals("slideshow-content")) {
            this.slideShow.setSections(this.sections);
            this.section = null;
            this.sections = null;
        } else if (localName.equals("htmlDescription")) {
            this.slideShow.getDescription().setHtmlValue(this.htmlDoc);
            this.htmlDoc = null;
            this.currentElement = null;
        } else if (localName.equals("htmlComment")) {
            this.image.setHtmlValue(this.htmlDoc);
            this.htmlDoc = null;
            this.currentElement = null;
        } else if (this.htmlDoc != null) {
            this.currentElement = (Element)this.currentElement.getParentNode();
        }
    }

    private void deserializeSection(Attributes att) {
        this.section = new SectionInfo();
        String title = att.getValue("title");
        if (title != null) {
            this.section.setTitle(title);
        }
        this.sections.add(this.section);
        this.images = new ArrayList();
    }

    private ImageInfo deserializeImage(Attributes att) {
        String name = att.getValue("filename");
        int number = Integer.parseInt(att.getValue("number"));
        ImageInfo iInfo = new ImageInfo(name, number);
        iInfo.setStringValue(att.getValue("comment"));
        return iInfo;
    }

    private ImageMetaData deserializeMetaData(Attributes att) {
        String type = att.getValue("type");
        int mDataType = 3;
        if (type == null) {
            mDataType = 0;
        } else if (type.equals("digital")) {
            mDataType = 0;
        } else if (type.equals("argentic") || type.equals("film")) {
            mDataType = 1;
        } else if (type.equals("processing")) {
            mDataType = 2;
        } else if (type.equals("unknown")) {
            mDataType = 3;
        }
        ImageMetaData metaData = new ImageMetaData(mDataType);
        for (int i = 0; i < att.getLength(); ++i) {
            String key = att.getLocalName(i);
            if (mDataType == 0 && key.equals("flash")) {
                String v = att.getValue(i);
                if (v == null) continue;
                if (v.equals("yes") || v.equals("no")) {
                    metaData.put(key, v);
                    continue;
                }
                metaData.put(key, v.startsWith("no") || v.startsWith("sans") ? "no" : "yes");
                continue;
            }
            metaData.put(key, att.getValue(i));
        }
        return metaData;
    }

    private ImageDescInfo deserializeImageDesc(Attributes att) {
        ImageDescInfo imgDesc = new ImageDescInfo();
        imgDesc.setExtension(att.getValue("extention"));
        imgDesc.setWidth(Integer.parseInt(att.getValue("width")));
        imgDesc.setHeight(Integer.parseInt(att.getValue("height")));
        return imgDesc;
    }

    private Document initHtmlDoc(String rootTag) {
        this.htmlDoc = XMLHelper.createDocument();
        this.currentElement = this.htmlDoc.createElement(rootTag);
        this.htmlDoc.appendChild(this.currentElement);
        return this.htmlDoc;
    }
}

