/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DocChecker
extends DefaultHandler {
    private String eltName;
    private String sectionId = "";
    private int eltCount;
    private boolean trace = false;

    public static void main(String[] args) {
        System.out.println("DocChecker");
        File f = new File(args[0]);
        String eltName = args[1];
        DocChecker checker = new DocChecker(eltName);
        if (args.length > 2) {
            checker.sectionId = args[2];
        }
        SAXParserFactory spFactory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = spFactory.newSAXParser();
            parser.parse(f, (DefaultHandler)checker);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            System.out.println(e.getClass());
            System.out.println(String.valueOf(eltName) + " count = " + checker.eltCount);
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public DocChecker(String eltName) {
        this.eltName = eltName;
        this.eltCount = 0;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equals("section")) {
            this.trace = this.sectionId.equals(attributes.getValue("id"));
            System.out.println("Section \"" + attributes.getValue("id") + "\"");
            this.eltCount = 0;
        } else if (this.trace) {
            System.out.println("ELT " + qName);
        }
        if (qName.equals(this.eltName)) {
            ++this.eltCount;
        }
    }
}

