/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.xml;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLHelper {
    public static String DEFAULT_ENCODING = "UTF-8";
    private static String XMLNS = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
    private static String SCHEMA_LOC_ATT = "xsi:noNamespaceSchemaLocation";
    private static TransformerFactory transformerFactory;
    private static final XMLHelper instance;
    private static final String TRUE_VALUE;

    private XMLHelper() {
    }

    public static String getXMLHeader(String encoding) {
        return "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>";
    }

    public static SAXParser getSAXPerser(ContentHandler handler) {
        SAXParser parser = new SAXParser();
        try {
            parser.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            parser.setContentHandler(handler);
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        catch (SAXNotSupportedException e) {
            e.printStackTrace();
        }
        return parser;
    }

    public static Document createDocument() {
        return new DocumentImpl();
    }

    public static Document cloneDoc(Document doc) {
        Document copy = null;
        try {
            TransformerFactory tf = XMLHelper.getTransformerFactory();
            Transformer t = tf.newTransformer();
            DOMSource s = new DOMSource(doc);
            DOMResult r = new DOMResult();
            t.transform(s, r);
            copy = (Document)r.getNode();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return copy;
    }

    public static Transformer getTransformer(File xslFile) throws TransformerConfigurationException {
        StreamSource source = new StreamSource(xslFile.toURI().toString());
        return XMLHelper.getTransformerFactory().newTransformer(source);
    }

    public static void transform(Transformer transformer, File sFile, File file) {
        XMLHelper.transform(transformer, new StreamSource(sFile), file);
    }

    public static void transform(Transformer transformer, Source source, File file) {
        try {
            transformer.transform(source, new StreamResult(file.getAbsolutePath()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transform(Transformer transformer, Source source, File file, String encoding) throws IOException {
        transformer.setOutputProperty("encoding", encoding);
        FileOutputStream fileOut = new FileOutputStream(file);
        OutputStreamWriter wOut = new OutputStreamWriter((OutputStream)fileOut, encoding);
        try {
            transformer.transform(source, new StreamResult(wOut));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        finally {
            ((Writer)wOut).close();
            fileOut.close();
        }
    }

    private static TransformerFactory getTransformerFactory() {
        if (transformerFactory == null) {
            System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }

    public static String getEncoding(File xmlFile) {
        String code = null;
        try {
            FileReader r = new FileReader(xmlFile);
            BufferedReader f = new BufferedReader(r);
            String line = f.readLine();
            if (line != null) {
                code = XMLHelper.getEncoding(line);
            }
            f.close();
            r.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return code;
    }

    public static String getEncoding(String doc) {
        String code = null;
        int pos = doc.indexOf("encoding");
        if (pos >= 0) {
            int i1 = doc.indexOf("\"", pos);
            int i2 = doc.indexOf("\"", i1 + 1);
            code = doc.substring(i1 + 1, i2);
        }
        return code;
    }

    public static boolean hasAttribute(Element e, String attName) {
        return e.hasAttribute(attName);
    }

    public static boolean hasAttribute(Attributes attributes, String attName) {
        return attributes.getValue(attName) != null;
    }

    public static String getAttributeValue(Element e, String attName) {
        String value = null;
        Attr a = e.getAttributeNode(attName);
        if (a != null) {
            value = a.getNodeValue();
        }
        return value;
    }

    public static String getAttributeValue(Attributes attributes, String attName) {
        return attributes.getValue(attName);
    }

    public static String getAttributeValue(Attributes attributes, String attName, String defaultValue) {
        String value = attributes.getValue(attName);
        return value == null ? defaultValue : value;
    }

    public static String getAttributeValue(Element e, String attName, String defaultValue) {
        Attr a = e.getAttributeNode(attName);
        return a == null ? defaultValue : a.getNodeValue();
    }

    public static int getIntAttributValue(Element e, String attName) {
        return Integer.parseInt(XMLHelper.getAttributeValue(e, attName));
    }

    public static int getIntAttributValue(Attributes attributes, String attName) {
        return Integer.parseInt(attributes.getValue(attName));
    }

    public static String valueOf(Document document, String encoding, boolean encodeOut) {
        Element e = document.getDocumentElement();
        String result = "";
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLHelper.serialize(document, out, encoding);
            result = encodeOut ? out.toString(encoding) : out.toString();
            String tagIn = "<" + e.getNodeName() + ">";
            String tagOut = "</" + e.getNodeName() + ">";
            int i0 = result.indexOf(tagIn);
            int iN = result.indexOf(tagOut);
            if (i0 > 0 && iN > 0) {
                result = result.substring(i0 + tagIn.length(), iN);
            } else {
                String tag = "<" + e.getNodeName() + "/>";
                int i = result.indexOf(tag);
                if (i > 0) {
                    result = result.substring(i + tag.length());
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return result.trim();
    }

    public static void serialize(Document doc, OutputStream out, String encoding) {
        try {
            OutputFormat outputFormat = new OutputFormat(doc, encoding, true);
            outputFormat.setPreserveSpace(false);
            outputFormat.setLineWidth(0);
            XMLSerializer serializer = new XMLSerializer(out, outputFormat);
            serializer.serialize(doc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void serialize(Document doc, OutputStream out) {
        XMLHelper.serialize(doc, out, DEFAULT_ENCODING);
    }

    public static String addXMLHeader(String value, String tagName, String encoding) {
        StringBuffer buff = new StringBuffer();
        buff.append(XMLHelper.getXMLHeader(encoding)).append("\n");
        buff.append("<" + tagName + ">").append(value.trim()).append("</" + tagName + ">");
        return buff.toString();
    }

    public static Document buildDocument(String tagName, String value, String encoding) throws SAXException {
        String docString = XMLHelper.addXMLHeader(value, tagName, encoding);
        Document doc = XMLHelper.createDocument();
        CreateElementParseHandler handler = instance.createElementParseHandler(doc);
        SAXParser parser = XMLHelper.getSAXPerser(handler);
        try {
            StringReader reader = new StringReader(docString);
            parser.parse(new InputSource(reader));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return doc;
    }

    public static final String addSchemaInfo(String value, String rootTagName, File xsdFile) {
        String schemaInfo = " " + XMLNS + " " + SCHEMA_LOC_ATT + "=\"" + xsdFile.getAbsolutePath().replace('\\', '/') + '\"';
        StringBuffer buff = new StringBuffer(value);
        int index = buff.indexOf(rootTagName);
        buff.insert(index + rootTagName.length(), schemaInfo);
        return buff.toString();
    }

    private CreateElementParseHandler createElementParseHandler(Document document) {
        return new CreateElementParseHandler(document);
    }

    public static boolean toBoolean(String value) {
        return TRUE_VALUE.equals(value);
    }

    public static String serialize(boolean value) {
        return Boolean.toString(value);
    }

    public static Node copyDocumentNode(Document document, Node node) {
        if (node.getNodeType() == 1) {
            Element en = (Element)node;
            Element e = document.createElement(en.getTagName());
            NamedNodeMap attrs = en.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                e.setAttribute(attr.getName(), attr.getValue());
            }
            NodeList nl = en.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                e.appendChild(XMLHelper.copyDocumentNode(document, nl.item(i)));
            }
            return e;
        }
        if (node.getNodeType() == 3) {
            Text txt = (Text)node;
            return document.createTextNode(txt.getData());
        }
        return null;
    }

    static {
        instance = new XMLHelper();
        TRUE_VALUE = Boolean.toString(true);
    }

    class CreateElementParseHandler
    extends DefaultHandler {
        Document document = null;
        Element element = null;
        Element current = null;
        StringBuffer txtBuffer;

        CreateElementParseHandler(Document document) {
            this.document = document;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String str = new String(ch, start, length);
            if (str.length() > 0) {
                this.current.appendChild(this.document.createTextNode(str));
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Element e = this.document.createElement(localName);
            if (this.document.getDocumentElement() == null) {
                this.document.appendChild(e);
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                e.setAttribute(attributes.getLocalName(i), attributes.getValue(i));
            }
            if (this.current == null) {
                this.element = e;
                this.current = e;
            } else {
                this.current.appendChild(e);
                this.current = e;
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            Node n = this.current.getParentNode();
            if (n.getNodeType() == 1) {
                this.current = (Element)this.current.getParentNode();
            }
        }
    }
}

