/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.produce;

import java.io.File;
import java.io.FileFilter;
import java.util.Set;
import org.xissweb.produce.AbstractDirectoryAction;
import org.xissweb.project.SlideShowProperties;

public class SlideShowFileFilter
implements FileFilter {
    private int directoryFilterType = 0;
    private String imageDirName;
    private String thumbnailsDirName;
    private Set selectedDirs;

    public SlideShowFileFilter(SlideShowProperties properties) {
        this(properties, null);
    }

    public SlideShowFileFilter(SlideShowProperties properties, Set selectedDirs) {
        if (properties.getImageDirFilter() == "except") {
            this.directoryFilterType = 1;
        }
        this.imageDirName = properties.getImageDirName();
        this.thumbnailsDirName = properties.getThumbnailDirName();
        this.selectedDirs = selectedDirs;
    }

    public boolean accept(File f) {
        boolean ok = false;
        if (f.isDirectory() && !f.getName().equals(this.thumbnailsDirName) && AbstractDirectoryAction.isSelectedDir(f, this.selectedDirs)) {
            ok = true;
            switch (this.directoryFilterType) {
                case 0: {
                    ok = !f.getName().equals(this.imageDirName);
                }
            }
        }
        return ok;
    }
}

