/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.image;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import org.xissweb.file.FileHelper;

public class ImageFileHelper {
    public static final int IMAGE_DIRECTORY_ONLY = 0;
    public static final int IMAGE_DIRECTORY_EXCEPT = 1;
    public static final FilenameFilter imageFileFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return ImageFileHelper.isImageFile(name);
        }
    };
    public static final FileFilter nonImageFileFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.isFile() && !ImageFileHelper.isImageFile(file.getName());
        }
    };

    public static File[] listImageFiles(File directory) {
        return directory.listFiles(imageFileFilter);
    }

    public static boolean hasImageFiles(File directory) {
        File[] files = ImageFileHelper.listImageFiles(directory);
        return files == null ? false : files.length > 0;
    }

    public static int countImageFiles(File directory) {
        File[] files = ImageFileHelper.listImageFiles(directory);
        return files == null ? 0 : files.length;
    }

    public static boolean isImageFile(File imageFile) {
        return ImageFileHelper.isImageFile(imageFile.getName());
    }

    public static boolean isImageFile(String imageFileName) {
        String ext = FileHelper.fileNameExtention((String)imageFileName);
        return ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg") || ext.equalsIgnoreCase("gif") || ext.equalsIgnoreCase("png");
    }

    public static File imageFile(File directory, final String name) {
        File[] files = directory.listFiles(new FileFilter(){

            public boolean accept(File f) {
                String fName = f.getName();
                if (fName.startsWith(name)) {
                    return ImageFileHelper.isImageFile(fName);
                }
                return false;
            }
        });
        return files != null && files.length > 0 ? files[0] : null;
    }
}

