/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.properties.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.xissweb.gui.properties.PropertyEditorObserver;
import org.xissweb.gui.properties.PropertyValueEditor;

public class PropertyStringEditor
extends JPanel
implements PropertyValueEditor {
    private static final long serialVersionUID = 485697118583481188L;
    private JTextField valueField = null;
    private String propertyKey;
    private String initValue;
    private String defaultValue;
    private HashSet observers = new HashSet();

    public PropertyStringEditor() {
        this.initialize();
    }

    private void initialize() {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setVgap(10);
        flowLayout.setHgap(0);
        this.setLayout(flowLayout);
        this.add((Component)this.getValueField(), null);
    }

    private JTextField getValueField() {
        if (this.valueField == null) {
            this.valueField = new JTextField();
            this.valueField.setPreferredSize(new Dimension(350, 20));
            this.valueField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    PropertyStringEditor.this.textChanged();
                }
            });
            this.valueField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    PropertyStringEditor.this.textChanged();
                }
            });
        }
        return this.valueField;
    }

    void textChanged() {
        this.notifyObservers(this.valueField.getText());
    }

    public void registerEditorObserver(PropertyEditorObserver observer) {
        this.observers.add(observer);
    }

    private void notifyObservers(String value) {
        String v = value;
        if (v.length() == 0) {
            v = null;
        }
        Iterator i = this.observers.iterator();
        while (i.hasNext()) {
            PropertyEditorObserver observer = (PropertyEditorObserver)i.next();
            observer.propertyValueEdited(this.propertyKey, v);
        }
    }

    public void initEdition(String propKey, String value, String defaultValue, String[] values) {
        this.propertyKey = propKey;
        this.initValue = value;
        this.defaultValue = defaultValue;
        this.reset();
    }

    public void reset() {
        if (this.initValue != null) {
            this.valueField.setText(this.initValue);
        } else {
            this.valueField.setText(this.defaultValue);
        }
    }
}

