/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.project;

import java.awt.Component;
import java.io.File;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.project.AbstractNewProjectDialog;
import org.xissweb.gui.project.repository.NewRepositoryProjectDialog;
import org.xissweb.gui.util.LabelCellRenderer;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.image.ImageFileHelper;

public class FileNewProjectTreeCellRenderer
extends LabelCellRenderer
implements TreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final String DIRECTORY_ICON = "/images/file/directory.png";
    private static final String SRC_DIRECTORY_ICON = "/images/file/directory-src.png";
    private static final String IMAGE_ICON = "/images/file/image-file.png";
    private static final String IMAGE_REPOSITORY_ICON = "/images/file/repository.png";
    private static final String PROJECT_ROOT_ICON = "/images/file/project-directory.png";
    private TextDisplayer textDisplayer;
    private AbstractNewProjectDialog newProjectDialog;
    static /* synthetic */ Class class$org$xissweb$gui$project$FileNewProjectTreeCellRenderer;

    public FileNewProjectTreeCellRenderer(AbstractNewProjectDialog newProjectDialog) {
        this.newProjectDialog = newProjectDialog;
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(class$org$xissweb$gui$project$FileNewProjectTreeCellRenderer == null ? (class$org$xissweb$gui$project$FileNewProjectTreeCellRenderer = FileNewProjectTreeCellRenderer.class$("org.xissweb.gui.project.FileNewProjectTreeCellRenderer")) : class$org$xissweb$gui$project$FileNewProjectTreeCellRenderer);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setIcon(null);
        this.cellSelected = sel;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object uo = node.getUserObject();
        String data = "";
        if (uo instanceof File) {
            NewRepositoryProjectDialog dialog;
            File file = (File)uo;
            data = file.getName();
            if (file.isDirectory()) {
                this.setIcon(file.equals(this.newProjectDialog.getSrcDirectory()) ? XissWebUI.getIcon(SRC_DIRECTORY_ICON) : XissWebUI.getIcon(DIRECTORY_ICON));
            } else if (ImageFileHelper.isImageFile(file)) {
                this.setIcon(XissWebUI.getIcon(IMAGE_ICON));
            }
            if (node.isRoot()) {
                this.setIcon(XissWebUI.getIcon(PROJECT_ROOT_ICON));
                if (this.newProjectDialog instanceof NewRepositoryProjectDialog && (dialog = (NewRepositoryProjectDialog)this.newProjectDialog).getRepositoryLocation() != null && dialog.getProjectLocation() == null) {
                    this.setIcon(XissWebUI.getIcon(IMAGE_REPOSITORY_ICON));
                }
            }
            if (file.isDirectory() && this.newProjectDialog instanceof NewRepositoryProjectDialog && file.equals((dialog = (NewRepositoryProjectDialog)this.newProjectDialog).getRepositoryLocation())) {
                this.setIcon(XissWebUI.getIcon(IMAGE_REPOSITORY_ICON));
            }
        } else if (uo instanceof Integer) {
            switch ((Integer)uo) {
                case 0: {
                    data = this.textDisplayer.getString("project.choose.location");
                    this.setIcon(XissWebUI.getIcon(PROJECT_ROOT_ICON));
                    break;
                }
                case 1: {
                    data = this.textDisplayer.getString("project.repository.choose.location");
                    this.setIcon(XissWebUI.getIcon(PROJECT_ROOT_ICON));
                    break;
                }
                case 2: {
                    data = this.textDisplayer.getString("project.choose.repository");
                    this.setIcon(XissWebUI.getIcon(IMAGE_REPOSITORY_ICON));
                }
            }
        }
        String txt = tree.convertValueToText(data, sel, expanded, leaf, row, hasFocus);
        this.setText(txt);
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

