/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout;

import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xissweb.data.layout.AnimationInfo;
import org.xissweb.data.layout.Arrangeable;
import org.xissweb.data.layout.ArrangementInfo;
import org.xissweb.data.layout.ImageAreaInfo;
import org.xissweb.data.layout.LocalIndexInfo;
import org.xissweb.data.layout.LocationOnMapInfo;
import org.xissweb.data.layout.NavigationBarInfo;
import org.xissweb.data.layout.PageDecorationInfo;
import org.xissweb.data.layout.SkinInfo;
import org.xissweb.data.layout.SlideShowLayoutInfo;
import org.xissweb.data.layout.ThumbnailsInfo;
import org.xissweb.data.layout.ThumbnailsInfoInfo;
import org.xissweb.gui.util.tree.TreeModel;

public class LayoutTreeModel
extends TreeModel {
    private static final long serialVersionUID = -8331989824195761270L;
    private SlideShowLayoutInfo layoutInfo;

    public LayoutTreeModel() {
        super(new DefaultMutableTreeNode("Root"));
        this.layoutInfo = null;
    }

    public LayoutTreeModel(SlideShowLayoutInfo layoutInfo) {
        super(new DefaultMutableTreeNode("Root"));
        this.layoutInfo = layoutInfo;
        this.init();
    }

    protected void init() {
        AnimationInfo anim;
        DefaultMutableTreeNode theRoot = (DefaultMutableTreeNode)this.getRoot();
        theRoot.setUserObject(this.layoutInfo);
        SkinInfo skin = this.layoutInfo.getSkin();
        if (skin != null) {
            theRoot.add(this.createNode(skin));
        }
        if ((anim = this.layoutInfo.getAnimation()) != null) {
            theRoot.add(this.createNode(anim));
        }
        theRoot.add(this.createNode(this.layoutInfo.getThumbnailsInfo()));
        PageDecorationInfo deco = this.layoutInfo.getHeader();
        if (deco != null) {
            theRoot.add(this.createNode(deco));
        }
        if ((deco = this.layoutInfo.getLeftMargin()) != null) {
            theRoot.add(this.createNode(deco));
        }
        if ((deco = this.layoutInfo.getRightMargin()) != null) {
            theRoot.add(this.createNode(deco));
        }
        if ((deco = this.layoutInfo.getFooter()) != null) {
            theRoot.add(this.createNode(deco));
        }
        theRoot.add(this.createNode(this.layoutInfo.getArrangement()));
    }

    DefaultMutableTreeNode createNode(Arrangeable a) {
        if (a instanceof ArrangementInfo) {
            return this.createNode((ArrangementInfo)a);
        }
        if (a instanceof ImageAreaInfo) {
            return this.createNode((ImageAreaInfo)a);
        }
        if (a instanceof NavigationBarInfo) {
            return this.createNode((NavigationBarInfo)a);
        }
        if (a instanceof ThumbnailsInfo) {
            return this.createNode((ThumbnailsInfo)a);
        }
        return null;
    }

    DefaultMutableTreeNode createNode(SkinInfo skin) {
        return new DefaultMutableTreeNode(skin);
    }

    DefaultMutableTreeNode createNode(AnimationInfo anim) {
        return new DefaultMutableTreeNode(anim);
    }

    DefaultMutableTreeNode createNode(PageDecorationInfo deco) {
        return new DefaultMutableTreeNode(deco);
    }

    DefaultMutableTreeNode createNode(ArrangementInfo arrangement) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(arrangement);
        List list = arrangement.getComponents();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof ArrangementInfo) {
                node.add(this.createNode((ArrangementInfo)o));
                continue;
            }
            if (o instanceof ImageAreaInfo) {
                node.add(this.createNode((ImageAreaInfo)o));
                continue;
            }
            if (o instanceof NavigationBarInfo) {
                node.add(this.createNode((NavigationBarInfo)o));
                continue;
            }
            if (!(o instanceof ThumbnailsInfo)) continue;
            node.add(this.createNode((ThumbnailsInfo)o));
        }
        return node;
    }

    DefaultMutableTreeNode createNode(ThumbnailsInfo thumbnails) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(thumbnails);
        return node;
    }

    DefaultMutableTreeNode createNode(NavigationBarInfo navigationBar) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(navigationBar);
        return node;
    }

    DefaultMutableTreeNode createNode(ImageAreaInfo imageArea) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(imageArea);
        if (imageArea.hasLocalIndex()) {
            node.add(this.createNode(imageArea.getLocalIndexInfo()));
        }
        if (imageArea.hasImageLocationOnMap()) {
            node.add(this.createNode(imageArea.getLocationOnMap()));
        }
        return node;
    }

    DefaultMutableTreeNode createNode(ThumbnailsInfoInfo thumbnailsInfo) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(thumbnailsInfo);
        return node;
    }

    DefaultMutableTreeNode createNode(LocalIndexInfo indexInfo) {
        return new DefaultMutableTreeNode(indexInfo);
    }

    DefaultMutableTreeNode createNode(LocationOnMapInfo locationOnMapInfo) {
        return new DefaultMutableTreeNode(locationOnMapInfo);
    }
}

