/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.content.links;

import java.awt.Component;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.xissweb.data.content.SlideShowContentInfo;
import org.xissweb.data.content.SlideShowRefInfo;
import org.xissweb.file.FileHelper;
import org.xissweb.gui.Main;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.util.LabelCellRenderer;

public class LinksManagerTreeCellRenderer
extends LabelCellRenderer
implements TreeCellRenderer {
    private static final long serialVersionUID = -3827623027914277298L;
    private static final String PROJECT_ROOT_ICON = "/images/file/project-directory.png";
    private static final String CONTENT_SLIDE_SOW_ICON = "/images/file/content.png";
    private static final String CONTENT_NEXT_ICON = "/images/content/next.png";
    private static final String CONTENT_PREVIOUS_ICON = "/images/content/previous.png";

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.cellSelected = sel;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        if (node.isRoot()) {
            this.setText(tree.convertValueToText(node.getUserObject().toString(), sel, expanded, leaf, row, hasFocus));
            this.setIcon(XissWebUI.getIcon(PROJECT_ROOT_ICON));
        } else if (userObject instanceof SlideShowContentInfo) {
            SlideShowContentInfo info = (SlideShowContentInfo)node.getUserObject();
            File dir = info.getFile().getParentFile();
            this.setText(tree.convertValueToText(FileHelper.relativeURL((File)Main.get().getCurrentProject().getSrcDirectory(), (File)dir), sel, expanded, leaf, row, hasFocus));
            this.setIcon(XissWebUI.getIcon(CONTENT_SLIDE_SOW_ICON));
        } else if (node.getUserObject() instanceof SlideShowRefInfo) {
            SlideShowRefInfo link = (SlideShowRefInfo)node.getUserObject();
            String valText = link.isNextLink() ? "\"" + link.getText() + "\" -> " + link.getHref() : link.getHref() + " <- \"" + link.getText() + "\"";
            this.setText(tree.convertValueToText(valText, sel, expanded, leaf, row, hasFocus));
            this.setIcon(link.isNextLink() ? XissWebUI.getIcon(CONTENT_NEXT_ICON) : XissWebUI.getIcon(CONTENT_PREVIOUS_ICON));
        }
        return this;
    }

    public ImageIcon getContentElementIcon(Object contentElement) {
        if (contentElement instanceof SlideShowRefInfo) {
            SlideShowRefInfo link = (SlideShowRefInfo)contentElement;
            return link.isNextLink() ? XissWebUI.getIcon(CONTENT_NEXT_ICON) : XissWebUI.getIcon(CONTENT_PREVIOUS_ICON);
        }
        return null;
    }
}

