/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.xissweb.About;
import org.xissweb.gui.XissWebUI;
import org.xissweb.i18n.TextDisplayer;

public class NewVersionDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String urlInfoBase = "http://xissweb.free.fr/version/versionInfo";
    private static final String urlInfoSuffixe = ".html";
    private static final int infoHeight = 300;
    private static final int dialogWidth = 600;
    private static final int dialogHeight = 200;
    private static final int deltaHeight = 25;
    public static final int CLOSE_OPTION = -1;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    private TextDisplayer textDisplayer = new TextDisplayer(class$org$xissweb$gui$NewVersionDialog == null ? (class$org$xissweb$gui$NewVersionDialog = NewVersionDialog.class$("org.xissweb.gui.NewVersionDialog")) : class$org$xissweb$gui$NewVersionDialog);
    private int option;
    private JPanel jContentPane = null;
    private JLabel bannerLabel = null;
    private JPanel controlPanel = null;
    private JButton yesButton = null;
    private JButton noButton = null;
    private JPanel mainPanel = null;
    private JTextArea mainTextArea = null;
    private JEditorPane infoTextPane = null;
    private JButton moreInfoButton = null;
    private JScrollPane infoScrollPane = null;
    static /* synthetic */ Class class$org$xissweb$gui$NewVersionDialog;

    public NewVersionDialog() {
        super((Frame)null, true);
        this.initialize();
    }

    public int showDialog(String latestVersion, boolean explictDemand) {
        this.option = -1;
        StringBuffer buff = new StringBuffer();
        buff.append(this.textDisplayer.getString("current.version.1")).append(' ').append(About.getVersion());
        buff.append(' ').append(this.textDisplayer.getString("current.version.2")).append("\n");
        buff.append(this.textDisplayer.getString("available.version.1")).append(' ').append(latestVersion);
        buff.append(' ').append(this.textDisplayer.getString("available.version.2")).append("\n\n");
        buff.append(this.textDisplayer.getString("request.download"));
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        for (int i = 0; i < gs.length; ++i) {
            GraphicsDevice gd = gs[i];
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle rect = gc.getBounds();
            this.setLocation((rect.width - this.getWidth()) / 2, (rect.height - this.getHeight() - 300) / 2);
        }
        this.mainTextArea.append(buff.toString());
        if (explictDemand) {
            this.getNoButton().setText(this.textDisplayer.getString("no.option.text"));
        } else {
            this.getNoButton().setText(this.textDisplayer.getString("no.later.option.text"));
        }
        this.setVisible(true);
        return this.option;
    }

    private void initialize() {
        this.setTitle(this.textDisplayer.getString("new.version.dialog.title"));
        this.setSize(526, 200);
        this.setContentPane(this.getJContentPane());
        this.pack();
        int w = this.jContentPane.getWidth() - 10;
        this.infoScrollPane.setMinimumSize(new Dimension(w, 300));
        this.infoScrollPane.setPreferredSize(new Dimension(w, 300));
        this.infoScrollPane.setVisible(false);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.bannerLabel = new JLabel();
            this.bannerLabel.setIcon(XissWebUI.getIcon("/images/common/banner.png"));
            this.jContentPane = new JPanel();
            this.jContentPane.setMinimumSize(new Dimension(600, 200));
            this.jContentPane.setPreferredSize(new Dimension(600, 200));
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.bannerLabel, "North");
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getControlPanel() {
        if (this.controlPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(1);
            this.controlPanel = new JPanel();
            this.controlPanel.setLayout(flowLayout);
            this.controlPanel.add((Component)this.getMoreInfoButton(), null);
            this.controlPanel.add((Component)this.getYesButton(), null);
            this.controlPanel.add((Component)this.getNoButton(), null);
        }
        return this.controlPanel;
    }

    private JButton getYesButton() {
        if (this.yesButton == null) {
            this.yesButton = new JButton();
            this.yesButton.setText(this.textDisplayer.getString("yes.download.option.text"));
            this.yesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NewVersionDialog.this.performYes();
                }
            });
        }
        return this.yesButton;
    }

    void performYes() {
        this.option = 0;
        this.setVisible(false);
    }

    private JButton getNoButton() {
        if (this.noButton == null) {
            this.noButton = new JButton();
            this.noButton.setText(this.textDisplayer.getString("no.later.option.text"));
            this.noButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NewVersionDialog.this.performNo();
                }
            });
        }
        return this.noButton;
    }

    void performNo() {
        this.option = 1;
        this.setVisible(false);
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 3.0;
            gridBagConstraints.weighty = 3.0;
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.add((Component)this.getMainTextArea(), gridBagConstraints);
            this.mainPanel.add((Component)this.getControlPanel(), gridBagConstraints1);
            this.mainPanel.add((Component)this.getInfoScrollPane(), gridBagConstraints2);
        }
        return this.mainPanel;
    }

    private JTextArea getMainTextArea() {
        if (this.mainTextArea == null) {
            this.mainTextArea = new JTextArea();
            this.mainTextArea.setFont(XissWebUI.labelBoldFont);
            this.mainTextArea.setRows(5);
            this.mainTextArea.setColumns(20);
            this.mainTextArea.setTabSize(4);
            this.mainTextArea.setEditable(false);
            this.mainTextArea.setEnabled(true);
            this.mainTextArea.setBorder(null);
        }
        return this.mainTextArea;
    }

    private JEditorPane getInfoTextPane() {
        if (this.infoTextPane == null) {
            this.infoTextPane = new JEditorPane();
        }
        return this.infoTextPane;
    }

    private JButton getMoreInfoButton() {
        if (this.moreInfoButton == null) {
            this.moreInfoButton = new JButton();
            this.moreInfoButton.setText(this.textDisplayer.getString("more.info.button"));
            this.moreInfoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NewVersionDialog.this.performMoreInfo();
                }
            });
            this.moreInfoButton.setMargin(new Insets(2, 2, 2, 2));
        }
        return this.moreInfoButton;
    }

    void performMoreInfo() {
        boolean infoVisible;
        boolean bl = infoVisible = !this.infoScrollPane.isVisible();
        if (infoVisible && this.infoTextPane.getText().length() == 0) {
            this.loadInfo();
        }
        this.infoScrollPane.setVisible(infoVisible);
        this.moreInfoButton.setText(this.textDisplayer.getString(infoVisible ? "less.info.button" : "more.info.button"));
        this.jContentPane.setPreferredSize(new Dimension(600, infoVisible ? 525 : 200));
        this.pack();
    }

    private void loadInfo() {
        try {
            URL infoUrl = new URL("http://xissweb.free.fr/version/versionInfo_" + Locale.getDefault().getLanguage() + urlInfoSuffixe);
            if (((HttpURLConnection)infoUrl.openConnection()).getResponseCode() == 404) {
                infoUrl = new URL("http://xissweb.free.fr/version/versionInfo.html");
            }
            this.infoTextPane.setPage(infoUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private JScrollPane getInfoScrollPane() {
        if (this.infoScrollPane == null) {
            this.infoScrollPane = new JScrollPane();
            this.infoScrollPane.setViewportView(this.getInfoTextPane());
        }
        return this.infoScrollPane;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

