/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.layout.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.xerces.parsers.SAXParser;
import org.xissweb.data.layout.SlideShowLayoutInfo;
import org.xissweb.data.layout.xml.FullLayoutDeserialiser;
import org.xissweb.data.layout.xml.LayoutSchema;
import org.xissweb.xml.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MinimalLayoutDeserializer
extends DefaultHandler
implements LayoutSchema {
    private SlideShowLayoutInfo layout;

    public SlideShowLayoutInfo deserialize(File file) {
        this.layout = new SlideShowLayoutInfo();
        this.layout.setFile(file);
        try {
            SAXParser parser = XMLHelper.getSAXPerser(this);
            FileInputStream in = new FileInputStream(file);
            parser.parse(new InputSource(in));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return this.layout;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (localName.equals("skin")) {
            this.layout.setSkin(FullLayoutDeserialiser.createSkinfInfo(attributes));
        } else if (localName.equals("animation")) {
            this.layout.setAnimation(FullLayoutDeserialiser.createAnimationInfo(attributes));
        } else if (localName.equals("thumbnails-info")) {
            this.layout.setThumbnailsInfo(FullLayoutDeserialiser.createThunailsInfoInfo(attributes));
        } else if ("local-index-standard".equals(localName)) {
            this.layout.setLocalIndexInfo(FullLayoutDeserialiser.createLocalIndexSrandard(attributes));
        } else if ("local-index-google-maps".equals(localName)) {
            this.layout.setLocalIndexInfo(FullLayoutDeserialiser.createLocalIndexGoogleMaps(attributes));
        } else if ("image-location-on-map".equals(localName)) {
            this.layout.setImageLocationOnMap(FullLayoutDeserialiser.createGoogleMapsInfo(attributes));
        }
    }
}

