/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xissweb.data.layout.Arrangeable;
import org.xissweb.data.layout.ImageAreaInfo;
import org.xissweb.data.layout.LocalIndexInfo;
import org.xissweb.data.layout.NavigationBarInfo;

public class ArrangementInfo
implements Arrangeable {
    public static final String VERTICAL = "vertical";
    public static final String HORIZONTAL = "horizontal";
    private String orientation;
    private int width = -1;
    private List components = new ArrayList();

    public boolean hasImageArea() {
        Iterator i = this.getComponents().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof ArrangementInfo) {
                return ((ArrangementInfo)o).hasImageArea();
            }
            if (!(o instanceof ImageAreaInfo)) continue;
            return true;
        }
        return false;
    }

    public LocalIndexInfo getLocalIndexInfo() {
        Iterator i = this.getComponents().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof ArrangementInfo) {
                return ((ArrangementInfo)o).getLocalIndexInfo();
            }
            if (!(o instanceof ImageAreaInfo)) continue;
            ImageAreaInfo imgInfo = (ImageAreaInfo)o;
            return imgInfo.hasLocalIndex() ? imgInfo.getLocalIndexInfo() : null;
        }
        return null;
    }

    public boolean hasNavigationBar() {
        Iterator i = this.getComponents().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof ArrangementInfo) {
                return ((ArrangementInfo)o).hasNavigationBar();
            }
            if (!(o instanceof NavigationBarInfo)) continue;
            return true;
        }
        return false;
    }

    public Object clone() {
        ArrangementInfo a = new ArrangementInfo();
        a.setOrientation(this.getOrientation());
        a.setWidth(this.getWidth());
        Iterator i = this.getComponents().iterator();
        while (i.hasNext()) {
            Arrangeable arr = (Arrangeable)i.next();
            a.getComponents().add(arr.clone());
        }
        return a;
    }

    public boolean isHorizontal() {
        return this.orientation.equals(HORIZONTAL);
    }

    public boolean isVertical() {
        return this.orientation.equals(VERTICAL);
    }

    public void setHorizontal() {
        this.orientation = HORIZONTAL;
    }

    public void setVertical() {
        this.orientation = VERTICAL;
    }

    public String toString() {
        return this.orientation;
    }

    public boolean hasWidth() {
        return this.width > 0;
    }

    public List getComponents() {
        return this.components;
    }

    public Arrangeable getNthComponent(int n) {
        return (Arrangeable)this.components.get(n);
    }

    public Arrangeable getFirstComponent() {
        return this.getNthComponent(0);
    }

    public Arrangeable getLastComponent() {
        return this.getNthComponent(this.getComponentsCount() - 1);
    }

    public boolean hasComponents() {
        return !this.components.isEmpty();
    }

    public int getComponentsCount() {
        return this.components.size();
    }

    public void setComponents(List components) {
        components.clear();
        this.components.addAll(components);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }
}

