/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.content;

import java.util.Iterator;
import java.util.Properties;
import org.xissweb.data.imetadata.ImageMetadataSchema;
import org.xissweb.i18n.TextDisplayer;

public class ImageMetaData
implements ImageMetadataSchema {
    private static final String FLASH_YES = "yes";
    public static final String NORTH_TAG = "N";
    public static final String SOUTH_TAG = "S";
    public static final String EAST_TAG = "E";
    public static final String WEST_TAG = "W";
    public static final char DMS_SEPARATOR = ' ';
    public static final String emptyData = "-";
    private static final TextDisplayer textDisplayer = new TextDisplayer(class$org$xissweb$data$content$ImageMetaData == null ? (class$org$xissweb$data$content$ImageMetaData = ImageMetaData.class$("org.xissweb.data.content.ImageMetaData")) : class$org$xissweb$data$content$ImageMetaData);
    public static final int timeSpaceKeyCount = ImageMetadataSchema.timeSpaceMetaDataKeys.length;
    public static final int digitalKeyCount = ImageMetadataSchema.digitalMetaDataKeys.length;
    public static final int filmKeyCount = ImageMetadataSchema.filmMetaDataKeys.length;
    public static final int processingKeyCount = ImageMetadataSchema.processingMetaDataKeys.length;
    public static final int[] imageTypeCounts = new int[]{digitalKeyCount, filmKeyCount, processingKeyCount, timeSpaceKeyCount};
    public static final String[] timeSpaceMetaDataLabelKeys = new String[timeSpaceKeyCount];
    public static final String[] digitalMetaDataLabelKeys = new String[digitalKeyCount];
    public static final String[] filmMetaDataLabelKeys = new String[filmKeyCount];
    public static final String[] processingMetaDataLabelKeys = new String[processingKeyCount];
    public static final Object[] allMetaDataLabelKeys = new Object[]{digitalMetaDataLabelKeys, filmMetaDataLabelKeys, processingMetaDataLabelKeys, timeSpaceMetaDataLabelKeys};
    private int imageType;
    private Properties metadatas;
    static /* synthetic */ Class class$org$xissweb$data$content$ImageMetaData;

    public static String[] getMetaDataLabelKeys(int imageType) {
        return imageType < 0 ? null : (String[])allMetaDataLabelKeys[imageType];
    }

    public static String internationalizeKey(int imageType, int indice) {
        return ImageMetaData.internationalizeKey(ImageMetaData.getMetaDataLabelKeys(imageType)[indice]);
    }

    public static String internationalizeKey(String key) {
        return textDisplayer.getString(key);
    }

    public ImageMetaData() {
        this(3);
    }

    public ImageMetaData(int imageType) {
        this.imageType = imageType;
        this.metadatas = new Properties();
    }

    public int getImageType() {
        return this.imageType;
    }

    public Properties getMetadatas() {
        return this.metadatas;
    }

    public Object clone() {
        ImageMetaData iMetaData = new ImageMetaData(this.imageType);
        iMetaData.updateWith(this);
        return iMetaData;
    }

    public String get(String key) {
        return this.metadatas.getProperty(key);
    }

    public String getDisplayValue(String key) {
        String value = this.metadatas.getProperty(key);
        if (value == null) {
            return emptyData;
        }
        if (key == "flash") {
            return this.flashFired(value) ? textDisplayer.getString("flash.fired") : textDisplayer.getString("no.flash");
        }
        return value;
    }

    public boolean put(String key, String value) {
        String v;
        String old = this.metadatas.getProperty(key);
        String string = v = emptyData.equals(value) ? null : value;
        if (v == null) {
            this.metadatas.remove(key);
        } else {
            this.metadatas.setProperty(key, v);
        }
        return old == null && v != null || old != null && !old.equals(v);
    }

    public boolean update(String key, String value) {
        String v;
        String old = this.metadatas.getProperty(key);
        String string = v = emptyData.equals(value) ? null : value;
        if (v != null && old == null) {
            this.metadatas.setProperty(key, v);
            return true;
        }
        return false;
    }

    private boolean flashFired(String value) {
        return FLASH_YES.equals(value);
    }

    public boolean updateWith(ImageMetaData metaData) {
        boolean updated = false;
        Iterator<Object> i = metaData.metadatas.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            updated = this.put(key, metaData.get(key)) || updated;
        }
        return updated;
    }

    private double degMinutSecondToDegDec(String value) {
        int i1 = value.indexOf(32, 1);
        int deg = Integer.parseInt(value.substring(2, i1));
        int i2 = value.indexOf(32);
        int minute = Integer.parseInt(value.substring(i1 + 1, i2));
        double d = Double.parseDouble(value.substring(i2 + 1)) / 3600.0;
        d += (double)minute / 60.0;
        d += (double)deg;
        if (value.startsWith(SOUTH_TAG) || value.startsWith(WEST_TAG)) {
            d = -d;
        }
        return d;
    }

    public boolean hasGeoLocation() {
        return this.get("latitude") != null && this.get("longitude") != null;
    }

    public double getLatitude() {
        return this.degMinutSecondToDegDec(this.get("latitude"));
    }

    public double getLongitude() {
        return this.degMinutSecondToDegDec(this.get("longitude"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ImageMetaData.timeSpaceMetaDataLabelKeys[0] = "metadata.date.time";
        ImageMetaData.timeSpaceMetaDataLabelKeys[1] = "metadata.latitude";
        ImageMetaData.timeSpaceMetaDataLabelKeys[2] = "metadata.longitude";
        ImageMetaData.timeSpaceMetaDataLabelKeys[3] = "metadata.altitude";
        ImageMetaData.digitalMetaDataLabelKeys[0] = "metadata.maker";
        ImageMetaData.digitalMetaDataLabelKeys[1] = "metadata.model";
        ImageMetaData.digitalMetaDataLabelKeys[2] = "metadata.date.time";
        ImageMetaData.digitalMetaDataLabelKeys[3] = "metadata.iso";
        ImageMetaData.digitalMetaDataLabelKeys[4] = "metadata.shutter.speed";
        ImageMetaData.digitalMetaDataLabelKeys[5] = "metadata.exposure.time";
        ImageMetaData.digitalMetaDataLabelKeys[6] = "metadata.aperture";
        ImageMetaData.digitalMetaDataLabelKeys[7] = "metadata.focal.length";
        ImageMetaData.digitalMetaDataLabelKeys[8] = "metadata.flash";
        ImageMetaData.digitalMetaDataLabelKeys[9] = "metadata.white.balance";
        ImageMetaData.digitalMetaDataLabelKeys[10] = "metadata.latitude";
        ImageMetaData.digitalMetaDataLabelKeys[11] = "metadata.longitude";
        ImageMetaData.digitalMetaDataLabelKeys[12] = "metadata.altitude";
        ImageMetaData.filmMetaDataLabelKeys[0] = "metadata.maker";
        ImageMetaData.filmMetaDataLabelKeys[1] = "metadata.model";
        ImageMetaData.filmMetaDataLabelKeys[2] = "metadata.date.time";
        ImageMetaData.filmMetaDataLabelKeys[3] = "metadata.film";
        ImageMetaData.filmMetaDataLabelKeys[4] = "metadata.iso";
        ImageMetaData.filmMetaDataLabelKeys[5] = "metadata.exposure.time";
        ImageMetaData.filmMetaDataLabelKeys[6] = "metadata.aperture";
        ImageMetaData.filmMetaDataLabelKeys[7] = "metadata.focal.length";
        ImageMetaData.filmMetaDataLabelKeys[8] = "metadata.flash";
        ImageMetaData.filmMetaDataLabelKeys[9] = "metadata.latitude";
        ImageMetaData.filmMetaDataLabelKeys[10] = "metadata.longitude";
        ImageMetaData.filmMetaDataLabelKeys[11] = "metadata.altitude";
        ImageMetaData.processingMetaDataLabelKeys[0] = "metadata.software";
        ImageMetaData.processingMetaDataLabelKeys[1] = "metadata.date.time";
        ImageMetaData.processingMetaDataLabelKeys[2] = "metadata.latitude";
        ImageMetaData.processingMetaDataLabelKeys[3] = "metadata.longitude";
        ImageMetaData.processingMetaDataLabelKeys[4] = "metadata.altitude";
    }
}

