/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileHelper {
    static final int BUFFER = 1024;
    public static final FileFilter onlyDirectory = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    public static final FileFilter onlyFile = new FileFilter(){

        public boolean accept(File file) {
            return file.isFile();
        }
    };

    private FileHelper() {
    }

    public static File[] listDirectories(File parentDir) {
        return parentDir.listFiles(onlyDirectory);
    }

    public static File[] listFiles(File parentDir) {
        return parentDir.listFiles(onlyFile);
    }

    public static void deleteFiles(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
    }

    public static void deleteFiles(File directory, FileFilter filter) {
        File[] files = directory.listFiles(filter);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
    }

    public static boolean isEmpty(File directory) {
        if (directory.isDirectory()) {
            String[] list = directory.list();
            return list == null || list.length == 0;
        }
        return true;
    }

    public static boolean recursDelete(File directory) {
        boolean deleted = true;
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                deleted = files[i].isDirectory() ? FileHelper.recursDelete(files[i]) && deleted : files[i].delete() && deleted;
            }
        }
        deleted = directory.delete() && deleted;
        return deleted;
    }

    public static String fileNameExtention(String name) {
        String ext = "";
        int pos = name.lastIndexOf(46);
        if (pos >= 0) {
            ext = name.substring(pos + 1);
        }
        return ext;
    }

    public static String fileNameExtention(File f) {
        return FileHelper.fileNameExtention(f.getName());
    }

    public static String fileShortName(String name) {
        int pos = name.lastIndexOf(46);
        return pos >= 0 ? name.substring(0, pos) : name;
    }

    public static String fileShortName(File file) {
        return FileHelper.fileShortName(file.getName());
    }

    public static String getLastName(String path) {
        String name = path;
        int pos = path.lastIndexOf(File.separatorChar);
        if (pos >= 0 && path.length() >= 1) {
            name = path.substring(pos + 1);
        }
        return name;
    }

    public static boolean hasDirInPath(File path, File dirName) {
        return dirName != null ? path.getAbsolutePath().startsWith(dirName.getAbsolutePath()) : false;
    }

    public static String relativeURL(File baseDir, File file) {
        return FileHelper.pathToURL(FileHelper.relativePath(baseDir, file));
    }

    public static String relativePath(File baseDir, File file) {
        String res = null;
        if (baseDir.equals(file)) {
            res = ".";
        } else {
            int i;
            res = "";
            String[] basePath = FileHelper.decomposePath(baseDir);
            String[] fullPath = FileHelper.decomposePath(file);
            for (int index = 0; index < fullPath.length && index < basePath.length && basePath[index].equals(fullPath[index]); ++index) {
            }
            for (i = index; i < basePath.length; ++i) {
                if (!res.equals("")) {
                    res = res + File.separatorChar;
                }
                res = res + "..";
            }
            for (i = index; i < fullPath.length; ++i) {
                if (!res.equals("")) {
                    res = res + File.separatorChar;
                }
                res = res + fullPath[i];
            }
        }
        return res;
    }

    public static File fileInTargetDir(File baseDir, File file, File targetDir) {
        return new File(targetDir, FileHelper.relativePath(baseDir, file));
    }

    public static String pathToURL(String path) {
        return path.replace(File.separatorChar, '/');
    }

    public static String pathToURL(File file) {
        return FileHelper.pathToURL(file.getAbsolutePath());
    }

    public static String[] decomposePath(File path) {
        return FileHelper.decomposePath(path.getAbsolutePath());
    }

    public static String[] decomposePath(String pathName) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer token = new StringTokenizer(pathName, File.separator);
        while (token.hasMoreTokens()) {
            list.add(token.nextToken());
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public static File checkDirectory(File baseDir, String relativePath) {
        File dir = baseDir;
        if (dir != null) {
            if (relativePath != null) {
                dir = new File(dir, relativePath);
            }
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }
        return dir;
    }

    public static boolean doTargetNeedCreationOrUpdate(File file, File destFile) {
        return FileHelper.isOutOfSync(file, destFile);
    }

    public static boolean isOutOfSync(File source, File target) {
        return source.lastModified() > target.lastModified();
    }

    public static boolean copyFile(File file, File destFile, boolean ifNeeded) {
        boolean copied = false;
        try {
            if (!ifNeeded) {
                FileHelper.doCopyFile(file, destFile);
                copied = true;
            } else if (FileHelper.isOutOfSync(file, destFile)) {
                FileHelper.doCopyFile(file, destFile);
                copied = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return copied;
    }

    public static boolean copyFile(File file, File destFile) {
        return FileHelper.copyFile(file, destFile, true);
    }

    public static boolean copyFileToDir(File file, File destDir, boolean ifNeeded) {
        if (!destDir.isDirectory()) {
            throw new IllegalArgumentException(destDir + " must be an existing directory.");
        }
        return FileHelper.copyFile(file, new File(destDir, file.getName()), ifNeeded);
    }

    public static boolean copyFileToDir(File file, File destDir) {
        return FileHelper.copyFileToDir(file, destDir, true);
    }

    public static boolean copyFiles(File sourceDir, File targetDir, boolean ifNeeded) {
        return FileHelper.doCopyFiles(sourceDir.listFiles(), targetDir, ifNeeded);
    }

    public static boolean copyFiles(File sourceDir, File targetDir) {
        return FileHelper.copyFiles(sourceDir, targetDir, true);
    }

    public static boolean copyFiles(File sourceDir, File targetDir, FileFilter filter, boolean ifNeeded) {
        return FileHelper.doCopyFiles(sourceDir.listFiles(filter), targetDir, ifNeeded);
    }

    public static boolean copyFiles(File sourceDir, File targetDir, FileFilter filter) {
        return FileHelper.copyFiles(sourceDir, targetDir, filter, true);
    }

    public static boolean copyFilesOnly(File sourceDir, File targetDir, boolean ifNeeded) {
        return FileHelper.copyFiles(sourceDir, targetDir, onlyFile, ifNeeded);
    }

    public static boolean copyFilesOnly(File sourceDir, File targetDir) {
        return FileHelper.copyFilesOnly(sourceDir, targetDir, true);
    }

    public static boolean recurseCopyFiles(File sourceDir, File targetDir) {
        File[] files = sourceDir.listFiles();
        boolean ok = FileHelper.doCopyFiles(files, targetDir, false);
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (!f.isDirectory()) continue;
            File dir = new File(targetDir, f.getName());
            ok = FileHelper.recurseCopyFiles(f, dir) && ok;
            dir.setLastModified(f.lastModified());
        }
        return ok;
    }

    public static final void unzip(File archive) throws IOException {
        FileHelper.unzip(archive, new File(System.getProperty("user.dir")));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void unzip(File archive, File destination) throws IOException {
        HashSet<File> dirs = new HashSet<File>();
        FilterOutputStream dest = null;
        BufferedInputStream is = null;
        ZipFile zipfile = new ZipFile(archive);
        Enumeration<? extends ZipEntry> e = zipfile.entries();
        destination.mkdirs();
        while (true) {
            block10: {
                Object var14_14;
                if (!e.hasMoreElements()) {
                    return;
                }
                ZipEntry entry = e.nextElement();
                if (entry.isDirectory()) continue;
                File file = new File(destination, entry.getName());
                File parent = file.getParentFile();
                if (!dirs.contains(parent)) {
                    parent.mkdirs();
                    dirs.add(parent);
                }
                is = new BufferedInputStream(zipfile.getInputStream(entry));
                byte[] data = new byte[1024];
                try {
                    int count;
                    FileOutputStream fos = new FileOutputStream(file);
                    dest = new BufferedOutputStream(fos, 1024);
                    while ((count = is.read(data, 0, 1024)) != -1) {
                        ((BufferedOutputStream)dest).write(data, 0, count);
                    }
                    ((BufferedOutputStream)dest).flush();
                    dest.close();
                    dest = null;
                    is.close();
                    is = null;
                    var14_14 = null;
                    if (dest == null) break block10;
                }
                catch (Throwable throwable) {
                    var14_14 = null;
                    if (dest != null) {
                        dest.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                    throw throwable;
                }
                dest.close();
            }
            if (is == null) continue;
            is.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void doCopyFile(File file, File destFile) throws IOException {
        AbstractInterruptibleChannel outChannel;
        block6: {
            FileChannel inChannel = null;
            outChannel = null;
            try {
                inChannel = new FileInputStream(file).getChannel();
                outChannel = new FileOutputStream(destFile).getChannel();
                inChannel.transferTo(0L, inChannel.size(), (WritableByteChannel)((Object)outChannel));
                Object var6_4 = null;
                if (inChannel == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (inChannel != null) {
                    inChannel.close();
                }
                if (outChannel == null) throw throwable;
                outChannel.close();
                destFile.setLastModified(file.lastModified());
                throw throwable;
            }
            inChannel.close();
        }
        if (outChannel == null) return;
        outChannel.close();
        destFile.setLastModified(file.lastModified());
    }

    private static boolean doCopyFiles(File[] files, File targetDir, boolean ifNeeded) {
        int nbFiles = files == null ? 0 : files.length;
        boolean result = false;
        if (nbFiles > 0) {
            if (!targetDir.exists()) {
                targetDir.mkdirs();
            }
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    File dir = new File(targetDir, files[i].getName());
                    if (dir.exists()) continue;
                    dir.mkdir();
                    dir.setLastModified(files[i].lastModified());
                    result = true;
                    continue;
                }
                result = FileHelper.copyFileToDir(files[i], targetDir, ifNeeded) || result;
            }
        }
        return result;
    }
}

