/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.sgml;

import com.totalvalidator.sgml.EntityEncoder;
import com.totalvalidator.utils.GeneralUtils;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute
implements Serializable {
    private Map<String, List<String>> attributes = new HashMap<String, List<String>>();
    private boolean xmlnsAllowed;
    private boolean anyAllowed;
    private boolean dataAllowed;
    private boolean ariaAllowed;
    private static final String INTEGER = "integer";
    private static final String PINTEGER = "pinteger";
    private static final String NINTEGER = "ninteger";
    private static final String INTEGERS = "integers";
    private static final String FLOAT = "float";
    private static final String PFLOAT = "pfloat";
    private static final String NFLOAT = "nfloat";
    private static final String REQUIRED = "#required";
    private static final String FIXED = "#fixed";
    private static final String CDATA = "cdata";
    private static final String NUMBER = "number";
    private static final String PIXELS = "pixels";
    private static final String LENGTH = "length";
    private static final String MULTI_LENGTH = "multilength";
    private static final String MULTI_LENGTHS = "multilengths";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String ID5 = "id5";
    private static final String IDREF = "idref";
    private static final String ID5REF = "id5ref";
    private static final String HASHREF = "hashref";
    private static final String IDREFS = "idrefs";
    private static final String ID5REFS = "id5refs";
    private static final String NMTOKEN = "nmtoken";
    private static final String NMTOKENS = "nmtokens";
    private static final String COLOUR = "colour";
    private static final String CHARACTER = "character";
    private static final String CHARACTERS = "characters";
    private static final String FRAMETARGET = "frametarget";
    private static final String DROPTARGETS = "droptargets";
    private static final String URI = "uri";
    private static final String URI_CHARSET_ERROR = "It can only contain a limited set of US-ASCII characters (see rfc2396):";
    private static final String AURL = "aurl";
    private static final String AURL_ERROR = "It must be an absolute URL:";
    private static final String NBURI = "nburi";
    private static final String NBURI_ERROR = "It cannot be a blank value:";
    private static final String URI_LIST = "urilist";
    private static final String URI_LIST_ERROR = "It does not contain a space-separated list of valid URIs:";
    private static final String LANG = "langcode";
    private static final String LANG_ERROR = "Unrecognised, or malformed language code (see rfc3066):";
    private static final String FONTSIZE = "fontsize";
    private static final String COORDS = "coordinates";
    private static final String COORDS5 = "coordinates5";
    private static final String INPUTSIZE = "inputsize";
    private static final String SANDBOX = "sandbox";
    private static final String SANDBOX_ERROR = "It does not contain a space-separated list of 'allow-same-origin', 'allow-forms', and 'allow-scripts':";
    private static final String STEP = "step";
    private static final String STEP_ERROR = "It does not contain the keyword 'any' or a floating point number greater than zero:";
    private static final String SIZES = "sizes";
    private static final String SIZES_ERROR = "It does not contain the keyword 'any' or a space-separated list of sizes of the type NxN:";
    private static final String MEDIATYPE = "mediatype";
    private static final String MEDIATYPE_ERROR = "It does not contain a valid media type:";
    private static final String MEDIATYPES = "mediatypes";
    private static final String MEDIATYPES_ERROR = "It must be space-separated list of valid media types:";
    private static final String UNORDERED = "unordered";
    private static final String UNORDERED_ERROR = "It must be space-separated list of unique words:";
    private static final long serialVersionUID = 1L;
    private static final String ID_DEFINITION = ". It must begin with a letter [a-zA-Z] and may be followed by any number of letters, digits [0-9], hyphens, underscores, colons, and periods:";
    private static final String ID5_DEFINITION = ". It must contain at least one character and must not contain any space characters:";
    private static final String ID_DEFINITION_XML = ". It must begin with a letter, underscore or colon and may be followed by any number of letters, digits [0-9], hyphens, underscores, colons, and periods:";
    private static final String ID_ERROR = "It does not contain a valid ID. It must begin with a letter [a-zA-Z] and may be followed by any number of letters, digits [0-9], hyphens, underscores, colons, and periods:";
    private static final String ID5_ERROR = "It does not contain a valid ID. It must contain at least one character and must not contain any space characters:";
    private static final String ID_REF_ERROR = "It does not contain a valid ID reference. It must begin with a letter [a-zA-Z] and may be followed by any number of letters, digits [0-9], hyphens, underscores, colons, and periods:";
    private static final String ID5_REF_ERROR = "It does not contain a valid ID reference. It must contain at least one character and must not contain any space characters:";
    private static final String HASH_REF_ERROR = "It does not contain a valid hash reference";
    private static final String ID_REFS_ERROR = "It does not contain one or more valid ID references. It must begin with a letter [a-zA-Z] and may be followed by any number of letters, digits [0-9], hyphens, underscores, colons, and periods:";
    private static final String ID5_REFS_ERROR = "It does not contain one or more valid ID references. It must contain at least one character and must not contain any space characters:";
    private static final String ID_ERROR_XML = "It does not contain a valid ID. It must begin with a letter, underscore or colon and may be followed by any number of letters, digits [0-9], hyphens, underscores, colons, and periods:";
    private static final String ID_REF_ERROR_XML = "It does not contain a valid IDREF. It must begin with a letter, underscore or colon and may be followed by any number of letters, digits [0-9], hyphens, underscores, colons, and periods:";
    private static final String ID_REFS_ERROR_XML = "It does not contain one or more valid IDREFs. It must begin with a letter, underscore or colon and may be followed by any number of letters, digits [0-9], hyphens, underscores, colons, and periods:";
    private static final String NMTOKEN_DEFINITION = ". They can only contain letters [a-zA-Z], digits [0-9], hyphens, underscores, colons, and periods:";
    private static final String NMTOKEN_ERROR = "It does not contain a valid NMTOKEN. They can only contain letters [a-zA-Z], digits [0-9], hyphens, underscores, colons, and periods:";
    private static final String NMTOKENS_ERROR = "It does not contain one or more valid NMTOKENs. They can only contain letters [a-zA-Z], digits [0-9], hyphens, underscores, colons, and periods:";
    private static final String INTEGER_ERROR = "It must be an integer:";
    private static final String PINTEGER_ERROR = "It must be a positive integer (>0):";
    private static final String NINTEGER_ERROR = "It must be a non-negative integer (>=0):";
    private static final String INTEGERS_ERROR = "It must be a comma-separated list of integers:";
    private static final String FLOAT_ERROR = "It must be a floating point number:";
    private static final String PFLOAT_ERROR = "It must be a positive floating point number (>0):";
    private static final String NFLOAT_ERROR = "It must be a non-negative floating point number (>=0):";
    private static final String LENGTH_ERROR = "It must be an integer, or an integer percentage:";
    private static final String MULTI_LENGTH_ERROR = "It must be an integer, an integer percentage, or a relative length:";
    private static final String MULTI_LENGTHS_ERROR = "It must be a comma-separated list of integers, integer percentages, or relative lengths:";
    private static final String CHARACTER_ERROR = "It must be a single character or valid character reference:";
    private static final String CHARACTERS_ERROR = "It must be space-separated list of unique characters or valid character references:";
    private static final String FRAMETARGET_ERROR = "It must begin with a letter or be a reserved target ('_blank', '_top', etc):";
    private static final String DROPTARGETS_ERROR = "It must be a space-separated list of content types and unique actions ('copy', 'move', 'link', 's:.+', 'f:.+'):";
    private static final String FONTSIZE_ERROR = "It must be an absolute (1-7) or relative (+/-nn) font size:";
    private static final String COORDS_ERROR = "It must be a comma-separated list of integers, or integer percentages:";
    private static final String COORDS5_ERROR = "It must be a comma-separated list of integers:";
    private static final String COORDS_RECT_ERROR = "There must be exactly four coordinates:";
    private static final String RECT = "rect";
    private static final String DEFAULT = "default";
    private static final String COORDS_CIRCLE_ERROR = "There must be exactly three integers (the last >= 0):";
    private static final String CIRCLE = "circle";
    private static final String COORDS_POLY_ERROR = "There must be an even number of coordinates and at least six of them:";
    private static final String POLY = "poly";
    private static final Set<String> TARGETS = new HashSet<String>();
    private static final Set<String> COLOURS = new HashSet<String>();
    private static final String COLOUR_ERROR = "It must be a recognised color or color definition:";
    private static final char OPEN_BRACKET = '(';
    private static final char CLOSE_BRACKET = ')';
    private static final String QUOTE = "'";
    private static final String SPACE = " ";
    private static final String COMMA = ",";
    private static final String VALUES_MESSAGE = "It should have one of the following values: ";
    private static final String I = "i";
    private static final String A = "a";
    public static final String NAMESPACE_ATTRIBUTE = "xmlns:";
    private static final String ANY_ATTRIBUTE = "*";
    private static final String DATA_ATTRIBUTE = "data-";
    private static final String ARIA_ATTRIBUTE = "aria-";
    private static final String EMPTY_STRING = "empty_string";

    public Attribute(String text) {
        int index = text.indexOf(40);
        int index2 = -1;
        while (index != -1) {
            index2 = text.indexOf(41, index2 + 1);
            String value = text.substring(index, index2);
            value = this.stripSpaces(value);
            text = text.substring(0, index) + value + text.substring(index2);
            index = text.indexOf(40, index + 1);
        }
        StringTokenizer st = new StringTokenizer(text);
        while (st.hasMoreTokens()) {
            ArrayList<String> values = new ArrayList<String>();
            String attribute = st.nextToken();
            String value = st.nextToken();
            String restriction = st.nextToken();
            if (restriction.equals(FIXED)) {
                String val = st.nextToken();
                while (!val.endsWith(QUOTE)) {
                    val = val + SPACE + st.nextToken();
                }
                val = val.substring(1, val.length() - 1);
                values.add(val);
            } else {
                if (value.charAt(0) == '(') {
                    StringTokenizer st2 = new StringTokenizer(value, "(|)");
                    while (st2.hasMoreTokens()) {
                        value = st2.nextToken().trim();
                        values.add(value);
                    }
                } else {
                    values.add(value);
                }
                if (restriction.equals(REQUIRED)) {
                    values.add(REQUIRED);
                }
            }
            if (NAMESPACE_ATTRIBUTE.equals(attribute)) {
                this.xmlnsAllowed = true;
            }
            if (ANY_ATTRIBUTE.equals(attribute)) {
                this.anyAllowed = true;
            }
            if (DATA_ATTRIBUTE.equals(attribute)) {
                this.dataAllowed = true;
            }
            if (ARIA_ATTRIBUTE.equals(attribute)) {
                this.ariaAllowed = true;
            }
            this.attributes.put(attribute, values);
            GeneralUtils.LOGGER.info("Attribute: " + attribute + "=" + values);
        }
    }

    private String stripSpaces(String value) {
        StringBuilder sb = new StringBuilder();
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == ' ') continue;
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    public boolean isBoolean(String attrName) {
        if (attrName.equals(NAME)) {
            return false;
        }
        if (attrName.equals(ID)) {
            return false;
        }
        if (attrName.equals(ID5)) {
            return false;
        }
        if (attrName.startsWith("NO_NAME")) {
            return false;
        }
        if (this.isEmbedOrDataAttribute(attrName)) {
            return false;
        }
        List<String> values = this.attributes.get(attrName);
        return values.contains(attrName);
    }

    public Iterator<String> getRequiredIterator() {
        ArrayList<String> required = new ArrayList<String>();
        for (String attrName : this.attributes.keySet()) {
            List<String> values = this.attributes.get(attrName);
            if (!values.contains(REQUIRED)) continue;
            required.add(attrName);
        }
        return required.iterator();
    }

    public boolean exists(String attrName) {
        return this.attributes.containsKey(attrName) || this.anyAllowed || this.xmlnsAllowed && attrName.startsWith(NAMESPACE_ATTRIBUTE) || this.dataAllowed && attrName.startsWith(DATA_ATTRIBUTE) || this.ariaAllowed && attrName.startsWith(ARIA_ATTRIBUTE);
    }

    public boolean isEmbedOrDataAttribute(String attrName) {
        return !this.attributes.containsKey(attrName) && (this.anyAllowed || this.xmlnsAllowed && attrName.startsWith(NAMESPACE_ATTRIBUTE) || this.dataAllowed && attrName.startsWith(DATA_ATTRIBUTE) || this.ariaAllowed && attrName.startsWith(ARIA_ATTRIBUTE));
    }

    public String checkValue(String attrName, String attrValue, boolean isXml, boolean isHtml5, EntityEncoder encoder, String context) {
        if (attrName.startsWith("NO_NAME")) {
            return null;
        }
        List<String> realValues = this.attributes.get(attrName);
        if (realValues == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        values.addAll(realValues);
        values.remove(REQUIRED);
        StringBuilder valueList = new StringBuilder();
        if (values.size() > 1) {
            for (String value : values) {
                if (EMPTY_STRING.equals(value)) {
                    value = "";
                    if (attrValue.length() == 0) {
                        return null;
                    }
                } else {
                    valueList.append(value).append(SPACE);
                }
                if (!(!isXml || A.equals(value) || I.equals(value) ? value.equalsIgnoreCase(attrValue) : isXml && value.equals(attrValue))) continue;
                return null;
            }
        } else {
            if (isHtml5 && attrValue.length() == 0 && this.isBoolean(attrName)) {
                return null;
            }
            if (this.isEmbedOrDataAttribute(attrName)) {
                return null;
            }
            String value = (String)values.get(0);
            valueList.append(value).append(SPACE);
            if (value.equals(CDATA)) {
                return null;
            }
            if (value.equals(INTEGER)) {
                return this.validInteger(attrValue) ? null : INTEGER_ERROR;
            }
            if (value.equals(PINTEGER)) {
                return this.validPInteger(attrValue);
            }
            if (value.equals(NUMBER) || value.equals(PIXELS) || value.equals(INPUTSIZE) || value.equals(NINTEGER)) {
                return this.validNumber(attrValue) ? null : NINTEGER_ERROR;
            }
            if (value.equals(INTEGERS)) {
                return this.validIntegers(attrValue);
            }
            if (value.equals(FLOAT)) {
                return Attribute.validFloat(attrValue);
            }
            if (value.equals(PFLOAT)) {
                return this.validPFloat(attrValue) ? null : PFLOAT_ERROR;
            }
            if (value.equals(NFLOAT)) {
                return Attribute.validNFloat(attrValue);
            }
            if (value.equals(MEDIATYPE)) {
                return this.validMediaType(attrValue) ? null : MEDIATYPE_ERROR;
            }
            if (value.equals(MEDIATYPES)) {
                boolean allOK = attrValue.length() > 0;
                StringTokenizer st = new StringTokenizer(attrValue);
                while (st.hasMoreTokens()) {
                    if (this.validMediaType(st.nextToken())) continue;
                    allOK = false;
                    break;
                }
                return allOK ? null : MEDIATYPES_ERROR;
            }
            if (value.equals(SANDBOX)) {
                boolean allOK;
                boolean bl = allOK = attrValue.length() > 0;
                if (!isXml) {
                    attrValue = attrValue.toLowerCase();
                }
                StringTokenizer st = new StringTokenizer(attrValue);
                while (st.hasMoreTokens()) {
                    String val = st.nextToken();
                    if ("allow-same-origin".equals(val) || "allow-forms".equals(val) || "allow-top-navigation".equals(val) || "allow-scripts".equals(val)) continue;
                    allOK = false;
                    break;
                }
                return allOK ? null : SANDBOX_ERROR;
            }
            if (value.equals(SIZES)) {
                if ("any".equals(attrValue.trim())) {
                    return null;
                }
                boolean allOK = attrValue.length() > 0;
                StringTokenizer st = new StringTokenizer(attrValue.trim());
                while (st.hasMoreTokens()) {
                    String val = st.nextToken();
                    StringTokenizer st2 = new StringTokenizer(val, "x");
                    if (st2.countTokens() != 2) {
                        allOK = false;
                        break;
                    }
                    String width = st2.nextToken();
                    String height = st2.nextToken();
                    if (width.charAt(0) != '0' && this.validNumber(width) && height.charAt(0) != '0' && this.validNumber(height)) continue;
                    allOK = false;
                    break;
                }
                return allOK ? null : SIZES_ERROR;
            }
            if (value.equals(STEP)) {
                return "any".equals(attrValue.trim()) || this.validPFloat(attrValue) ? null : STEP_ERROR;
            }
            if (value.equals(LENGTH)) {
                return this.validLength(attrValue) ? null : LENGTH_ERROR;
            }
            if (value.equals(FONTSIZE)) {
                return this.validFontSize(attrValue) ? null : FONTSIZE_ERROR;
            }
            if (value.equals(MULTI_LENGTH)) {
                return this.validMultiLength(attrValue) ? null : MULTI_LENGTH_ERROR;
            }
            if (value.equals(MULTI_LENGTHS)) {
                if (attrValue.length() == 0 || attrValue.charAt(0) == ',' || attrValue.charAt(attrValue.length() - 1) == ',') {
                    return MULTI_LENGTHS_ERROR;
                }
                StringTokenizer st = new StringTokenizer(attrValue, COMMA);
                while (st.hasMoreTokens()) {
                    if (this.validMultiLength(st.nextToken().trim())) continue;
                    return MULTI_LENGTHS_ERROR;
                }
                return null;
            }
            if (value.equals(COORDS)) {
                return this.validCoords(attrValue, context);
            }
            if (value.equals(COORDS5)) {
                return this.validCoords5(attrValue, context);
            }
            if (value.equals(NAME)) {
                return Attribute.validID(attrValue, isXml) == -1 ? null : (isXml ? ID_ERROR_XML : ID_ERROR);
            }
            if (value.equals(ID)) {
                return Attribute.validID(attrValue, isXml) == -1 ? null : (isXml ? ID_ERROR_XML : ID_ERROR);
            }
            if (value.equals(ID5)) {
                return Attribute.validID5(attrValue) ? null : ID5_ERROR;
            }
            if (value.equals(NMTOKEN)) {
                return this.validToken(attrValue) ? null : NMTOKEN_ERROR;
            }
            if (value.equals(NMTOKENS)) {
                boolean allOK = attrValue.length() > 0;
                StringTokenizer st = new StringTokenizer(attrValue);
                while (st.hasMoreTokens()) {
                    if (this.validToken(st.nextToken().trim())) continue;
                    allOK = false;
                    break;
                }
                return allOK ? null : NMTOKENS_ERROR;
            }
            if (value.equals(IDREF)) {
                return Attribute.validID(attrValue, isXml) == -1 ? null : (isXml ? ID_REF_ERROR_XML : ID_REF_ERROR);
            }
            if (value.equals(ID5REF)) {
                return Attribute.validID5(attrValue) ? null : ID5_REF_ERROR;
            }
            if (value.equals(HASHREF)) {
                return Attribute.validHashRef(attrValue) ? null : HASH_REF_ERROR;
            }
            if (value.equals(IDREFS)) {
                boolean allOK = attrValue.length() > 0;
                StringTokenizer st = new StringTokenizer(attrValue);
                while (st.hasMoreTokens()) {
                    if (Attribute.validID(st.nextToken(), isXml) == -1) continue;
                    allOK = false;
                    break;
                }
                return allOK ? null : (isXml ? ID_REFS_ERROR_XML : ID_REFS_ERROR);
            }
            if (value.equals(ID5REFS)) {
                boolean allOK = attrValue.length() > 0;
                StringTokenizer st = new StringTokenizer(attrValue);
                while (st.hasMoreTokens()) {
                    if (Attribute.validID5(st.nextToken())) continue;
                    allOK = false;
                    break;
                }
                return allOK ? null : ID5_REFS_ERROR;
            }
            if (value.equals(COLOUR)) {
                return this.validColour(attrValue, isXml) ? null : COLOUR_ERROR;
            }
            if (value.equals(URI)) {
                return Attribute.validURICharset(attrValue) ? null : URI_CHARSET_ERROR;
            }
            if (value.equals(NBURI)) {
                if (!Attribute.validURICharset(attrValue)) {
                    return URI_CHARSET_ERROR;
                }
                return attrValue.length() != 0 ? null : NBURI_ERROR;
            }
            if (value.equals(AURL)) {
                return Attribute.validAbsUrl(attrValue);
            }
            if (value.equals(URI_LIST)) {
                boolean allOK = attrValue.length() > 0;
                StringTokenizer st = new StringTokenizer(attrValue);
                while (st.hasMoreTokens()) {
                    if (Attribute.validURICharset(st.nextToken())) continue;
                    allOK = false;
                    break;
                }
                return allOK ? null : URI_LIST_ERROR;
            }
            if (value.equals(LANG)) {
                return this.validLangCode(attrValue, isHtml5 || isXml) ? null : LANG_ERROR;
            }
            if (value.equals(FRAMETARGET)) {
                return this.validFrametarget(attrValue, isXml) ? null : FRAMETARGET_ERROR;
            }
            if (value.equals(DROPTARGETS)) {
                return this.validDropTargets(attrValue, isXml) ? null : DROPTARGETS_ERROR;
            }
            if (value.equals(CHARACTER)) {
                return this.validCharacter(attrValue, encoder, false) ? null : CHARACTER_ERROR;
            }
            if (value.equals(CHARACTERS)) {
                boolean allOK = attrValue.length() > 0;
                StringTokenizer st = new StringTokenizer(attrValue);
                ArrayList<Character> chars = new ArrayList<Character>();
                while (st.hasMoreTokens()) {
                    if (this.validUniqueCharacter(st.nextToken(), encoder, chars)) continue;
                    allOK = false;
                    break;
                }
                return allOK ? null : CHARACTERS_ERROR;
            }
            if (value.equals(UNORDERED)) {
                boolean allOK = true;
                StringTokenizer st = new StringTokenizer(attrValue);
                ArrayList<String> tokens = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (tokens.contains(token)) {
                        allOK = false;
                        break;
                    }
                    tokens.add(token);
                }
                return allOK ? null : UNORDERED_ERROR;
            }
            if (!isXml || A.equals(value) || I.equals(value) ? value.equalsIgnoreCase(attrValue) : isXml && value.equals(attrValue)) {
                return null;
            }
        }
        return VALUES_MESSAGE + valueList.toString();
    }

    private boolean validInteger(String attrValue) {
        char[] chars;
        for (char c : chars = attrValue.toCharArray()) {
            if (!Character.isWhitespace(c)) continue;
            return false;
        }
        try {
            Integer.parseInt(attrValue);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private String validPInteger(String attrValue) {
        char[] chars;
        for (char c : chars = attrValue.toCharArray()) {
            if (!Character.isWhitespace(c)) continue;
            return PINTEGER_ERROR;
        }
        try {
            long val = Long.parseLong(attrValue);
            if (val < 0L) {
                return PINTEGER_ERROR;
            }
        }
        catch (NumberFormatException e) {
            return PINTEGER_ERROR;
        }
        return null;
    }

    private String validIntegers(String attrValue) {
        char[] chars;
        for (char c : chars = attrValue.toCharArray()) {
            if (!Character.isWhitespace(c)) continue;
            return "It must be a comma-separated list of integers:";
        }
        StringTokenizer st = new StringTokenizer(attrValue, COMMA);
        while (st.hasMoreTokens()) {
            try {
                Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException e) {
                return "It must be a comma-separated list of integers:";
            }
        }
        return null;
    }

    private boolean validMediaType(String attrValue) {
        char[] chars;
        if ((attrValue = attrValue.trim()).length() == 0) {
            return false;
        }
        int index = attrValue.indexOf(47);
        if (index == -1 || index == 0 || index == attrValue.length() - 1 || index != attrValue.lastIndexOf(47)) {
            return false;
        }
        for (char c : chars = attrValue.toCharArray()) {
            if (c == ';') break;
            if (!Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    private String validCoords(String attrValue, String shape) {
        if (attrValue.length() == 0 || attrValue.charAt(0) == ',' || attrValue.charAt(attrValue.length() - 1) == ',') {
            return COORDS_ERROR;
        }
        StringTokenizer st = new StringTokenizer(attrValue, COMMA);
        int count = 0;
        while (st.hasMoreTokens()) {
            if (!this.validLength(st.nextToken().trim())) {
                return COORDS_ERROR;
            }
            ++count;
        }
        if ((shape == null || RECT.equalsIgnoreCase(shape) || DEFAULT.equalsIgnoreCase(shape)) && count != 4) {
            return COORDS_RECT_ERROR;
        }
        if (CIRCLE.equalsIgnoreCase(shape) && count != 3) {
            return COORDS_CIRCLE_ERROR;
        }
        if (POLY.equalsIgnoreCase(shape) && (count < 6 || count % 2 != 0)) {
            return COORDS_POLY_ERROR;
        }
        return null;
    }

    private String validCoords5(String attrValue, String shape) {
        if (attrValue.length() == 0 || attrValue.charAt(0) == ',' || attrValue.charAt(attrValue.length() - 1) == ',') {
            return COORDS_ERROR;
        }
        StringTokenizer st = new StringTokenizer(attrValue, COMMA);
        int count = 0;
        String radius = null;
        while (st.hasMoreTokens()) {
            String coord = st.nextToken().trim();
            if (!this.validInteger(coord)) {
                return "It must be a comma-separated list of integers:";
            }
            if (++count != 3) continue;
            radius = coord;
        }
        if ((shape == null || RECT.equalsIgnoreCase(shape) || DEFAULT.equalsIgnoreCase(shape)) && count != 4) {
            return COORDS_RECT_ERROR;
        }
        if (CIRCLE.equalsIgnoreCase(shape) && (count != 3 || !this.validNumber(radius))) {
            return COORDS_CIRCLE_ERROR;
        }
        if (POLY.equalsIgnoreCase(shape) && (count < 6 || count % 2 != 0)) {
            return COORDS_POLY_ERROR;
        }
        return null;
    }

    private boolean validLength(String attrValue) {
        return this.validNumber(attrValue) || this.validPercentage(attrValue);
    }

    private boolean validFontSize(String attrValue) {
        if (attrValue.length() == 0) {
            return false;
        }
        String value = attrValue;
        if (value.charAt(0) == '+') {
            value = value.substring(1, value.length());
        }
        int val = 0;
        try {
            val = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (attrValue.charAt(0) == '+' || attrValue.charAt(0) == '-') {
            return val < 100 && val > -100;
        }
        return val < 8 && val > 0;
    }

    private boolean validMultiLength(String attrValue) {
        return this.validNumber(attrValue) || this.validPercentage(attrValue) || this.validRelativeLength(attrValue);
    }

    private boolean validRelativeLength(String attrValue) {
        int len = attrValue.length();
        switch (len) {
            case 0: {
                return false;
            }
            case 1: {
                return attrValue.charAt(0) == '*';
            }
        }
        return this.validNumber(attrValue.substring(0, len - 1)) && attrValue.charAt(len - 1) == '*';
    }

    private boolean validPercentage(String attrValue) {
        int len = attrValue.length();
        if (len == 0) {
            return false;
        }
        if (attrValue.charAt(len - 1) != '%') {
            return false;
        }
        attrValue = attrValue.substring(0, len - 1);
        return this.validNumber(attrValue);
    }

    private boolean validNumber(String attrValue) {
        try {
            long val = Long.parseLong(attrValue);
            if (val < 0L) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static String validFloat(String attrValue) {
        try {
            Double.parseDouble(attrValue);
        }
        catch (NumberFormatException e) {
            return FLOAT_ERROR;
        }
        return null;
    }

    private boolean validPFloat(String attrValue) {
        try {
            Double val = Double.parseDouble(attrValue);
            if (val <= 0.0) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static String validNFloat(String attrValue) {
        try {
            Double val = Double.parseDouble(attrValue);
            if (val < 0.0) {
                return NFLOAT_ERROR;
            }
        }
        catch (NumberFormatException e) {
            return NFLOAT_ERROR;
        }
        return null;
    }

    private boolean validCharacter(String attrValue, EntityEncoder encoder, boolean unicode) {
        if (attrValue.length() == 0) {
            return false;
        }
        String[] result = encoder.decode(attrValue, false, false);
        attrValue = result[0];
        if (unicode && Character.codePointCount(attrValue.toCharArray(), 0, attrValue.length()) > 1) {
            return false;
        }
        return attrValue.length() == 1;
    }

    private boolean validUniqueCharacter(String attrValue, EntityEncoder encoder, List<Character> chars) {
        if (attrValue.length() == 0) {
            return false;
        }
        String[] result = encoder.decode(attrValue, false, false);
        if (Character.codePointCount((attrValue = result[0]).toCharArray(), 0, attrValue.length()) > 1) {
            return false;
        }
        char ch = attrValue.charAt(0);
        if (chars.contains(new Character(ch))) {
            return false;
        }
        chars.add(Character.valueOf(ch));
        return true;
    }

    private boolean validColour(String attrValue, boolean xml) {
        if (attrValue.length() == 0) {
            return false;
        }
        if (!xml) {
            attrValue = attrValue.toLowerCase(Locale.ENGLISH);
        }
        if (attrValue.charAt(0) == '#' && attrValue.length() == 7) {
            attrValue = attrValue.substring(1);
            try {
                Integer.parseInt(attrValue, 16);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
        return COLOURS.contains(attrValue);
    }

    private boolean validLangCode(String attrValue, boolean isHtml5) {
        int i;
        char[] chars;
        if (attrValue.length() == 0) {
            return isHtml5;
        }
        StringTokenizer st = new StringTokenizer(attrValue, "-");
        String languageCode = st.nextToken().toLowerCase(Locale.ENGLISH);
        if (languageCode != I && languageCode != "x") {
            if (languageCode.length() == 1 || languageCode.length() > 3) {
                return false;
            }
            if (languageCode.length() == 2) {
                boolean foundMatch = false;
                for (String lang : Locale.getISOLanguages()) {
                    if (!lang.equalsIgnoreCase(languageCode)) continue;
                    foundMatch = true;
                    break;
                }
                if (!foundMatch) {
                    return false;
                }
            } else {
                char[] chars2 = languageCode.toCharArray();
                for (int i2 = 0; i2 < chars2.length; ++i2) {
                    if (chars2[i2] >= 'a' && chars2[i2] <= 'z') continue;
                    return false;
                }
            }
        }
        if (st.hasMoreTokens()) {
            String countryCode = st.nextToken().toUpperCase();
            if (countryCode.length() == 1 || countryCode.length() > 8 || countryCode.length() == 2 && (countryCode == "AA" || countryCode == "ZZ" || countryCode.startsWith("Q") || countryCode.startsWith("X"))) {
                return false;
            }
            if (countryCode.length() == 2) {
                boolean foundMatch = false;
                for (String country : Locale.getISOCountries()) {
                    if (!country.equalsIgnoreCase(countryCode)) continue;
                    foundMatch = true;
                    break;
                }
                if (!foundMatch) {
                    return false;
                }
            } else {
                chars = countryCode.toCharArray();
                for (i = 0; i < chars.length; ++i) {
                    if (chars[i] >= 'A' && chars[i] <= 'Z' || chars[i] >= '0' && chars[i] <= '9') continue;
                    return false;
                }
            }
        }
        while (st.hasMoreTokens()) {
            String subtag = st.nextToken().toUpperCase();
            if (subtag.length() > 8) {
                return false;
            }
            chars = subtag.toCharArray();
            for (i = 0; i < chars.length; ++i) {
                if (chars[i] >= 'A' && chars[i] <= 'Z' || chars[i] >= '0' && chars[i] <= '9') continue;
                return false;
            }
        }
        return true;
    }

    private static boolean validURICharset(String attrValue) {
        char[] chars;
        if (attrValue.length() == 0) {
            return true;
        }
        for (char ch : chars = attrValue.toCharArray()) {
            if (ch >= ' ' && ch <= '~') continue;
            return false;
        }
        return true;
    }

    public static String validAbsUrl(String attrValue) {
        URI url;
        if (!Attribute.validURICharset(attrValue)) {
            return URI_CHARSET_ERROR;
        }
        try {
            url = new URI(attrValue);
        }
        catch (URISyntaxException e) {
            return AURL_ERROR;
        }
        return url.getScheme() != null ? null : AURL_ERROR;
    }

    private boolean validFrametarget(String attrValue, boolean xml) {
        if (attrValue.length() == 0) {
            return false;
        }
        if (!xml) {
            attrValue = attrValue.toLowerCase(Locale.ENGLISH);
        }
        if (!TARGETS.contains(attrValue)) {
            return GeneralUtils.isLatinLetter(attrValue.charAt(0));
        }
        return true;
    }

    private boolean validDropTargets(String attrValue, boolean xml) {
        if (!xml) {
            attrValue = attrValue.toLowerCase(Locale.ENGLISH);
        }
        boolean allOK = attrValue.length() > 0;
        int actionCount = 0;
        StringTokenizer st = new StringTokenizer(attrValue);
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            if ("copy".equals(item) || "move".equals(item) || "link".equals(item)) {
                if (++actionCount <= 1) continue;
                allOK = false;
                break;
            }
            if (item.length() >= 3 && (item.startsWith("s:") || item.startsWith("f:"))) continue;
            allOK = false;
            break;
        }
        return allOK;
    }

    private boolean validToken(String attrValue) {
        if (attrValue.length() == 0) {
            return false;
        }
        char[] chars = attrValue.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (GeneralUtils.isLatinLetter(chars[i]) || GeneralUtils.isLatinDigit(chars[i]) || chars[i] == '-' || chars[i] == '_' || chars[i] == ':' || chars[i] == '.') continue;
            return false;
        }
        return true;
    }

    public static int validID(String attrValue, boolean isXml) {
        if (attrValue.length() == 0) {
            return 1;
        }
        char[] chars = attrValue.toCharArray();
        int charVal = chars[0] - (Character.isUpperCase(chars[0]) ? 65 : 97);
        if (!(charVal >= 0 && charVal <= 25 || isXml && (chars[0] == '_' || chars[0] == ':'))) {
            return 1;
        }
        for (int i = 1; i < chars.length; ++i) {
            if (GeneralUtils.isLatinLetter(chars[i]) || GeneralUtils.isLatinDigit(chars[i]) || chars[i] == '-' || chars[i] == '_' || chars[i] == ':' || chars[i] == '.') continue;
            return i + 1;
        }
        return -1;
    }

    private static boolean validID5(String attrValue) {
        char[] chars;
        if (attrValue.length() == 0) {
            return false;
        }
        for (char c : chars = attrValue.toCharArray()) {
            if (!Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean validHashRef(String attrValue) {
        if ((attrValue = attrValue.trim()).length() < 2) {
            return false;
        }
        if (attrValue.charAt(0) != '#') {
            return false;
        }
        return Attribute.validID5(attrValue.substring(1));
    }

    static {
        COLOURS.add("black");
        COLOURS.add("silver");
        COLOURS.add("gray");
        COLOURS.add("white");
        COLOURS.add("maroon");
        COLOURS.add("red");
        COLOURS.add("purple");
        COLOURS.add("fuchsia");
        COLOURS.add("green");
        COLOURS.add("lime");
        COLOURS.add("olive");
        COLOURS.add("yellow");
        COLOURS.add("navy");
        COLOURS.add("blue");
        COLOURS.add("teal");
        COLOURS.add("aqua");
        TARGETS.add("_blank");
        TARGETS.add("_top");
        TARGETS.add("_self");
        TARGETS.add("_parent");
    }
}

