/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator;

import com.totalvalidator.Cancellor;
import com.totalvalidator.TotalValidator;
import com.totalvalidator.app.AuthenticationDialog;
import com.totalvalidator.app.InfoPanel;
import com.totalvalidator.app.WaitFrame;
import com.totalvalidator.exceptions.CancelledException;
import com.totalvalidator.exceptions.ValidationException;
import com.totalvalidator.online.Log;
import com.totalvalidator.online.MailHelper;
import com.totalvalidator.options.Option;
import com.totalvalidator.options.OptionFactory;
import com.totalvalidator.parser.CommandLineParser;
import com.totalvalidator.parser.DTDParser;
import com.totalvalidator.parser.TagParser;
import com.totalvalidator.reports.MainReportPage;
import com.totalvalidator.reports.TagReport;
import com.totalvalidator.sgml.CData;
import com.totalvalidator.sgml.CSSPiece;
import com.totalvalidator.sgml.Data;
import com.totalvalidator.sgml.Element;
import com.totalvalidator.sgml.EntityEncoder;
import com.totalvalidator.sgml.Piece;
import com.totalvalidator.sgml.SupportedDTDs;
import com.totalvalidator.sgml.Tag;
import com.totalvalidator.snapshot.SnapshotThread;
import com.totalvalidator.spelling.SpellingDictionary;
import com.totalvalidator.utils.FileUtils;
import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.utils.GetFile;
import com.totalvalidator.utils.MyCookieHandler;
import com.totalvalidator.utils.MyProxySelector;
import com.totalvalidator.utils.MyReader;
import com.totalvalidator.utils.PageReference;
import com.totalvalidator.utils.Zipper;
import com.totalvalidator.validations.AccessibilityValidation;
import com.totalvalidator.validations.BasicValidation;
import com.totalvalidator.validations.CSSValidation;
import com.totalvalidator.validations.HTMLValidation;
import com.totalvalidator.validations.LinkValidation;
import com.totalvalidator.validations.SpellingValidation;
import com.totalvalidator.validations.Validation;
import com.totalvalidator.validations.problem.ValidationProblem;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.CookieHandler;
import java.net.MalformedURLException;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator
extends Thread
implements Cancellor,
ActionListener {
    static final String RESULTS_FILE = "TotalValidator";
    private static final String IMAGE_FOLDER = "images/";
    private static final String[] IMAGES = new String[]{"mainstyle.css", "up.gif", "down.gif", "left.gif", "null.gif", "tvheader2.gif", "ln_validated.gif", "sn_validated.gif"};
    private static final String OUTPUT_DIR = "Results";
    private static final String EMAIL = "\n\nSave the attached file and unzip it somewhere convenient. Then double-click TotalValidator*.html to view the results.\n\nRegards,\n  TV Support\n\nTotal Validator: The all-in-one validator\nHTML / XHTML / WCAG / Section 508 / Links / Spelling\n";
    public static final String PROBLEM_MESSAGE = "<h2>Problem with service</h2><p><span class=\"error\">You may need to check your parameters and try again.</span></p>";
    public static final String BIG_PROBLEM = "<h2>Problem with service</h2><p><span class=\"error\">You may need to check your parameters and try again.</span></p><p><span class=\"error\">If this was not a user error and you have specified an email address you will be contacted when the following error has been corrected: </span></p><pre>";
    private static final SimpleDateFormat REPORT_SDF = new SimpleDateFormat("yyyyMMddHHmmss", Locale.UK);
    private static final String NO_STARTING_WEB_PAGE = "No Starting Web Page";
    private static final String SLASH = "/";
    private static final String TOTALVALIDATOR_COM = "www.totalvalidator.com";
    private static final String VALIDATING = "Validating ";
    private static final String BINARY_FILE = "Binary file detected for ";
    private static final String MAX_PIECE_LIMIT_MESSAGE = "Max piece limit breached (";
    private static final String MAX_PIECE_LIMIT_MESSAGE2 = ") for ";
    private static final String BROKEN_LINK_MESSAGE = "Broken link checking (";
    private static final String BROKEN_LINK_MESSAGE2 = ") disabled for ";
    private static final String HTML = "html";
    private static final String BODY = "body";
    private static final String HEAD = "head";
    private static final String DOCTYPE = "!doctype";
    private static final String ISINDEX = "isindex";
    private static final String TITLE = "title";
    private static final String META = "meta";
    private static final String LINK = "link";
    private static final String BASE = "base";
    private static final String STYLE = "style";
    private static final String NEXTID = "nextid";
    private static final String COMMAND = "command";
    private static final String SCRIPT = "script";
    private static final String ITEMREF = "itemref";
    private static final String NOSCRIPT = "noscript";
    private static final String OBJECT = "object";
    private static final String NOFRAMES = "noframes";
    private static final String FRAMESET = "frameset";
    private static final String HTML_END = "/html";
    private static final String HEAD_END = "/head";
    private static final String BODY_END = "/body";
    private static final String SPACED_SLASH = " / ";
    private static final String USER_AGENT = "user-agent";
    private static final String STAR = "*";
    private static final String TOTAL_VALIDATOR = "TotalValidator";
    private static final String DISALLOW = "disallow:";
    private static final String ALLOW = "allow:";
    public static final String UPLOADED_PAGE = "Uploaded Page";
    private String outputDir = "Results";
    private Map<String, List<ValidationProblem>> linksTested = new HashMap<String, List<ValidationProblem>>();
    private LinkedList<PageReference> pagesToCheck = new LinkedList();
    private String results;
    private int totalErrors = 0;
    private int totalWarnings = 0;
    private String resultsFile = "TotalValidator";
    private String tmpDirectory = "";
    private CommandLineParser cl;
    private static boolean servlet = true;
    private static EntityEncoder defaultEncoder;
    private static WaitFrame pleaseWait;
    private SpellingDictionary dictionary;
    private FileUtils fileUtils;
    private boolean cancelled = false;
    private boolean killed = false;
    private Option option;
    public int pagesLeft = 0;
    private ActionListener listener;
    private long startTime = 0L;
    private String startDate = "";
    private TagReport firstTagReport;
    private String subPage;
    private boolean online = false;
    private String sessionId;

    public static void main(String[] args) {
        boolean extension = GeneralUtils.basicSettings(args);
        if (GeneralUtils.LOGGER.isLoggable(Level.FINE)) {
            for (int i = 0; i < args.length; ++i) {
                GeneralUtils.LOGGER.fine("arg[" + i + "]=" + args[i]);
            }
        }
        CommandLineParser clp = new CommandLineParser(new FileUtils());
        Validator v = null;
        try {
            String results;
            clp.setTool(true);
            if (!extension) {
                clp.setCommandLine(true);
            }
            clp.processArgs(args);
            if (clp.useSystemProxy()) {
                System.setProperty("java.net.useSystemProxies", "true");
            }
            ((MyProxySelector)ProxySelector.getDefault()).setProxyDetails(clp.getProxyDetails());
            AuthenticationDialog.resetCount();
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e2) {
                // empty catch block
            }
            v = new Validator();
            v.setOption(OptionFactory.newOption());
            v.setServlet(false);
            v.setCommandLineParser(clp);
            v.setFileUtils(new FileUtils());
            if (extension) {
                try {
                    InfoPanel waitPanel = new InfoPanel(null, TotalValidator.TOTAL_FOREGROUND, TotalValidator.TOTAL_LIGHT_BLUE, null, TotalValidator.VALIDATE_MESSAGES, "Cancel", 67, v);
                    pleaseWait = new WaitFrame(null, waitPanel, "Validating");
                    pleaseWait.setVisible(true);
                    v.addActionListener(v);
                }
                catch (HeadlessException e) {
                    GeneralUtils.LOGGER.severe(System.getProperty("java.awt.headless"));
                    GeneralUtils.LOGGER.log(Level.SEVERE, "Please Wait Frame", e);
                }
            }
            String resultsFile = v.validate();
            if (!clp.isHideResults()) {
                GeneralUtils.launchBrowser(new File(resultsFile).toURI().toURL().toString());
            } else if (clp.isResultsToStdout() && clp.getMaxPages() == 1 && (results = v.getResults()) != null) {
                System.out.println(results);
            }
        }
        catch (Throwable t) {
            GeneralUtils.LOGGER.log(Level.SEVERE, "Validation Failed", t);
            if (clp != null && clp.isInteract()) {
                Validator.cancelFrame();
                JOptionPane.showMessageDialog(new Frame(), t.getMessage() == null ? "Error - No Message" : t.getMessage(), "Validation Error", 0);
            }
            System.exit(1);
        }
        Validator.cancelFrame();
        int exitStatus = 0;
        if (v != null && clp.isExtendedStatus()) {
            exitStatus += v.getTotalErrors() > 0 ? 4 : 0;
            exitStatus += v.getTotalWarnings() > 0 ? 2 : 0;
        }
        System.exit(exitStatus);
    }

    private static synchronized void cancelFrame() {
        if (pleaseWait != null) {
            pleaseWait.dispose();
            pleaseWait = null;
        }
    }

    @Override
    public void run() {
        this.startTime = System.currentTimeMillis();
        this.startDate = GeneralUtils.format(new Date());
        String message = "";
        try {
            this.validate();
        }
        catch (ValidationException e) {
            message = e.getMessage();
            if (message == null || message.trim().equals("")) {
                message = "Problem with service, but no identifying message.";
            }
        }
        catch (Throwable t) {
            message = t.getMessage();
            if (message == null || message.trim().equals("")) {
                message = "Problem with service, but no identifying message.";
            }
            GeneralUtils.LOGGER.log(Level.SEVERE, "Validation Failure", t);
        }
        if (message != null && !message.trim().equals("")) {
            this.results = BIG_PROBLEM + message + "</pre>";
            if (message.indexOf(" 401 ") == -1 && !message.equals(NO_STARTING_WEB_PAGE)) {
                Validator.reportMessage(message);
            }
            if (this.cl.getToAddress() != null && this.cl.getToAddress().trim().length() > 0 && !MailHelper.sendEmail((boolean)true, (String)this.cl.getToAddress(), (String)MailHelper.defaultFromAddress, (String)message, (String)"Total Validator Error Report", null)) {
                Validator.reportMessage("Email not sent to " + this.cl.getToAddress());
            }
        }
        GeneralUtils.removeValidator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String validate() throws Exception {
        List<String> failedList;
        String[] snapshots;
        int pageCount;
        MainReportPage mainReportPage;
        String imagesDir;
        String theUrl;
        block87: {
            boolean checkLinks;
            String docType;
            this.online = servlet && !this.cl.isAddress();
            DTDParser parser = this.getDTD(this.cl.getDtdName());
            this.cl.setParser(parser);
            String string = docType = parser == null ? null : parser.getOrigDocType();
            if (!servlet && this.cl.getTheUrl() != null) {
                CookieHandler.setDefault(new MyCookieHandler(this.cl.getCookiePolicy(), this.cl.getCachePolicy(), this.cl.getSendPolicy(), this.cl.getCookies(), this.cl.getTheUrl()));
            }
            MyReader myReader = new MyReader();
            theUrl = this.cl.getTheUrl();
            URL url = null;
            boolean httpStream = false;
            if (theUrl != null) {
                try {
                    url = new URL(theUrl);
                }
                catch (MalformedURLException e2) {
                    throw new ValidationException("Invalid URL supplied");
                }
                GeneralUtils.getAuthenticator().addServerAuthentication(this.cl.getUserName(), this.cl.getPassword(), theUrl, null);
                GeneralUtils.getAuthenticator().addProxyAuthentication(this.cl.getProxyDetails());
                GeneralUtils.logProxies(url);
                URL[] urls = new URL[2];
                urls[0] = url;
                myReader = FileUtils.getReader(urls, true, this.cl, null, true, null);
                url = urls[0];
                httpStream = urls[1] != null;
            } else if (this.cl.getSourceName() == null) {
                if (this.cl.isInteract()) {
                    GetFile gf = new GetFile();
                    gf.browse("Select a Web Page", new String[]{".htm", ".html"});
                    myReader.setInputStream(gf.getInputStream());
                    myReader.setContentType(FileUtils.getContentType(gf.getFile()));
                    if (gf.getInputStream() != null) {
                        File sourceFile = gf.getFile();
                        url = sourceFile.toURI().toURL();
                    }
                }
            } else {
                File sourceFile = new File(this.cl.getSourceName());
                myReader.setInputStream(this.fileUtils.getInputStream(this.cl.getSourceName()));
                myReader.setContentType(FileUtils.getContentType(new File(this.cl.getSourceName())));
                url = sourceFile.toURI().toURL();
            }
            if (myReader.getInputStream() == null) {
                throw new ValidationException(NO_STARTING_WEB_PAGE);
            }
            theUrl = url.toString();
            int index = theUrl.lastIndexOf(SLASH);
            if (index - theUrl.indexOf(":/") == 1 || index - theUrl.indexOf("://") == 2 || index - theUrl.indexOf(":///") == 3) {
                theUrl = theUrl + SLASH;
                index = theUrl.lastIndexOf(SLASH);
            }
            String urlOrigin = theUrl.substring(0, index);
            GeneralUtils.LOGGER.info(theUrl + " : " + urlOrigin);
            String thePageName = null;
            imagesDir = null;
            mainReportPage = null;
            try {
                this.outputDir = OUTPUT_DIR;
                if (servlet) {
                    this.outputDir = this.resultsFile.substring(this.tmpDirectory.length(), this.resultsFile.length() - 5) + this.outputDir;
                } else {
                    this.tmpDirectory = this.cl.getResultsFolder();
                    if (this.cl.isUniqueResultsFile()) {
                        Validator validator = this;
                        synchronized (validator) {
                            this.outputDir = "TV" + REPORT_SDF.format(new Date());
                        }
                        this.resultsFile = this.outputDir;
                    }
                    this.resultsFile = this.tmpDirectory + this.resultsFile + ".html";
                }
                thePageName = this.cl.getUploadedFile();
                if (thePageName == null) {
                    thePageName = this.cl.getOrigUrl();
                    if (thePageName == null) {
                        thePageName = theUrl;
                    }
                } else {
                    thePageName = UPLOADED_PAGE;
                }
                mainReportPage = new MainReportPage(thePageName, this.outputDir, this.resultsFile, servlet);
                this.outputDir = this.tmpDirectory + this.outputDir;
                imagesDir = this.outputDir + "/../images";
                this.createOutputDirectory(this.outputDir, true);
                this.createOutputDirectory(this.outputDir + "/images", false);
                this.createOutputDirectory(imagesDir, false);
                if (this.cl.isSpellCheck()) {
                    if (this.cl.getLanguage() != null) {
                        this.dictionary = new SpellingDictionary();
                        this.dictionary.addMoreWords(new InputStreamReader(this.fileUtils.getInputStream(FileUtils.getInstallationFolder() + this.cl.getLanguage()), "UTF-8"));
                        if (this.cl.getAltDic() != null) {
                            this.dictionary.addMoreWords(FileUtils.getLocalReader(this.cl.getAltDic()));
                        }
                    } else if (this.cl.getAltDic() != null) {
                        this.dictionary = new SpellingDictionary();
                        this.dictionary.addMoreWords(FileUtils.getLocalReader(this.cl.getAltDic()));
                    }
                }
                this.isCancelled();
            }
            catch (Exception e3) {
                try {
                    if (httpStream) {
                        InputStream is = myReader.getInputStream();
                        while (is.read() != -1) {
                        }
                    }
                }
                catch (IOException e1) {
                }
                finally {
                    try {
                        myReader.getInputStream().close();
                    }
                    catch (IOException e2) {}
                }
                throw e3;
            }
            pageCount = 0;
            Thread snapshotThread = null;
            snapshots = null;
            if (this.cl.isBrowser()) {
                snapshotThread = new SnapshotThread(theUrl, this.outputDir, true, this.cl, !servlet);
                snapshotThread.start();
            }
            Validator e2 = this;
            synchronized (e2) {
                if (defaultEncoder == null) {
                    defaultEncoder = new EntityEncoder();
                    defaultEncoder.addBasics(this.fileUtils);
                }
            }
            this.linksTested.put(theUrl, new ArrayList());
            boolean bl = checkLinks = this.cl.getMaxPages() != 1 || this.cl.isBrokenLinks();
            if (checkLinks && !urlOrigin.toLowerCase(Locale.ENGLISH).startsWith("file") && this.cl.isUseRobots() && this.cl.getMaxPages() != 1) {
                this.readRobots(theUrl);
            }
            boolean bestFit = parser == null ? false : parser.isBestFit();
            this.processSource(theUrl, myReader, httpStream, parser, docType, thePageName, bestFit, urlOrigin, checkLinks, mainReportPage);
            pageCount = this.option.recurse(this.cl, this.pagesToCheck, this, docType, parser, this, bestFit, urlOrigin, checkLinks, mainReportPage);
            Object var18_35 = null;
            if (snapshotThread == null) break block87;
            try {
                snapshotThread.join(1200000L);
            }
            catch (InterruptedException e3) {
                GeneralUtils.LOGGER.log(Level.SEVERE, "Interrupted waiting for Snapshots to return", e3);
            }
            if (snapshotThread.isAlive()) {
                snapshotThread.interrupt();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e3) {
                    // empty catch block
                }
                if (snapshotThread.isAlive()) {
                    ((SnapshotThread)snapshotThread).closeConnections();
                }
            }
            snapshots = ((SnapshotThread)snapshotThread).getSnapshots();
            if (this.firstTagReport != null && snapshots != null && snapshots.length > 0) {
                this.results = this.firstTagReport.addSnapshots(snapshots);
            }
            break block87;
            {
                catch (CancelledException e5) {
                    var18_35 = null;
                    if (snapshotThread == null) break block87;
                    try {
                        snapshotThread.join(1200000L);
                    }
                    catch (InterruptedException e3) {
                        GeneralUtils.LOGGER.log(Level.SEVERE, "Interrupted waiting for Snapshots to return", e3);
                    }
                    if (snapshotThread.isAlive()) {
                        snapshotThread.interrupt();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e3) {
                            // empty catch block
                        }
                        if (snapshotThread.isAlive()) {
                            ((SnapshotThread)snapshotThread).closeConnections();
                        }
                    }
                    snapshots = ((SnapshotThread)snapshotThread).getSnapshots();
                    if (this.firstTagReport != null && snapshots != null && snapshots.length > 0) {
                        this.results = this.firstTagReport.addSnapshots(snapshots);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var18_36 = null;
                if (snapshotThread != null) {
                    try {
                        snapshotThread.join(1200000L);
                    }
                    catch (InterruptedException e3) {
                        GeneralUtils.LOGGER.log(Level.SEVERE, "Interrupted waiting for Snapshots to return", e3);
                    }
                    if (snapshotThread.isAlive()) {
                        snapshotThread.interrupt();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e3) {
                            // empty catch block
                        }
                        if (snapshotThread.isAlive()) {
                            ((SnapshotThread)snapshotThread).closeConnections();
                        }
                    }
                    snapshots = ((SnapshotThread)snapshotThread).getSnapshots();
                    if (this.firstTagReport != null && snapshots != null && snapshots.length > 0) {
                        this.results = this.firstTagReport.addSnapshots(snapshots);
                    }
                }
                throw throwable;
            }
        }
        CookieHandler handler = CookieHandler.getDefault();
        if (handler instanceof MyCookieHandler) {
            MyCookieHandler ch = (MyCookieHandler)handler;
            ch.finish();
            ch = null;
        }
        if (!(failedList = mainReportPage.close(this.linksTested.size() - 1, pageCount, this.totalErrors, this.totalWarnings, this.cl.getOptions(), snapshots, this.cancelled, this.cl.isExtension())).isEmpty()) {
            StringBuilder messages = new StringBuilder("Snapshot failed for:\n");
            for (String message : failedList) {
                messages.append(message);
            }
            if (servlet) {
                Validator.reportMessage(messages.toString());
            }
        }
        if (this.dictionary != null) {
            this.dictionary.close();
            this.dictionary = null;
        }
        for (String image : IMAGES) {
            image = FileUtils.getInstallationFolder() + IMAGE_FOLDER + image;
            this.fileUtils.copyFile(image, imagesDir);
        }
        String zipFile = "";
        if (servlet && this.cl.getToAddress() != null && this.cl.getToAddress().trim().length() > 0) {
            HashMap<String, BufferedInputStream> extras = new HashMap<String, BufferedInputStream>();
            zipFile = new Zipper().zipUp(this.resultsFile, this.cl.getSuffix(), extras, this.outputDir, imagesDir);
            if (!MailHelper.sendEmail((boolean)true, (String)this.cl.getToAddress(), (String)MailHelper.defaultFromAddress, (String)("Validation results for:\n" + theUrl + EMAIL), (String)"Total Validator Results", (String)zipFile)) {
                Validator.reportMessage("Email not sent to " + this.cl.getToAddress());
            } else {
                if (this.cl.getAltDic() != null) {
                    FileUtils.deleteFile(new File(this.cl.getAltDic()), false);
                }
                FileUtils.deleteFile(new File(this.resultsFile), false);
                FileUtils.deleteFile(new File(this.outputDir), true);
                if (theUrl.contains(TOTALVALIDATOR_COM)) {
                    FileUtils.deleteFile(new File(zipFile), false);
                }
            }
        }
        if (!this.cl.isAddress() && this.results == null) {
            this.results = mainReportPage.getReport();
        }
        if (this.cl.isShowResultsPath() && !this.cl.isResultsToStdout()) {
            System.out.println(new File(this.resultsFile).getAbsolutePath());
        }
        if (servlet) {
            if (theUrl.contains(TOTALVALIDATOR_COM)) {
                FileUtils.deleteFile(new File(this.outputDir), true);
                FileUtils.deleteFile(new File(this.resultsFile), false);
            } else {
                Log.entry((String)("\n Results File: " + this.resultsFile + "\n Completed in: " + mainReportPage.getDuration()));
            }
        } else if (!servlet && this.cl.getMaxPages() == 1 && this.subPage != null) {
            this.resultsFile = new File(new File(this.outputDir), this.subPage).getAbsolutePath();
        }
        this.linksTested.clear();
        this.cl = null;
        return this.resultsFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readRobots(String theUrl) {
        URL[] urls = new URL[2];
        BufferedReader br = null;
        URI uri = new URL(theUrl).toURI();
        String siteRoot = uri.getScheme() + "://" + uri.getAuthority();
        urls[0] = new URL(siteRoot + "/robots.txt");
        br = new BufferedReader(FileUtils.getReader(urls, true, this.cl, theUrl, false, null).getReader());
        String line = null;
        block8: while ((line = br.readLine()) != null) {
            if (!line.toLowerCase(Locale.ENGLISH).startsWith(USER_AGENT) || line.indexOf("TotalValidator") == -1 && line.indexOf(STAR) == -1) continue;
            while ((line = br.readLine()) != null) {
                String path;
                StringTokenizer st;
                if (line.toLowerCase(Locale.ENGLISH).startsWith(DISALLOW)) {
                    st = new StringTokenizer(line = line.substring(DISALLOW.length()), " ");
                    if (!st.hasMoreTokens() || !(path = st.nextToken()).startsWith(SLASH)) continue;
                    this.cl.addFolderToSkip(siteRoot, path);
                    continue;
                }
                if (line.toLowerCase(Locale.ENGLISH).startsWith(ALLOW)) {
                    st = new StringTokenizer(line = line.substring(ALLOW.length()), " ");
                    if (!st.hasMoreTokens() || !(path = st.nextToken()).startsWith(SLASH)) continue;
                    this.cl.addFolderToInclude(siteRoot, path);
                    continue;
                }
                if (line.trim().length() != 0) continue;
                continue block8;
            }
        }
        Object var10_10 = null;
        if (br == null) return;
        try {
            br.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (Exception e) {
                GeneralUtils.LOGGER.log(Level.SEVERE, "Could not read robots.txt file", e);
                Object var10_11 = null;
                if (br == null) return;
                try {
                    br.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (br == null) throw throwable;
            try {
                br.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void isCancelled() throws CancelledException {
        if (this.cancelled) {
            throw new CancelledException();
        }
    }

    private DTDParser getDTD(String dtdName) throws ValidationException {
        DTDParser parser = null;
        InputStream dtd = null;
        if (dtdName == null) {
            if (servlet || !this.cl.isDtdPrompt()) {
                return null;
            }
            GetFile gf = new GetFile();
            gf.browse("Select a DTD, if required", new String[]{".dtd.object"});
            dtd = gf.getInputStream();
            if (dtd != null) {
                dtdName = gf.getFile().getName();
            }
        } else {
            dtd = this.fileUtils.getInputStream(FileUtils.getInstallationFolder() + dtdName + ".object");
        }
        if (dtd != null) {
            parser = DTDParser.getParser(dtd, dtdName);
        }
        return parser;
    }

    private void createOutputDirectory(String outputDirectory, boolean deleteFirst) {
        File outputDir = new File(outputDirectory);
        if (deleteFirst) {
            try {
                FileUtils.deleteFile(outputDir, true);
            }
            catch (IOException e) {
                GeneralUtils.LOGGER.log(Level.FINE, "Failed to delete folder: " + outputDir.getAbsoluteFile(), e);
            }
        }
        outputDir.mkdirs();
    }

    public void processSource(String theUrl, MyReader myReader, boolean httpStream, DTDParser parser, String inputDocType, String thePageName, boolean bestFit, String urlOrigin, boolean checkLinks, MainReportPage mainReportPage) throws ValidationException, CancelledException {
        String docType = inputDocType;
        if (!(servlet || this.cl.isShowResultsPath() || this.cl.isResultsToStdout())) {
            System.out.println(VALIDATING + theUrl);
        }
        EntityEncoder ee = defaultEncoder;
        TagParser tagParser = new TagParser();
        List<Piece> pieces = tagParser.parseFile(myReader, httpStream, parser, parser != null && inputDocType == null && !bestFit, this.fileUtils, this.cl, ee);
        if (this.cl.onlySnapshots()) {
            if (!this.cl.isShowSuccess()) {
                pieces.clear();
            }
        } else if (pieces == null) {
            pieces = new ArrayList<Piece>();
            Data dataPiece = new Data("", 0, defaultEncoder, this.cl.getIgnoreMessages(), this.cl.isShowWarnings());
            dataPiece.setVirtual(true);
            dataPiece.setProblem(ValidationProblem.BINARY_FILE);
            pieces.add(dataPiece);
            if (servlet) {
                String message = BINARY_FILE + theUrl;
                GeneralUtils.LOGGER.info(message);
                Validator.reportMessage(message);
            }
        } else if (pieces.size() > 15000 && servlet) {
            String message = MAX_PIECE_LIMIT_MESSAGE + pieces.size() + MAX_PIECE_LIMIT_MESSAGE2 + theUrl;
            GeneralUtils.LOGGER.info(message);
            pieces.clear();
            Data dataPiece = new Data("", 0, defaultEncoder, this.cl.getIgnoreMessages(), this.cl.isShowWarnings());
            dataPiece.setVirtual(true);
            dataPiece.setProblem(ValidationProblem.MAX_TAGS);
            pieces.add(dataPiece);
        } else if (pieces.size() > 0) {
            boolean mayCheckLinks = true;
            if (checkLinks && pieces.size() > 8000 && servlet) {
                pieces.get(0).setProblem(ValidationProblem.BROKEN_LINKS);
                String message = BROKEN_LINK_MESSAGE + pieces.size() + BROKEN_LINK_MESSAGE2 + theUrl;
                GeneralUtils.LOGGER.info(message);
                mayCheckLinks = false;
            }
            boolean bestfit = false;
            if (parser != null) {
                parser = tagParser.getParser();
                docType = tagParser.getParserDocType();
                if (parser == null) {
                    bestfit = true;
                }
            }
            if (bestfit) {
                if (tagParser.isFrameset()) {
                    parser = this.getBestParser(SupportedDTDs.framesetDTDs, pieces, myReader);
                    docType = parser.getOrigDocType();
                } else {
                    parser = this.getBestParser(SupportedDTDs.nonFramesetDTDs, pieces, myReader);
                    docType = parser.getOrigDocType();
                }
            }
            this.preprocess(parser, docType, pieces, bestfit, myReader);
            Validation validation = new BasicValidation();
            validation.validate(pieces, this);
            if (parser != null) {
                ee = parser.getEncoder();
            }
            if (checkLinks && mayCheckLinks) {
                validation = new LinkValidation(this.cl, theUrl, urlOrigin, this.pagesToCheck, this.linksTested, ee, this);
                validation.validate(pieces, this);
                this.cl.setFollowLinks(false);
            }
            if (this.cl.isAccessibility()) {
                validation = new AccessibilityValidation(this.cl.getAccessibilityLevel(), parser, docType, this.cl.isUS508(), this.cl.isWCAG2(), theUrl, ee);
                validation.validate(pieces, this);
            }
            if (this.cl.isCss()) {
                validation = new CSSValidation(this.cl.getCssLevel(), parser);
                validation.validate(pieces, this);
            }
            if (this.cl.isSpellCheck()) {
                validation = new SpellingValidation(this.dictionary, ee, this.cl.getSpellOptions(), this.cl.getLanguage(), this.cl.isCheckLang(), servlet || this.cl.isSaveBadWords());
                validation.validate(pieces, this);
            }
        } else {
            Data dataPiece = new Data("", 0, defaultEncoder, this.cl.getIgnoreMessages(), this.cl.isShowWarnings());
            dataPiece.setVirtual(true);
            dataPiece.setProblem(ValidationProblem.NO_TAGS);
            pieces.add(dataPiece);
        }
        TagReport tr = new TagReport();
        String detectedDocType = inputDocType == null && parser != null ? docType : null;
        boolean isXml = parser == null ? false : parser.isXml();
        this.results = tr.format(pieces, thePageName, mainReportPage, this.cl, this.linksTested.size() - 1, servlet && !this.cl.isAddress() ? this.cl.getOptions() : null, servlet ? this.cl.getRevalidateOptions() : null, ee, detectedDocType, servlet, this.online, isXml);
        if (this.results != null) {
            this.subPage = tr.saveResults(this.outputDir);
            mainReportPage.reportPage(this.subPage);
            this.totalErrors += tr.getErrorTotal();
            this.totalWarnings += tr.getWarningsTotal();
            if (this.firstTagReport == null) {
                this.firstTagReport = tr;
            }
        } else if (this.cl.isShowSuccess()) {
            mainReportPage.reportPage(null);
        }
    }

    private DTDParser getBestParser(List<String> listOfDTDs, List<Piece> pieces, MyReader myReader) throws ValidationException, CancelledException {
        int minErrors = Integer.MAX_VALUE;
        DTDParser bestParser = null;
        boolean oneMore = false;
        for (String dtdName : listOfDTDs) {
            List<Piece> newPieces = this.makeCopy(pieces);
            DTDParser parser = this.getDTD(dtdName);
            this.preprocess(parser, parser.getOrigDocType(), newPieces, false, myReader);
            int errorCount = 0;
            for (Piece piece : newPieces) {
                errorCount += piece.getErrorCount();
            }
            if (errorCount < minErrors) {
                bestParser = parser;
                minErrors = errorCount;
                oneMore = false;
                continue;
            }
            if (errorCount <= minErrors) continue;
            if (oneMore) break;
            oneMore = true;
        }
        return bestParser;
    }

    private List<Piece> makeCopy(List<Piece> pieces) {
        ArrayList<Piece> newPieces = new ArrayList<Piece>();
        for (Piece piece : pieces) {
            Piece newPiece = null;
            if (piece instanceof Tag) {
                int current;
                int index;
                Tag newTag = new Tag(piece);
                if (piece.hasMatchingTag() && (index = pieces.indexOf(piece.getMatchingTag())) < (current = newPieces.size())) {
                    Piece matchingTag = (Piece)newPieces.get(index);
                    newTag.setMatchingTag(matchingTag);
                    matchingTag.setMatchingTag(newTag);
                }
                newPiece = newTag;
            } else if (piece instanceof CData) {
                newPiece = new CData(piece);
            } else if (piece instanceof Data) {
                newPiece = new Data(piece);
            } else if (piece instanceof CSSPiece) {
                newPiece = new CSSPiece(piece);
            } else {
                System.out.println("Invalid type of Piece: " + piece);
            }
            newPieces.add(newPiece);
        }
        return newPieces;
    }

    private void preprocess(DTDParser parser, String docType, List<Piece> pieces, boolean bestfit, MyReader myReader) throws ValidationException, CancelledException {
        boolean isHtml5 = SupportedDTDs.isHTML5(docType);
        if (parser != null && !parser.isXml()) {
            this.addImpliedTags(pieces, isHtml5);
            this.addImpliedEndTags(pieces, parser.getElements());
        }
        Piece[] tagArray = new Piece[pieces.size()];
        pieces.toArray(tagArray);
        this.workOutNesting(0, tagArray, null);
        tagArray = null;
        if (parser != null) {
            HTMLValidation validation = new HTMLValidation(parser, docType, bestfit, myReader, this.cl.getHttpCharset(), this.cl.getBomCharset(), this.cl.getOtherCharset());
            validation.validate(pieces, this);
            if (!parser.isXml()) {
                this.removeXHTMLproblems(pieces);
            } else {
                this.removeHTMLproblems(pieces, isHtml5);
            }
        }
    }

    private void removeXHTMLproblems(List<Piece> pieces) {
        for (Piece tag : pieces) {
            ValidationProblem[] messages = tag.getMessages();
            for (int i = 0; i < messages.length; ++i) {
                if (messages[i] != ValidationProblem.INCOMPLETE_ENTITY && messages[i] != ValidationProblem.BAD_HEX_REPRESENTATION) continue;
                tag.unsetProblem(messages[i]);
            }
        }
    }

    private void removeHTMLproblems(List<Piece> pieces, boolean isHtml5) {
        for (Piece tag : pieces) {
            ValidationProblem[] messages = tag.getMessages();
            for (int i = 0; i < messages.length; ++i) {
                if (!isHtml5 || messages[i] != ValidationProblem.MISSING_DOCTYPE) continue;
                tag.unsetProblem(messages[i]);
            }
        }
    }

    private void addImpliedTags(List<Piece> pieces, boolean isHtml5) {
        Piece endTag;
        boolean head = false;
        boolean endHead = false;
        boolean body = false;
        boolean endBody = false;
        boolean frameset = false;
        boolean noFrames = false;
        boolean endNoFrames = false;
        boolean html = false;
        boolean endHtml = false;
        boolean firstBodyType = false;
        int endHtmlIndex = -1;
        int current = 0;
        int docIndex = -1;
        int htmlIndex = -1;
        int headIndex = -1;
        int bodyIndex = -1;
        int noFramesIndex = -1;
        int endNoFramesIndex = -1;
        int endHeadIndex = -1;
        int endBodyIndex = -1;
        int aBodyTag = -1;
        Piece htmlTag = new Tag(HTML, 0, defaultEncoder, this.cl.getIgnoreMessages(), this.cl.isShowWarnings());
        htmlTag.setVirtual(true);
        Piece bodyTag = new Tag(BODY, 0, defaultEncoder, this.cl.getIgnoreMessages(), this.cl.isShowWarnings());
        bodyTag.setVirtual(true);
        Piece headTag = new Tag(HEAD, 0, defaultEncoder, this.cl.getIgnoreMessages(), this.cl.isShowWarnings());
        headTag.setVirtual(true);
        for (Piece tag : pieces) {
            String element = tag.getStrippedElement();
            if (element != null && !tag.isMalformed() && !(tag instanceof Data)) {
                if (DOCTYPE.equals(element) && docIndex == -1) {
                    docIndex = current;
                } else if (HTML.equals(element)) {
                    if (tag.isEndTag()) {
                        if (endHtmlIndex == -1) {
                            endHtml = true;
                            endHtmlIndex = current;
                        }
                    } else if (htmlIndex == -1) {
                        html = true;
                        htmlIndex = current;
                        htmlTag = tag;
                    }
                } else if (HEAD.equals(element)) {
                    if (tag.isEndTag()) {
                        if (endHeadIndex == -1) {
                            endHeadIndex = current;
                            endHead = true;
                        }
                    } else if (headIndex == -1) {
                        head = true;
                        headIndex = current;
                        headTag = tag;
                    }
                } else if (BODY.equals(element)) {
                    if (tag.isEndTag()) {
                        if (endBodyIndex == -1) {
                            endBody = true;
                            endBodyIndex = current;
                        }
                    } else if (bodyIndex == -1) {
                        body = true;
                        bodyIndex = current;
                        bodyTag = tag;
                    }
                } else if (FRAMESET.equals(element)) {
                    if (!tag.isEndTag()) {
                        frameset = true;
                    }
                } else if (NOFRAMES.equals(element)) {
                    if (tag.isEndTag()) {
                        if (endNoFramesIndex == -1) {
                            endNoFramesIndex = current;
                            endNoFrames = true;
                        }
                    } else if (noFramesIndex == -1) {
                        noFramesIndex = current;
                        noFrames = true;
                    }
                } else if (!(firstBodyType || tag.isEndTag() || TITLE.equals(element) || META.equals(element) || LINK.equals(element) || BASE.equals(element) || ISINDEX.equals(element) || STYLE.equals(element) || NEXTID.equals(element) || SCRIPT.equals(element) || COMMAND.equals(element) || ITEMREF.equals(element) || NOSCRIPT.equals(element) && isHtml5 || OBJECT.equals(element) && !isHtml5)) {
                    firstBodyType = true;
                    aBodyTag = current;
                }
            }
            ++current;
        }
        if (!html) {
            htmlIndex = docIndex + 1;
            pieces.add(htmlIndex, htmlTag);
            ++endHeadIndex;
            ++aBodyTag;
            ++endBodyIndex;
            ++endHtmlIndex;
            ++headIndex;
            ++bodyIndex;
            ++noFramesIndex;
            ++endNoFramesIndex;
        }
        if (!endHtml) {
            endTag = new Tag(HTML_END, 0, defaultEncoder, this.cl.getIgnoreMessages(), this.cl.isShowWarnings());
            endTag.setVirtual(true);
            ((Tag)endTag).setMatchingTag(htmlTag);
            ((Piece)htmlTag).setMatchingTag(endTag);
            pieces.add(endTag);
            endHtmlIndex = pieces.size() - 1;
        } else if (!((Piece)htmlTag).hasMatchingTag()) {
            endTag = pieces.get(endHtmlIndex);
            endTag.setMatchingTag(htmlTag);
            ((Piece)htmlTag).setMatchingTag(endTag);
        }
        if (!head) {
            headIndex = htmlIndex + 1;
            pieces.add(headIndex, headTag);
            ++endHeadIndex;
            ++aBodyTag;
            ++endBodyIndex;
            ++endHtmlIndex;
            ++bodyIndex;
            ++noFramesIndex;
            ++endNoFramesIndex;
        }
        if (!endHead) {
            endTag = new Tag(HEAD_END, 0, defaultEncoder, this.cl.getIgnoreMessages(), this.cl.isShowWarnings());
            endTag.setVirtual(true);
            ((Tag)endTag).setMatchingTag(headTag);
            ((Piece)headTag).setMatchingTag(endTag);
            if (!body && !frameset) {
                bodyIndex = headIndex + 1;
                if (firstBodyType) {
                    bodyIndex = aBodyTag;
                }
            }
            endHeadIndex = bodyIndex != -1 ? bodyIndex : (firstBodyType ? aBodyTag - 1 : headIndex + 1);
            pieces.add(endHeadIndex, endTag);
            ++endBodyIndex;
            ++endHtmlIndex;
            ++noFramesIndex;
            ++endNoFramesIndex;
        } else if (!((Piece)headTag).hasMatchingTag()) {
            endTag = pieces.get(endHeadIndex);
            endTag.setMatchingTag(headTag);
            ((Piece)headTag).setMatchingTag(endTag);
        }
        if (!frameset) {
            if (!body) {
                bodyIndex = endHeadIndex + 1;
                pieces.add(bodyIndex, bodyTag);
                ++endBodyIndex;
                ++endHtmlIndex;
            }
            if (!endBody) {
                endTag = new Tag(BODY_END, 0, defaultEncoder, this.cl.getIgnoreMessages(), this.cl.isShowWarnings());
                endTag.setVirtual(true);
                ((Tag)endTag).setMatchingTag(bodyTag);
                bodyTag.setMatchingTag(endTag);
                pieces.add(endHtmlIndex, endTag);
            } else if (!bodyTag.hasMatchingTag()) {
                endTag = pieces.get(endBodyIndex);
                endTag.setMatchingTag(bodyTag);
                bodyTag.setMatchingTag(endTag);
            }
        } else if (noFrames && endNoFrames) {
            if (!body) {
                bodyIndex = noFramesIndex + 1;
                pieces.add(bodyIndex, bodyTag);
                ++endBodyIndex;
                ++endNoFramesIndex;
            }
            if (!endBody) {
                endTag = new Tag(BODY_END, 0, defaultEncoder, this.cl.getIgnoreMessages(), this.cl.isShowWarnings());
                endTag.setVirtual(true);
                ((Tag)endTag).setMatchingTag(bodyTag);
                bodyTag.setMatchingTag(endTag);
                pieces.add(endNoFramesIndex, endTag);
            } else if (!bodyTag.hasMatchingTag()) {
                endTag = pieces.get(endBodyIndex);
                endTag.setMatchingTag(bodyTag);
                bodyTag.setMatchingTag(endTag);
            }
        }
    }

    private void addImpliedEndTags(List<Piece> pieces, Map<String, Element> elements) {
        for (int i = 0; i < pieces.size(); ++i) {
            Piece piece = pieces.get(i);
            if (!(piece instanceof Tag)) continue;
            this.addVirtualEndTag(piece, i, pieces, elements);
        }
    }

    private boolean addVirtualEndTag(Piece tag, int i, List<Piece> pieces, Map<String, Element> elements) {
        String element;
        Element e;
        if (!(tag == null || tag.getStrippedElement() == null || tag.getStrippedElement().equals(DOCTYPE) || tag.isEndTag() || tag.isSingleton() || tag.hasMatchingTag() || (e = elements.get(element = tag.getStrippedElement())) == null || e.mustHaveEndTag() || e.mustntHaveEndTag())) {
            Piece matchingTag = null;
            for (int j = i + 1; j < pieces.size(); ++j) {
                Piece nextTag = pieces.get(j);
                if (!(nextTag instanceof Tag)) continue;
                if (matchingTag != null) {
                    if (matchingTag != nextTag) continue;
                    matchingTag = null;
                    continue;
                }
                if (nextTag.isEndTag() || !Piece.allowedWithin(e, nextTag.getStrippedElement())) {
                    Tag newTag = new Tag(SLASH + tag.getStrippedElement(), 0, defaultEncoder, this.cl.getIgnoreMessages(), this.cl.isShowWarnings());
                    newTag.setVirtual(true);
                    newTag.setMatchingTag(tag);
                    tag.setMatchingTag(newTag);
                    pieces.add(j, newTag);
                    return true;
                }
                if (!nextTag.isEndTag() && nextTag.hasMatchingTag()) {
                    matchingTag = nextTag.getMatchingTag();
                    continue;
                }
                if (!this.addVirtualEndTag(nextTag, j, pieces, elements)) continue;
                --j;
            }
        }
        return false;
    }

    private int workOutNesting(int index, Piece[] tagArray, Piece current) {
        while (index < tagArray.length) {
            if (tagArray[index].hasMatchingTag()) {
                if (tagArray[index].isEndTag()) {
                    return index;
                }
                tagArray[index].setParent(current);
                index = this.workOutNesting(index + 1, tagArray, tagArray[index]);
                if (index < tagArray.length) {
                    tagArray[index].setParent(current);
                }
            } else {
                tagArray[index].setParent(current);
            }
            ++index;
        }
        return index;
    }

    public String getResults() {
        return this.results;
    }

    public void setTmpDirectory(String tmpDirectory) {
        this.tmpDirectory = tmpDirectory;
    }

    public void setCommandLineParser(CommandLineParser cl) {
        this.cl = cl;
    }

    public void setServlet(boolean servlet) {
        Validator.servlet = servlet;
    }

    public CommandLineParser getCommandLineParser() {
        return this.cl;
    }

    public void setFileUtils(FileUtils fileUtils) {
        this.fileUtils = fileUtils;
    }

    public static synchronized void reportMessage(String message) {
        if (!MailHelper.sendEmail((boolean)true, (String)MailHelper.defaultFromAddress, (String)MailHelper.defaultFromAddress, (String)message, (String)"Total Validator Error Report", null)) {
            Log.entry((String)("Message not emailed: " + message));
        }
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    public synchronized boolean checkCancelled() {
        return this.cancelled;
    }

    public synchronized void kill() {
        this.killed = true;
        this.cancelled = true;
        this.interrupt();
    }

    public synchronized boolean isKilled() {
        return this.killed;
    }

    public void setOption(Option option) {
        this.option = option;
    }

    public void updateCounts(int pageCount, String nextUrl) {
        if (this.listener != null) {
            ActionEvent event = new ActionEvent(this, pageCount, nextUrl);
            this.listener.actionPerformed(event);
        }
        --this.pagesLeft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() instanceof Validator) {
            int maxPages = this.cl.getMaxPages();
            int pageCount = event.getID();
            int mPages = maxPages - pageCount;
            String[] liveMessages = new String[]{"Pages validated/queued:", pageCount + SPACED_SLASH + (maxPages > 1 && this.pagesLeft > mPages ? mPages : this.pagesLeft)};
            GeneralUtils.LOGGER.info(liveMessages[0] + " " + liveMessages[1]);
            pleaseWait.getInfoPanel().setLiveMessages(liveMessages);
        } else {
            Validator validator = this;
            synchronized (validator) {
                if (pleaseWait != null) {
                    pleaseWait.dispose();
                    pleaseWait = null;
                }
            }
            this.cancel();
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public String getAge() {
        String time = "";
        long secs = (System.currentTimeMillis() - this.startTime) / 1000L;
        long mins = secs / 60L;
        time = mins > 0L ? mins + "m " + secs % 60L + "s" : secs + "s";
        return time;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public int getTotalErrors() {
        return this.totalErrors;
    }

    public int getTotalWarnings() {
        return this.totalWarnings;
    }

    public void setResultsFile(String resultsFile) {
        this.resultsFile = resultsFile;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }
}

