/*
 * Decompiled with CFR 0.152.
 */
package org.vafada.jimagemapper;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.vafada.jimagemapper.AttributeBean;
import org.vafada.jimagemapper.SpringUtilities;

public class AttributesDialog
extends JDialog {
    private static final String[] labels = new String[]{"HREF: ", "ALT: ", "TITLE: ", "onMouseOver: ", "onMouseOut: ", "onClick: "};
    private JTextField[] textFields;
    private int numPairs = labels.length;
    private boolean isClosed = true;
    private AttributeBean attributes;
    private JFrame parent;

    public AttributesDialog(JFrame jFrame) {
        super(jFrame, "Attributes", true);
        this.parent = jFrame;
        this.initComponents();
        this.setVisible(true);
    }

    public AttributesDialog(JFrame jFrame, AttributeBean attributeBean) {
        super(jFrame, "Attributes", true);
        this.parent = jFrame;
        this.initComponents();
        this.setAttributes(attributeBean);
        this.setVisible(true);
    }

    private void setAttributes(AttributeBean attributeBean) {
        this.textFields[0].setText(attributeBean.getHref());
        this.textFields[1].setText(attributeBean.getAlt());
        this.textFields[2].setText(attributeBean.getTitle());
        this.textFields[3].setText(attributeBean.getOnMouseOver());
        this.textFields[4].setText(attributeBean.getOnMouseOut());
        this.textFields[5].setText(attributeBean.getOnClick());
    }

    private void initComponents() {
        JComponent jComponent;
        JPanel jPanel = new JPanel(new SpringLayout());
        this.textFields = new JTextField[this.numPairs];
        for (int i = 0; i < this.numPairs; ++i) {
            jComponent = new JLabel(labels[i], 11);
            jPanel.add(jComponent);
            this.textFields[i] = new JTextField(10);
            ((JLabel)jComponent).setLabelFor(this.textFields[i]);
            jPanel.add(this.textFields[i]);
        }
        JButton jButton = new JButton("Ok");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributesDialog.this.isClosed = false;
                AttributesDialog.this.attributes = new AttributeBean();
                AttributesDialog.this.attributes.setHref(AttributesDialog.this.textFields[0].getText());
                AttributesDialog.this.attributes.setAlt(AttributesDialog.this.textFields[1].getText());
                AttributesDialog.this.attributes.setTitle(AttributesDialog.this.textFields[2].getText());
                AttributesDialog.this.attributes.setOnMouseOver(AttributesDialog.this.textFields[3].getText());
                AttributesDialog.this.attributes.setOnMouseOut(AttributesDialog.this.textFields[4].getText());
                AttributesDialog.this.attributes.setOnClick(AttributesDialog.this.textFields[5].getText());
                AttributesDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        jComponent = new JButton("Cancel");
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributesDialog.this.isClosed = true;
                AttributesDialog.this.dispose();
            }
        });
        jPanel.add(jComponent);
        SpringUtilities.makeCompactGrid(jPanel, this.numPairs + 1, 2, 6, 6, 6, 6);
        this.setContentPane(jPanel);
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        Point point = this.parent.getLocation();
        this.setLocation(point.x + (this.parent.getWidth() - this.getWidth()) / 2, point.y + (this.parent.getHeight() - this.getHeight()) / 2);
        this.pack();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public AttributeBean getAttributes() {
        return this.attributes;
    }
}

