/*
 * Decompiled with CFR 0.152.
 */
package dk.hfalk.hotedit.util;

import dk.hfalk.hotedit.util.TextSelectDialog;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.JTextField;

public class TextSelectEditor
extends DefaultCellEditor
implements Runnable {
    private TextSelectDialog dialog;
    protected String currentString;
    private boolean showingDialog;
    protected boolean canceled;

    public TextSelectEditor(JTextField jTextField) {
        super(jTextField);
        jTextField.setEditable(false);
        this.dialog = new TextSelectDialog(new JFrame(""), "Edit Cell!", this);
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        ((JTextField)this.editorComponent).setText("zooming...");
        if (object != null && object instanceof String) {
            this.currentString = (String)object;
        }
        return this.editorComponent;
    }

    public Object getCellEditorValue() {
        return this.currentString;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return eventObject instanceof MouseEvent && ((MouseEvent)eventObject).getClickCount() >= this.getClickCountToStart();
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        if (this.isCellEditable(eventObject)) {
            this.showDialog();
        }
        return true;
    }

    public boolean stopCellEditing() {
        this.canceled = false;
        this.currentString = this.dialog.getText();
        this.dismissDialog();
        return true;
    }

    public void cancelCellEditing() {
        this.canceled = true;
        this.dismissDialog();
    }

    private void showDialog() {
        if (!this.showingDialog) {
            Thread thread = new Thread(this);
            this.showingDialog = true;
            thread.start();
        }
    }

    protected void dismissDialog() {
        if (this.showingDialog) {
            this.dialog.hide();
            this.showingDialog = false;
        }
    }

    public void run() {
        this.dialog.setText(this.currentString);
        this.canceled = false;
        this.dialog.show();
        if (this.canceled) {
            this.fireEditingCanceled();
        } else {
            this.fireEditingStopped();
        }
    }
}

