/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.engine;

import com.swabunga.spell.engine.Transformator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;

public class GenericTransformator
implements Transformator {
    public static final char STARTMULTI = '(';
    public static final char ENDMULTI = ')';
    Object[] ruleArray = null;

    public GenericTransformator(File file) throws IOException {
        this.buildRules(new BufferedReader(new FileReader(file)));
    }

    public String transform(String string) {
        if (this.ruleArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.toUpperCase());
        int n = stringBuffer.length();
        int n2 = 1;
        block0: for (int i = 0; i < n; i += n2) {
            n2 = 1;
            for (int j = 0; j < this.ruleArray.length; ++j) {
                TransformationRule transformationRule = (TransformationRule)this.ruleArray[j];
                if (transformationRule.startsWithExp() && i > 0 || i + transformationRule.lengthOfMatch() >= n || !transformationRule.isMatching(stringBuffer, i)) continue;
                stringBuffer.replace(i, i + transformationRule.getTakeOut(), transformationRule.getReplaceExp());
                n2 = transformationRule.getReplaceExp().length();
                n -= transformationRule.getTakeOut();
                n += n2;
                continue block0;
            }
        }
        return stringBuffer.toString();
    }

    private void buildRules(BufferedReader bufferedReader) throws IOException {
        String string = null;
        LinkedList linkedList = new LinkedList();
        while ((string = bufferedReader.readLine()) != null) {
            this.buildRule(this.realTrimmer(string), linkedList);
        }
        this.ruleArray = linkedList.toArray();
    }

    private void buildRule(String string, LinkedList linkedList) {
        if (string.length() < 1) {
            return;
        }
        if (string.startsWith("version")) {
            return;
        }
        TransformationRule transformationRule = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        boolean bl3 = true;
        boolean bl4 = false;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) {
                bl3 = false;
                continue;
            }
            if (bl3) {
                if (!this.isReservedChar(string.charAt(i))) {
                    stringBuffer.append(string.charAt(i));
                    if (!bl4) {
                        ++n;
                        ++n2;
                    }
                    if (string.charAt(i) == '(' || string.charAt(i) == ')') {
                        boolean bl5 = bl4 = !bl4;
                    }
                }
                if (string.charAt(i) == '-') {
                    --n;
                }
                if (string.charAt(i) == '^') {
                    bl = true;
                }
                if (string.charAt(i) != '$') continue;
                bl2 = true;
                continue;
            }
            stringBuffer2.append(string.charAt(i));
        }
        transformationRule = new TransformationRule(stringBuffer.toString(), stringBuffer2.toString(), n, n2, bl, bl2);
        linkedList.add(transformationRule);
    }

    private boolean isReservedChar(char c) {
        return c == '<' || c == '>' || c == '^' || c == '$' || c == '-' || Character.isDigit(c);
    }

    private String realTrimmer(String string) {
        int n = string.indexOf(35);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string.trim();
    }

    private class TransformationRule {
        private String replace;
        private char[] match;
        private int takeOut;
        private int matchLength;
        private boolean start;
        private boolean end;

        public TransformationRule(String string, String string2, int n, int n2, boolean bl, boolean bl2) {
            this.match = string.toCharArray();
            this.replace = string2;
            this.takeOut = n;
            this.matchLength = n2;
            this.start = bl;
            this.end = bl2;
        }

        public boolean isMatching(StringBuffer stringBuffer, int n) {
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < this.match.length; ++i) {
                char c = this.match[i];
                if (c == '(' || c == ')') {
                    boolean bl4 = bl2 = !bl2;
                    if (!bl2) {
                        bl &= bl3;
                        continue;
                    }
                    bl3 = false;
                    continue;
                }
                if (c != stringBuffer.charAt(n)) {
                    if (bl2) {
                        bl3 |= false;
                    } else {
                        bl = false;
                    }
                } else if (bl2) {
                    bl3 |= true;
                } else {
                    bl = true;
                }
                if (!bl2) {
                    ++n;
                }
                if (!bl) break;
            }
            if (this.end && n != stringBuffer.length() - 1) {
                bl = false;
            }
            return bl;
        }

        public String getReplaceExp() {
            return this.replace;
        }

        public int getTakeOut() {
            return this.takeOut;
        }

        public boolean startsWithExp() {
            return this.start;
        }

        public int lengthOfMatch() {
            return this.matchLength;
        }

        public String toString() {
            return "Match:" + String.valueOf(this.match) + " Replace:" + this.replace + " TakeOut:" + this.takeOut + " MatchLength:" + this.matchLength + " Start:" + this.start + " End:" + this.end;
        }
    }
}

