/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class SharpTools
extends JFrame
implements ListSelectionListener {
    protected int maxNumPage = 1;
    private Container container;
    private JTable table;
    private JScrollPane scrollPane;
    private JToolBar toolBar;
    private JMenuBar menuBar;
    private JPanel barPanel;
    private History history;
    private Histogram histogram;
    private static Config config;
    private SharpTableModel tableModel;
    private ListSelectionModel rowSelectionModel;
    private ListSelectionModel columnSelectionModel;
    private URL url;
    private FileOp fileOp;
    private EditOp editOp;
    private TableOp tableOp;
    private JMenu fileMenu;
    private JMenu openMenu;
    private JMenu recentMenu;
    private JMenu editMenu;
    private JMenu tableMenu;
    private JMenu chartMenu;
    private JMenu helpMenu;
    private JMenu insertMenu;
    private JMenu deleteMenu;
    private JMenu sortMenu;
    private JMenuItem saveMenuItem;
    private JCheckBoxMenuItem saveOnExitMenuItem;
    private JMenuItem undoMenuItem;
    private JMenuItem redoMenuItem;
    private JMenuItem findNextMenuItem;
    private JCheckBoxMenuItem showHistogramMenuItem;
    private JCheckBoxMenuItem showFunctionsMenuItem;
    private JButton saveButton;
    private JButton passwordButton;
    private JButton undoButton;
    private JButton redoButton;
    private JComponent funcList;
    private final ImageIcon newIcon = SharpTools.getImageIcon("new.gif");
    private final ImageIcon openIcon = SharpTools.getImageIcon("open.gif");
    private final ImageIcon saveIcon = SharpTools.getImageIcon("save.gif");
    private final ImageIcon unlockedIcon = SharpTools.getImageIcon("unlocked.gif");
    private final ImageIcon lockedIcon = SharpTools.getImageIcon("locked.gif");
    private final ImageIcon printIcon = SharpTools.getImageIcon("print.gif");
    private final ImageIcon undoIcon = SharpTools.getImageIcon("undo.gif");
    private final ImageIcon redoIcon = SharpTools.getImageIcon("redo.gif");
    private final ImageIcon cutIcon = SharpTools.getImageIcon("cut.gif");
    private final ImageIcon copyIcon = SharpTools.getImageIcon("copy.gif");
    private final ImageIcon pasteIcon = SharpTools.getImageIcon("paste.gif");
    private final ImageIcon findIcon = SharpTools.getImageIcon("find.gif");
    private final ImageIcon insertRowIcon = SharpTools.getImageIcon("insertrow.gif");
    private final ImageIcon insertColumnIcon = SharpTools.getImageIcon("insertcolumn.gif");
    private final ImageIcon deleteRowIcon = SharpTools.getImageIcon("deleterow.gif");
    private final ImageIcon deleteColumnIcon = SharpTools.getImageIcon("deletecolumn.gif");
    private final ImageIcon sortIcon = SharpTools.getImageIcon("sort.gif");
    private final ImageIcon chartIcon = SharpTools.getImageIcon("chart.gif");
    private final ImageIcon helpIcon = SharpTools.getImageIcon("help.gif");
    public static int baseRow;
    public static int baseCol;
    static /* synthetic */ Class class$Cell;

    public static Config getConfig() {
        return config;
    }

    public History getHistory() {
        return this.history;
    }

    public JTable getTable() {
        return this.table;
    }

    public SharpTableModel getTableModel() {
        return this.tableModel;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public SharpTools() {
        super("Sharp Tools Spreadsheet");
        int n = config.getInt("X");
        int n2 = config.getInt("Y");
        Dimension dimension = this.getToolkit().getScreenSize();
        if (n >= 0 && n2 >= 0 && n < (int)dimension.getWidth() && n2 < (int)dimension.getHeight()) {
            this.setLocation(n, n2);
        }
        this.setDefaultCloseOperation(0);
        this.container = this.getContentPane();
        this.container.setLayout(new BorderLayout());
        this.table = new JTable();
        this.funcList = HelpOp.createFunctionListComponent(this, this.table);
        this.fileMenu = new JMenu("File", true);
        this.fileMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("New...");
        jMenuItem.setMnemonic(78);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.fileOp.newFile();
            }
        });
        this.fileMenu.add(jMenuItem);
        this.openMenu = new JMenu("Open");
        this.openMenu.setMnemonic(79);
        jMenuItem = new JMenuItem("File...");
        jMenuItem.setMnemonic(70);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.fileOp.openFile();
            }
        });
        this.openMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Database...");
        jMenuItem.setMnemonic(68);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.fileOp.openDb();
            }
        });
        this.openMenu.add(jMenuItem);
        this.fileMenu.add(this.openMenu);
        this.saveMenuItem = new JMenuItem("Save");
        this.saveMenuItem.setMnemonic(83);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.fileOp.saveFile();
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        jMenuItem = new JMenuItem("Save As...");
        jMenuItem.setMnemonic(65);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.fileOp.saveAsFile();
            }
        });
        this.fileMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Set Password...");
        jMenuItem.setMnemonic(69);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.fileOp.setPassword();
                SharpTools.this.checkPasswordState();
            }
        });
        this.fileMenu.add(jMenuItem);
        this.fileMenu.addSeparator();
        jMenuItem = new JMenuItem("Print...");
        jMenuItem.setMnemonic(80);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        SharpTools.access$000(7.access$100(this.this$1)).printData();
                    }
                };
                thread.start();
            }

            static /* synthetic */ SharpTools access$100(7 var0) {
                return var0.SharpTools.this;
            }
        });
        this.fileMenu.add(jMenuItem);
        this.fileMenu.addSeparator();
        this.recentMenu = new JMenu("Recent Files");
        this.recentMenu.setMnemonic(82);
        this.recentMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuSelected(MenuEvent menuEvent) {
                SharpTools.this.fileOp.createRecentFilesMenu(SharpTools.this.recentMenu);
            }
        });
        this.fileMenu.add(this.recentMenu);
        this.fileMenu.addSeparator();
        this.saveOnExitMenuItem = new JCheckBoxMenuItem("Save Window on Exit");
        this.saveOnExitMenuItem.setMnemonic(87);
        this.saveOnExitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                config.setBoolean("SAVEWINDOW", SharpTools.this.saveOnExitMenuItem.isSelected());
            }
        });
        this.saveOnExitMenuItem.setSelected(config.getBoolean("SAVEWINDOW"));
        this.fileMenu.add(this.saveOnExitMenuItem);
        this.fileMenu.addSeparator();
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.setMnemonic(88);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.exit();
            }
        });
        this.fileMenu.add(jMenuItem);
        this.editMenu = new JMenu("Edit", true);
        this.editMenu.setMnemonic(69);
        this.undoMenuItem = new JMenuItem("Undo");
        this.undoMenuItem.setMnemonic(85);
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.history.undo(SharpTools.this.tableModel);
            }
        });
        this.editMenu.add(this.undoMenuItem);
        this.redoMenuItem = new JMenuItem("Redo");
        this.redoMenuItem.setMnemonic(82);
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.redoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.history.redo(SharpTools.this.tableModel);
            }
        });
        this.editMenu.add(this.redoMenuItem);
        this.editMenu.addSeparator();
        jMenuItem = new JMenuItem("Cut");
        jMenuItem.setMnemonic(84);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.editOp.cut();
            }
        });
        this.editMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Copy");
        jMenuItem.setMnemonic(67);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.editOp.copy();
            }
        });
        this.editMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Paste");
        jMenuItem.setMnemonic(80);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.editOp.paste();
            }
        });
        this.editMenu.add(jMenuItem);
        this.editMenu.addSeparator();
        jMenuItem = new JMenuItem("Fill...");
        jMenuItem.setMnemonic(70);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.editOp.fill();
            }
        });
        this.editMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Clear");
        jMenuItem.setMnemonic(76);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0, true));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.editOp.clear();
            }
        });
        this.editMenu.add(jMenuItem);
        this.editMenu.addSeparator();
        jMenuItem = new JMenuItem("Find...");
        jMenuItem.setMnemonic(70);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.editOp.find(true);
            }
        });
        this.editMenu.add(jMenuItem);
        this.findNextMenuItem = new JMenuItem("Find Next");
        this.findNextMenuItem.setMnemonic(78);
        this.findNextMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.findNextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.editOp.find(false);
            }
        });
        this.editMenu.add(this.findNextMenuItem);
        this.tableMenu = new JMenu("Table", true);
        this.tableMenu.setMnemonic(84);
        this.insertMenu = new JMenu("Insert");
        this.insertMenu.setMnemonic(73);
        jMenuItem = new JMenuItem("Row");
        jMenuItem.setMnemonic(82);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(155, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.tableOp.insert(true);
            }
        });
        this.insertMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Column");
        jMenuItem.setMnemonic(67);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(155, 3));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.tableOp.insert(false);
            }
        });
        this.insertMenu.add(jMenuItem);
        this.tableMenu.add(this.insertMenu);
        this.deleteMenu = new JMenu("Delete");
        this.deleteMenu.setMnemonic(68);
        jMenuItem = new JMenuItem("Row");
        jMenuItem.setMnemonic(82);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.tableOp.remove(true);
            }
        });
        this.deleteMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Column");
        jMenuItem.setMnemonic(67);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 3));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.tableOp.remove(false);
            }
        });
        this.deleteMenu.add(jMenuItem);
        this.tableMenu.add(this.deleteMenu);
        this.tableMenu.addSeparator();
        this.sortMenu = new JMenu("Sort");
        this.sortMenu.setMnemonic(83);
        jMenuItem = new JMenuItem("Row...");
        jMenuItem.setMnemonic(82);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.tableOp.sort(true);
            }
        });
        this.sortMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Column...");
        jMenuItem.setMnemonic(67);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.tableOp.sort(false);
            }
        });
        this.sortMenu.add(jMenuItem);
        this.tableMenu.add(this.sortMenu);
        this.tableMenu.addSeparator();
        jMenuItem = new JMenuItem("Set Column Width...");
        jMenuItem.setMnemonic(87);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.tableOp.setColumnWidth();
            }
        });
        this.tableMenu.add(jMenuItem);
        this.chartMenu = new JMenu("Chart", true);
        this.chartMenu.setMnemonic(67);
        this.chartMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                SharpTools.this.checkShowHistogramState();
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        this.showHistogramMenuItem = new JCheckBoxMenuItem("Show");
        this.showHistogramMenuItem.setMnemonic(83);
        this.showHistogramMenuItem.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        this.showHistogramMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.histogram.toggle();
            }
        });
        this.chartMenu.add(this.showHistogramMenuItem);
        jMenuItem = new JMenuItem("Histogram...");
        jMenuItem.setMnemonic(72);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.histogram.addHistogram();
            }
        });
        this.chartMenu.add(jMenuItem);
        this.tableMenu.add(this.chartMenu);
        this.helpMenu = new JMenu("Help", true);
        this.helpMenu.setMnemonic(72);
        jMenuItem = new JMenuItem("Help Topics");
        jMenuItem.setMnemonic(72);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URL uRL = new URL("http://www.cs.columbia.edu/sharptools/");
                    new HelpOp(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    return;
                }
            }
        });
        this.helpMenu.add(jMenuItem);
        this.showFunctionsMenuItem = new JCheckBoxMenuItem("Show Functions");
        this.showFunctionsMenuItem.setMnemonic(83);
        this.showFunctionsMenuItem.setSelected(config.getBoolean("TOOLBAR_FUNCTIONS"));
        this.showFunctionsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = SharpTools.this.showFunctionsMenuItem.isSelected();
                config.setBoolean("TOOLBAR_FUNCTIONS", bl);
                SharpTools.this.funcList.setVisible(bl);
            }
        });
        this.helpMenu.add(this.showFunctionsMenuItem);
        this.helpMenu.addSeparator();
        jMenuItem = new JMenuItem("About SharpTools...");
        jMenuItem.setMnemonic(65);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpOp.showAboutBox(SharpTools.this);
                SharpTools.this.table.requestFocus();
            }
        });
        this.helpMenu.add(jMenuItem);
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.tableMenu);
        this.menuBar.add(this.chartMenu);
        this.menuBar.add(this.helpMenu);
        JButton jButton = new JButton(this.newIcon);
        jButton.setToolTipText("New");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.fileOp.newFile();
                SharpTools.this.table.requestFocus();
            }
        });
        JButton jButton2 = new JButton(this.openIcon);
        jButton2.setToolTipText("Open");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.fileOp.openFile();
                SharpTools.this.table.requestFocus();
            }
        });
        this.saveButton = new JButton(this.saveIcon);
        this.saveButton.setToolTipText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.fileOp.saveFile();
                SharpTools.this.table.requestFocus();
            }
        });
        this.passwordButton = new JButton(this.unlockedIcon);
        this.passwordButton.setToolTipText("Set Password");
        this.passwordButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.fileOp.setPassword();
                SharpTools.this.table.requestFocus();
            }
        });
        JButton jButton3 = new JButton(this.printIcon);
        jButton3.setToolTipText("Print");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(this){
                    private final /* synthetic */ 38 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        SharpTools.access$000(38.access$1300(this.this$1)).printData();
                    }
                };
                thread.start();
                SharpTools.this.table.requestFocus();
            }

            static /* synthetic */ SharpTools access$1300(38 var0) {
                return var0.SharpTools.this;
            }
        });
        this.undoButton = new JButton(this.undoIcon);
        this.undoButton.setToolTipText("Undo");
        this.undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.history.undo(SharpTools.this.tableModel);
                SharpTools.this.table.requestFocus();
            }
        });
        this.redoButton = new JButton(this.redoIcon);
        this.redoButton.setToolTipText("Redo");
        this.redoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.history.redo(SharpTools.this.tableModel);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton jButton4 = new JButton(this.cutIcon);
        jButton4.setToolTipText("Cut");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.editOp.cut();
                SharpTools.this.table.requestFocus();
            }
        });
        JButton jButton5 = new JButton(this.copyIcon);
        jButton5.setToolTipText("Copy");
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.editOp.copy();
                SharpTools.this.table.requestFocus();
            }
        });
        JButton jButton6 = new JButton(this.pasteIcon);
        jButton6.setToolTipText("Paste");
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.editOp.paste();
                SharpTools.this.table.requestFocus();
            }
        });
        JButton jButton7 = new JButton(this.findIcon);
        jButton7.setToolTipText("Find");
        jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.editOp.find(true);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton jButton8 = new JButton(this.sortIcon);
        jButton8.setToolTipText("Sort by Column");
        jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.tableOp.sort(false);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton jButton9 = new JButton(this.insertRowIcon);
        jButton9.setToolTipText("Insert Row");
        jButton9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.tableOp.insert(true);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton jButton10 = new JButton(this.insertColumnIcon);
        jButton10.setToolTipText("Insert Column");
        jButton10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.tableOp.insert(false);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton jButton11 = new JButton(this.deleteRowIcon);
        jButton11.setToolTipText("Delete Row");
        jButton11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.tableOp.remove(true);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton jButton12 = new JButton(this.deleteColumnIcon);
        jButton12.setToolTipText("Delete Column");
        jButton12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.tableOp.remove(false);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton jButton13 = new JButton(this.chartIcon);
        jButton13.setToolTipText("Histogram");
        jButton13.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharpTools.this.histogram.addHistogram();
                SharpTools.this.table.requestFocus();
            }
        });
        JButton jButton14 = new JButton(this.helpIcon);
        jButton14.setToolTipText("Help");
        jButton14.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = System.getProperty("user.dir");
                    SharpTools.this.url = new URL("http://www.cs.columbia.edu/sharptools/");
                    new HelpOp(SharpTools.this.url);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    return;
                }
                SharpTools.this.table.requestFocus();
            }
        });
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        if (config.getBoolean("TOOLBAR_NEW")) {
            this.toolBar.add(jButton);
        }
        if (config.getBoolean("TOOLBAR_OPEN")) {
            this.toolBar.add(jButton2);
        }
        if (config.getBoolean("TOOLBAR_SAVE")) {
            this.toolBar.add(this.saveButton);
        }
        this.toolBar.addSeparator();
        if (config.getBoolean("TOOLBAR_PASSWORD")) {
            this.toolBar.add(this.passwordButton);
        }
        if (config.getBoolean("TOOLBAR_PRINT")) {
            this.toolBar.add(jButton3);
        }
        this.toolBar.addSeparator();
        if (config.getBoolean("TOOLBAR_UNDO")) {
            this.toolBar.add(this.undoButton);
        }
        if (config.getBoolean("TOOLBAR_REDO")) {
            this.toolBar.add(this.redoButton);
        }
        if (config.getBoolean("TOOLBAR_CUT")) {
            this.toolBar.add(jButton4);
        }
        if (config.getBoolean("TOOLBAR_COPY")) {
            this.toolBar.add(jButton5);
        }
        if (config.getBoolean("TOOLBAR_PASTE")) {
            this.toolBar.add(jButton6);
        }
        if (config.getBoolean("TOOLBAR_FIND")) {
            this.toolBar.add(jButton7);
        }
        this.toolBar.addSeparator();
        if (config.getBoolean("TOOLBAR_INSERTROW")) {
            this.toolBar.add(jButton9);
        }
        if (config.getBoolean("TOOLBAR_INSERTCOLUMN")) {
            this.toolBar.add(jButton10);
        }
        if (config.getBoolean("TOOLBAR_DELETEROW")) {
            this.toolBar.add(jButton11);
        }
        if (config.getBoolean("TOOLBAR_DELETECOLUMN")) {
            this.toolBar.add(jButton12);
        }
        if (config.getBoolean("TOOLBAR_SORTCOLUMN")) {
            this.toolBar.add(jButton8);
        }
        this.toolBar.addSeparator();
        if (config.getBoolean("TOOLBAR_HISTOGRAM")) {
            this.toolBar.add(jButton13);
            this.toolBar.addSeparator();
        }
        if (config.getBoolean("TOOLBAR_HELP")) {
            this.toolBar.add(jButton14);
        }
        this.toolBar.addSeparator();
        this.toolBar.add(this.funcList);
        this.funcList.setVisible(config.getBoolean("TOOLBAR_FUNCTIONS"));
        this.newTableModel(config.getInt("ROWS"), config.getInt("COLUMNS"));
        int n3 = config.getInt("WIDTH");
        int n4 = config.getInt("HEIGHT");
        if (n3 >= 0 && n4 >= 0) {
            this.table.setPreferredScrollableViewportSize(new Dimension(n3, n4));
        }
        this.fileOp = new FileOp(this);
        this.table.setAutoResizeMode(0);
        this.table.setDefaultRenderer(class$Cell == null ? (class$Cell = SharpTools.class$("Cell")) : class$Cell, new SharpCellRenderer());
        this.table.setDefaultEditor(class$Cell == null ? (class$Cell = SharpTools.class$("Cell")) : class$Cell, new SharpCellEditor(new JTextField()));
        this.table.setSelectionMode(1);
        this.table.setCellSelectionEnabled(true);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().addMouseListener(new HeaderMouseAdapter());
        this.rowSelectionModel = this.table.getSelectionModel();
        this.columnSelectionModel = this.table.getColumnModel().getSelectionModel();
        this.rowSelectionModel.addListSelectionListener(this);
        this.columnSelectionModel.addListSelectionListener(this);
        this.setJMenuBar(this.menuBar);
        this.container.add((Component)this.toolBar, "North");
        this.scrollPane = new JScrollPane(this.table, 22, 32);
        this.container.add((Component)this.scrollPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                SharpTools.this.table.requestFocus();
            }

            public void windowClosing(WindowEvent windowEvent) {
                SharpTools.this.exit();
            }
        });
        this.resetSelection();
        this.table.setRequestFocusEnabled(true);
        this.menuBar.setRequestFocusEnabled(false);
        this.toolBar.setRequestFocusEnabled(false);
        this.table.requestFocus();
        this.pack();
        this.show();
    }

    public void setColumnWidth(int n) {
        if (n > 0) {
            int n2 = baseCol;
            while (n2 < this.tableModel.getColumnCount()) {
                TableColumn tableColumn = this.table.getColumnModel().getColumn(n2);
                tableColumn.setMinWidth(n);
                tableColumn.setPreferredWidth(n);
                ++n2;
            }
        }
    }

    public void newTableModel(int n, int n2) {
        this.tableModel = new SharpTableModel(this, n, n2);
        this.table.setModel(this.tableModel);
        this.setBaseColumnWidth();
        this.setColumnWidth(config.getInt("COLUMNWIDTH"));
        this.history = new History(this);
        this.tableModel.setHistory(this.history);
        this.tableModel.setPasswordModified(false);
        this.tableModel.setModified(false);
        if (this.editOp == null) {
            this.editOp = new EditOp(this);
        } else {
            this.editOp.init(this);
        }
        this.tableOp = new TableOp(this);
        this.histogram = new Histogram(this, "Histograms", config.getInt("HISTOGRAMWIDTH"), config.getInt("HISTOGRAMHEIGHT"));
        this.tableModel.setModified(false);
        this.resetSelection();
        this.checkUndoRedoState();
        this.table.requestFocus();
    }

    public void noCellsSelected(String string) {
        SharpOptionPane.showMessageDialog(this, string + ": No cells selected", "Error", 0, null);
    }

    private void notYetImplemented() {
        SharpOptionPane.showMessageDialog(this, "Sorry, this function \nis not yet implemented!\nsharp@cs.columbia.edu", "Sharp Tools Spreadsheet", 2, null);
    }

    public void exit() {
        if (this.fileOp.closeFile()) {
            if (config.getBoolean("SAVEWINDOW")) {
                config.setInt("X", this.getX());
                config.setInt("Y", this.getY());
                Dimension dimension = this.scrollPane.getViewport().getExtentSize();
                config.setInt("WIDTH", (int)dimension.getWidth());
                config.setInt("HEIGHT", (int)dimension.getHeight());
            }
            config.save();
            System.exit(0);
        }
    }

    private void openInitFile(String string) {
        this.fileOp.openTableModel(new File(string));
    }

    public void checkSaveState() {
        boolean bl = this.tableModel.isModified();
        this.saveMenuItem.setEnabled(bl);
        this.saveButton.setEnabled(bl);
    }

    public void checkPasswordState() {
        if (this.fileOp.hasPassword()) {
            this.passwordButton.setIcon(this.lockedIcon);
        } else {
            this.passwordButton.setIcon(this.unlockedIcon);
        }
    }

    public void checkUndoRedoState() {
        boolean bl = this.history.isUndoable();
        this.undoMenuItem.setEnabled(bl);
        this.undoButton.setEnabled(bl);
        bl = this.history.isRedoable();
        this.redoMenuItem.setEnabled(bl);
        this.redoButton.setEnabled(bl);
    }

    public void checkFindNextState() {
        this.findNextMenuItem.setEnabled(this.editOp.hasFindValue());
    }

    public void checkShowHistogramState() {
        this.showHistogramMenuItem.setState(this.histogram.isVisible());
        this.showHistogramMenuItem.setEnabled(this.histogram.hasChart());
    }

    public void setBaseColumnWidth() {
        if (baseCol > 0) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(baseCol - 1);
            int n = config.getInt("FIRSTCOLUMNWIDTH");
            if (n > 0) {
                tableColumn.setMinWidth(n);
                tableColumn.setPreferredWidth(n);
            }
        }
    }

    public static void main(String[] stringArray) {
        config = new Config("sharptools.ini");
        config.setInt("ROWS", 20);
        config.setInt("COLUMNS", 10);
        config.setInt("HISTOGRAMWIDTH", 600);
        config.setInt("HISTOGRAMHEIGHT", 400);
        config.load();
        if (config.get("DEBUG") != null) {
            Debug.setDebug(config.getBoolean("DEBUG"));
        }
        Formula.registerFunctions();
        SharpTools sharpTools = new SharpTools();
        sharpTools.show();
        if (stringArray.length > 0) {
            sharpTools.openInitFile(stringArray[0]);
        }
    }

    public static ImageIcon getImageIcon(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL == null) {
            System.out.println("image " + string + " not found");
            return null;
        }
        return new ImageIcon(uRL);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.table.requestFocus();
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (listSelectionModel.isSelectionEmpty() && this.table.getColumnCount() > baseCol && this.table.getRowCount() > baseRow) {
            this.table.setRowSelectionInterval(baseRow, baseRow);
            this.table.setColumnSelectionInterval(baseCol, baseCol);
        }
    }

    public void resetSelection() {
        this.table.setRowSelectionInterval(baseRow, baseRow);
        this.table.setColumnSelectionInterval(baseCol, baseCol);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        baseRow = 0;
        baseCol = 1;
    }

    class HeaderMouseAdapter
    extends MouseAdapter {
        HeaderMouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            TableColumnModel tableColumnModel = SharpTools.this.table.getColumnModel();
            int n = tableColumnModel.getColumn(tableColumnModel.getColumnIndexAtX(mouseEvent.getX())).getModelIndex();
            int n2 = SharpTools.this.table.getRowCount();
            SharpTools.this.table.setRowSelectionInterval(baseRow, n2 - 1);
            if (n < baseCol) {
                SharpTools.this.table.setColumnSelectionInterval(baseCol, SharpTools.this.table.getColumnCount() - 1);
            } else {
                SharpTools.this.table.setColumnSelectionInterval(n, n);
            }
        }
    }
}

