/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPasswordField;

public class PasswordDialog
extends SharpDialog {
    private JFrame frame;
    private String typedText = null;
    private String password;
    private final JPasswordField textField;
    private final JPasswordField confirmField;
    private static final ImageIcon passwordIcon = SharpTools.getImageIcon("password32.gif");

    public PasswordDialog(JFrame jFrame, String string) {
        super(jFrame, "Password", true);
        this.frame = jFrame;
        this.password = string;
        this.textField = new JPasswordField(10);
        this.confirmField = new JPasswordField(10);
        Object[] objectArray = new Object[]{"Enter password:", this.textField, "Confirm Password:", this.confirmField};
        Object[] objectArray2 = new Object[]{"Enter password:", this.textField};
        Object[] objectArray3 = this.password == null ? objectArray : objectArray2;
        this.setOptionPane(objectArray3, 3, 2, passwordIcon);
    }

    public String getValidatedText() {
        return this.typedText;
    }

    private static boolean fieldsAreTheSame(char[] cArray, char[] cArray2) {
        if (cArray.length != cArray2.length) {
            return false;
        }
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] != cArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean onOK() {
        this.typedText = new String(this.textField.getPassword());
        if (this.password != null) {
            if (!this.typedText.equals(this.password)) {
                SharpOptionPane.showMessageDialog(this, "Password Incorrect!", "Password", 0);
                this.textField.setText(null);
                this.textField.requestFocus();
                return false;
            }
            return true;
        }
        if (PasswordDialog.fieldsAreTheSame(this.textField.getPassword(), this.confirmField.getPassword())) {
            return true;
        }
        this.textField.selectAll();
        SharpOptionPane.showMessageDialog(this, "Passwords do not match!\nPlease try again.", "Password", 0, null);
        this.typedText = null;
        this.textField.setText(null);
        this.confirmField.setText(null);
        this.textField.requestFocus();
        return false;
    }

    protected boolean onCancel() {
        this.typedText = null;
        return true;
    }

    protected void onOpen() {
        this.textField.requestFocus();
    }
}

