/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class NewFileDialog
extends SharpDialog {
    private int rows;
    private int cols;
    private static final ImageIcon newFileIcon = SharpTools.getImageIcon("new32.gif");
    final NumberField rowField;
    final NumberField colField;
    final JCheckBox saveDefault;

    public NewFileDialog(JFrame jFrame, int n, int n2) {
        super(jFrame, "New", true);
        JLabel jLabel = new JLabel("Rows: ");
        JLabel jLabel2 = new JLabel("Columns: ");
        this.rowField = new NumberField(5, true, true);
        this.colField = new NumberField(5, true, true);
        jLabel.setLabelFor(this.rowField);
        jLabel2.setLabelFor(this.colField);
        jLabel.setDisplayedMnemonic(82);
        jLabel2.setDisplayedMnemonic(67);
        this.saveDefault = new JCheckBox("Save as default", false);
        this.saveDefault.setMnemonic(83);
        this.rowField.setText(String.valueOf(n));
        this.colField.setText(String.valueOf(n2));
        Object[] objectArray = new Object[]{jLabel, this.rowField, jLabel2, this.colField, this.saveDefault};
        this.setOptionPane(objectArray, 3, 2, newFileIcon);
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.cols;
    }

    private void newFileError(String string, JTextField jTextField) {
        SharpOptionPane.showMessageDialog(this, string, "Error", 0);
        jTextField.selectAll();
        jTextField.requestFocus();
    }

    protected boolean onOK() {
        try {
            this.rows = this.rowField.getInteger();
        }
        catch (Exception exception) {
            this.rows = 0;
        }
        if (this.rows <= 0) {
            this.newFileError("Invalid row value", this.rowField);
            return false;
        }
        try {
            this.cols = this.colField.getInteger();
        }
        catch (Exception exception) {
            this.cols = 0;
        }
        if (this.cols <= 0) {
            this.newFileError("Invalid column value", this.colField);
            return false;
        }
        if (this.saveDefault.isSelected()) {
            Config config = SharpTools.getConfig();
            config.setInt("ROWS", this.rows);
            config.setInt("COLUMNS", this.cols);
        }
        return true;
    }

    protected boolean onCancel() {
        this.cols = 0;
        this.rows = 0;
        return true;
    }

    protected void onOpen() {
        this.rowField.selectAll();
        this.rowField.requestFocus();
    }

    protected boolean onClose() {
        this.cols = 0;
        this.rows = 0;
        return true;
    }
}

