/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.tools.d3d;

import com.eteks.tools.d3d.CoordinatesArray;
import com.eteks.tools.d3d.Point3D;

public class Vector3D
extends CoordinatesArray {
    public Vector3D() {
        this.coord = new float[3];
    }

    public Vector3D(float f, float f2, float f3) {
        this();
        this.coord[0] = f;
        this.coord[1] = f2;
        this.coord[2] = f3;
    }

    public Vector3D(Point3D point3D) {
        this();
        this.coord[0] = point3D.getX();
        this.coord[1] = point3D.getY();
        this.coord[2] = point3D.getZ();
    }

    public Vector3D(Point3D point3D, Point3D point3D2) {
        this();
        this.coord[0] = point3D.coord[0] - point3D2.coord[0];
        this.coord[1] = point3D.coord[1] - point3D2.coord[1];
        this.coord[2] = point3D.coord[2] - point3D2.coord[2];
    }

    public final float getLength() {
        float f = 0.0f;
        int n = 0;
        while (n <= 2) {
            f += this.coord[n] * this.coord[n];
            ++n;
        }
        return (float)Math.sqrt(f);
    }

    public float getDotProduct(Vector3D vector3D) {
        float f = 0.0f;
        int n = 0;
        while (n <= 2) {
            f += this.coord[n] * vector3D.coord[n];
            ++n;
        }
        return f;
    }

    public Vector3D getCrossProduct(Vector3D vector3D) {
        Vector3D vector3D2 = new Vector3D();
        int n = 0;
        while (n <= 2) {
            vector3D2.coord[n] = this.coord[(n + 1) % 3] * vector3D.coord[(n + 2) % 3] - this.coord[(n + 2) % 3] * vector3D.coord[(n + 1) % 3];
            ++n;
        }
        return vector3D2;
    }
}

