/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.parser;

import com.eteks.parser.Function;
import com.eteks.parser.Interpreter;
import com.eteks.parser.Syntax;

public class DoubleInterpreter
implements Interpreter {
    public static final Double FALSE_DOUBLE = new Double(0.0);
    public static final Double TRUE_DOUBLE = new Double(1.0);
    private static final Double PI_DOUBLE = new Double(Math.PI);
    private static final Double E_DOUBLE = new Double(Math.E);

    public Object getLiteralValue(Object object) {
        if (object instanceof Double) {
            return object;
        }
        if (object instanceof Number) {
            return new Double(((Number)object).doubleValue());
        }
        throw new IllegalArgumentException("Literal " + object + " not an instance of Number");
    }

    public Object getParameterValue(Object object) {
        if (object instanceof Double) {
            return object;
        }
        if (object instanceof Number) {
            return new Double(((Number)object).doubleValue());
        }
        throw new IllegalArgumentException("Parameter " + object + " not an instance of Number");
    }

    public Object getConstantValue(Object object) {
        if (Syntax.CONSTANT_PI.equals(object)) {
            return PI_DOUBLE;
        }
        if (Syntax.CONSTANT_E.equals(object)) {
            return E_DOUBLE;
        }
        if (Syntax.CONSTANT_FALSE.equals(object)) {
            return FALSE_DOUBLE;
        }
        if (Syntax.CONSTANT_TRUE.equals(object)) {
            return TRUE_DOUBLE;
        }
        throw new IllegalArgumentException("Constant key " + object + " not implemented");
    }

    public Object getUnaryOperatorValue(Object object, Object object2) {
        if (!(object2 instanceof Number)) {
            throw new IllegalArgumentException("Operand " + object2 + " not an instance of Number");
        }
        double d = ((Number)object2).doubleValue();
        if (object.equals(Syntax.OPERATOR_OPPOSITE)) {
            return new Double(-d);
        }
        if (object.equals(Syntax.OPERATOR_POSITIVE)) {
            return object2;
        }
        if (object.equals(Syntax.OPERATOR_LOGICAL_NOT)) {
            return this.isTrue(object2) ? FALSE_DOUBLE : TRUE_DOUBLE;
        }
        if (object.equals(Syntax.OPERATOR_BITWISE_NOT)) {
            if (Math.floor(d) != d) {
                throw new IllegalArgumentException("Operator operand not an integer");
            }
            return new Double(((Number)object2).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
        }
        throw new IllegalArgumentException("Unary operator key " + object + " not implemented");
    }

    public Object getBinaryOperatorValue(Object object, Object object2, Object object3) {
        if (!(object2 instanceof Number)) {
            throw new IllegalArgumentException("Operand " + object2 + " not an instance of Number");
        }
        if (!(object3 instanceof Number)) {
            throw new IllegalArgumentException("Operand " + object3 + " not an instance of Number");
        }
        double d = ((Number)object2).doubleValue();
        double d2 = ((Number)object3).doubleValue();
        if (object.equals(Syntax.OPERATOR_ADD)) {
            return new Double(d + d2);
        }
        if (object.equals(Syntax.OPERATOR_SUBSTRACT)) {
            return new Double(d - d2);
        }
        if (object.equals(Syntax.OPERATOR_MULTIPLY)) {
            return new Double(d * d2);
        }
        if (object.equals(Syntax.OPERATOR_DIVIDE)) {
            return new Double(d / d2);
        }
        if (object.equals(Syntax.OPERATOR_POWER)) {
            return new Double(Math.pow(d, d2));
        }
        if (object.equals(Syntax.OPERATOR_MODULO)) {
            double d3 = d - d2 * (double)((int)(d / d2));
            if (d < 0.0 && d2 > 0.0 || d > 0.0 && d2 < 0.0) {
                d3 += d2;
            }
            return new Double(d3);
        }
        if (object.equals(Syntax.OPERATOR_REMAINDER)) {
            return new Double(d % d2);
        }
        if (object.equals(Syntax.OPERATOR_EQUAL)) {
            return d == d2 ? TRUE_DOUBLE : FALSE_DOUBLE;
        }
        if (object.equals(Syntax.OPERATOR_DIFFERENT)) {
            return d != d2 ? TRUE_DOUBLE : FALSE_DOUBLE;
        }
        if (object.equals(Syntax.OPERATOR_GREATER_OR_EQUAL)) {
            return d >= d2 ? TRUE_DOUBLE : FALSE_DOUBLE;
        }
        if (object.equals(Syntax.OPERATOR_LESS_OR_EQUAL)) {
            return d <= d2 ? TRUE_DOUBLE : FALSE_DOUBLE;
        }
        if (object.equals(Syntax.OPERATOR_GREATER)) {
            return d > d2 ? TRUE_DOUBLE : FALSE_DOUBLE;
        }
        if (object.equals(Syntax.OPERATOR_LESS)) {
            return d < d2 ? TRUE_DOUBLE : FALSE_DOUBLE;
        }
        if (object.equals(Syntax.OPERATOR_LOGICAL_OR)) {
            return this.isTrue(object2) || this.isTrue(object3) ? TRUE_DOUBLE : FALSE_DOUBLE;
        }
        if (object.equals(Syntax.OPERATOR_LOGICAL_AND)) {
            return this.isTrue(object2) && this.isTrue(object3) ? TRUE_DOUBLE : FALSE_DOUBLE;
        }
        if (object.equals(Syntax.OPERATOR_LOGICAL_XOR)) {
            return this.isTrue(object2) && !this.isTrue(object3) || !this.isTrue(object2) && this.isTrue(object3) ? TRUE_DOUBLE : FALSE_DOUBLE;
        }
        if (Math.floor(d) != d) {
            throw new IllegalArgumentException("Operand " + object2 + " of bit operator not an integer");
        }
        if (Math.floor(d2) != d2) {
            throw new IllegalArgumentException("Operand " + object3 + " of bit operator not an integer");
        }
        if (object.equals(Syntax.OPERATOR_BITWISE_OR)) {
            return new Double((long)d | (long)d2);
        }
        if (object.equals(Syntax.OPERATOR_BITWISE_XOR)) {
            return new Double((long)d ^ (long)d2);
        }
        if (object.equals(Syntax.OPERATOR_BITWISE_AND)) {
            return new Double((long)d & (long)d2);
        }
        if (object.equals(Syntax.OPERATOR_SHIFT_LEFT)) {
            return new Double((long)d << (int)d2);
        }
        if (object.equals(Syntax.OPERATOR_SHIFT_RIGHT)) {
            return new Double((long)d >> (int)d2);
        }
        if (object.equals(Syntax.OPERATOR_SHIFT_RIGHT_0)) {
            return new Double((long)d >>> (int)d2);
        }
        throw new IllegalArgumentException("Binary operator key " + object + " not implemented");
    }

    public Object getCommonFunctionValue(Object object, Object object2) {
        if (!(object2 instanceof Number)) {
            throw new IllegalArgumentException("Parameter " + object2 + " not an instance of Number");
        }
        double d = ((Number)object2).doubleValue();
        if (object.equals(Syntax.FUNCTION_LN)) {
            return new Double(Math.log(d));
        }
        if (object.equals(Syntax.FUNCTION_LOG)) {
            return new Double(Math.log(d) / Math.log(10.0));
        }
        if (object.equals(Syntax.FUNCTION_EXP)) {
            return new Double(Math.exp(d));
        }
        if (object.equals(Syntax.FUNCTION_SQR)) {
            return new Double(d * d);
        }
        if (object.equals(Syntax.FUNCTION_SQRT)) {
            return new Double(Math.sqrt(d));
        }
        if (object.equals(Syntax.FUNCTION_COS)) {
            return new Double(Math.cos(d));
        }
        if (object.equals(Syntax.FUNCTION_SIN)) {
            return new Double(Math.sin(d));
        }
        if (object.equals(Syntax.FUNCTION_TAN)) {
            return new Double(Math.tan(d));
        }
        if (object.equals(Syntax.FUNCTION_ACOS)) {
            return new Double(Math.acos(d));
        }
        if (object.equals(Syntax.FUNCTION_ASIN)) {
            return new Double(Math.asin(d));
        }
        if (object.equals(Syntax.FUNCTION_ATAN)) {
            return new Double(Math.atan(d));
        }
        if (object.equals(Syntax.FUNCTION_COSH)) {
            return new Double((Math.exp(d) + Math.exp(-d)) / 2.0);
        }
        if (object.equals(Syntax.FUNCTION_SINH)) {
            return new Double((Math.exp(d) - Math.exp(-d)) / 2.0);
        }
        if (object.equals(Syntax.FUNCTION_TANH)) {
            return new Double((Math.exp(d) - Math.exp(-d)) / (Math.exp(d) + Math.exp(-d)));
        }
        if (object.equals(Syntax.FUNCTION_INTEGER)) {
            return new Double(((Number)object2).longValue());
        }
        if (object.equals(Syntax.FUNCTION_FLOOR)) {
            return new Double(Math.floor(d));
        }
        if (object.equals(Syntax.FUNCTION_CEIL)) {
            return new Double(Math.ceil(d));
        }
        if (object.equals(Syntax.FUNCTION_ROUND)) {
            return new Double(Math.rint(d));
        }
        if (object.equals(Syntax.FUNCTION_ABS)) {
            return new Double(Math.abs(d));
        }
        if (object.equals(Syntax.FUNCTION_OPPOSITE)) {
            return new Double(-d);
        }
        if (object.equals(Syntax.FUNCTION_NOT)) {
            return this.isTrue(object2) ? FALSE_DOUBLE : TRUE_DOUBLE;
        }
        throw new IllegalArgumentException("Common function key " + object + " not implemented");
    }

    public Object getConditionValue(Object object, Object object2, Object object3) {
        return this.isTrue(object) ? object2 : object3;
    }

    public boolean isTrue(Object object) {
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("Condition " + object + " not an instance of Number");
        }
        return ((Number)object).doubleValue() != 0.0;
    }

    public boolean supportsRecursiveCall() {
        return true;
    }

    public Object getFunctionValue(Function function, Object[] objectArray, boolean bl) {
        return function.computeFunction(this, objectArray);
    }
}

