/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.jeks;

import com.eteks.parser.AbstractSyntax;
import com.eteks.parser.Syntax;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class ResourceSyntax
extends AbstractSyntax {
    private Hashtable constants = new Hashtable();
    private Hashtable unaryOperators = new Hashtable();
    private Hashtable binaryOperators = new Hashtable();
    private Hashtable conditionParts = new Hashtable();
    private Hashtable commonFunctions = new Hashtable();
    private ResourceBundle resourceBundle;

    public ResourceSyntax(ResourceBundle resourceBundle) {
        super(ResourceSyntax.getResourceBoolean(resourceBundle, "CASE_SENSITIVE"));
        this.resourceBundle = resourceBundle;
        this.setResourceConstantKey("CONSTANT_PI", Syntax.CONSTANT_PI);
        this.setResourceConstantKey("CONSTANT_E", Syntax.CONSTANT_E);
        this.setResourceConstantKey("CONSTANT_FALSE", Syntax.CONSTANT_FALSE);
        this.setResourceConstantKey("CONSTANT_TRUE", Syntax.CONSTANT_TRUE);
        this.setResourceUnaryOperatorKey("OPERATOR_POSITIVE", Syntax.OPERATOR_POSITIVE);
        this.setResourceUnaryOperatorKey("OPERATOR_OPPOSITE", Syntax.OPERATOR_OPPOSITE);
        this.setResourceUnaryOperatorKey("OPERATOR_LOGICAL_NOT", Syntax.OPERATOR_LOGICAL_NOT);
        this.setResourceUnaryOperatorKey("OPERATOR_BITWISE_NOT", Syntax.OPERATOR_BITWISE_NOT);
        this.setResourceBinaryOperatorKey("OPERATOR_ADD", Syntax.OPERATOR_ADD);
        this.setResourceBinaryOperatorKey("OPERATOR_SUBSTRACT", Syntax.OPERATOR_SUBSTRACT);
        this.setResourceBinaryOperatorKey("OPERATOR_DIVIDE", Syntax.OPERATOR_DIVIDE);
        this.setResourceBinaryOperatorKey("OPERATOR_MULTIPLY", Syntax.OPERATOR_MULTIPLY);
        this.setResourceBinaryOperatorKey("OPERATOR_POWER", Syntax.OPERATOR_POWER);
        this.setResourceBinaryOperatorKey("OPERATOR_MODULO", Syntax.OPERATOR_MODULO);
        this.setResourceBinaryOperatorKey("OPERATOR_REMAINDER", Syntax.OPERATOR_REMAINDER);
        this.setResourceBinaryOperatorKey("OPERATOR_EQUAL", Syntax.OPERATOR_EQUAL);
        this.setResourceBinaryOperatorKey("OPERATOR_DIFFERENT", Syntax.OPERATOR_DIFFERENT);
        this.setResourceBinaryOperatorKey("OPERATOR_GREATER_OR_EQUAL", Syntax.OPERATOR_GREATER_OR_EQUAL);
        this.setResourceBinaryOperatorKey("OPERATOR_LESS_OR_EQUAL", Syntax.OPERATOR_LESS_OR_EQUAL);
        this.setResourceBinaryOperatorKey("OPERATOR_GREATER", Syntax.OPERATOR_GREATER);
        this.setResourceBinaryOperatorKey("OPERATOR_LESS", Syntax.OPERATOR_LESS);
        this.setResourceBinaryOperatorKey("OPERATOR_LOGICAL_OR", Syntax.OPERATOR_LOGICAL_OR);
        this.setResourceBinaryOperatorKey("OPERATOR_LOGICAL_XOR", Syntax.OPERATOR_LOGICAL_XOR);
        this.setResourceBinaryOperatorKey("OPERATOR_LOGICAL_AND", Syntax.OPERATOR_LOGICAL_AND);
        this.setResourceBinaryOperatorKey("OPERATOR_BITWISE_OR", Syntax.OPERATOR_BITWISE_OR);
        this.setResourceBinaryOperatorKey("OPERATOR_BITWISE_XOR", Syntax.OPERATOR_BITWISE_XOR);
        this.setResourceBinaryOperatorKey("OPERATOR_BITWISE_AND", Syntax.OPERATOR_BITWISE_AND);
        this.setResourceBinaryOperatorKey("OPERATOR_SHIFT_LEFT", Syntax.OPERATOR_SHIFT_LEFT);
        this.setResourceBinaryOperatorKey("OPERATOR_SHIFT_RIGHT", Syntax.OPERATOR_SHIFT_RIGHT);
        this.setResourceBinaryOperatorKey("OPERATOR_SHIFT_RIGHT_0", Syntax.OPERATOR_SHIFT_RIGHT_0);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_ADD", Syntax.OPERATOR_ADD);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_SUBSTRACT", Syntax.OPERATOR_SUBSTRACT);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_MODULO", Syntax.OPERATOR_MODULO);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_DIVIDE", Syntax.OPERATOR_DIVIDE);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_MULTIPLY", Syntax.OPERATOR_MULTIPLY);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_POWER", Syntax.OPERATOR_POWER);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_LOGICAL_OR", Syntax.OPERATOR_LOGICAL_OR);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_LOGICAL_XOR", Syntax.OPERATOR_LOGICAL_XOR);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_LOGICAL_AND", Syntax.OPERATOR_LOGICAL_AND);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_BITWISE_OR", Syntax.OPERATOR_BITWISE_OR);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_BITWISE_XOR", Syntax.OPERATOR_BITWISE_XOR);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_BITWISE_AND", Syntax.OPERATOR_BITWISE_AND);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_SHIFT_LEFT", Syntax.OPERATOR_SHIFT_LEFT);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_SHIFT_RIGHT", Syntax.OPERATOR_SHIFT_RIGHT);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_SHIFT_RIGHT_0", Syntax.OPERATOR_SHIFT_RIGHT_0);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_EQUAL", Syntax.OPERATOR_EQUAL);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_DIFFERENT", Syntax.OPERATOR_DIFFERENT);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_GREATER_OR_EQUAL", Syntax.OPERATOR_GREATER_OR_EQUAL);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_LESS_OR_EQUAL", Syntax.OPERATOR_LESS_OR_EQUAL);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_GREATER", Syntax.OPERATOR_GREATER);
        this.setResourceBinaryOperatorPriority("OPERATOR_PRIORITY_LESS", Syntax.OPERATOR_LESS);
        this.setResourceCommonFunctionKey("FUNCTION_LN", Syntax.FUNCTION_LN);
        this.setResourceCommonFunctionKey("FUNCTION_LOG", Syntax.FUNCTION_LOG);
        this.setResourceCommonFunctionKey("FUNCTION_EXP", Syntax.FUNCTION_EXP);
        this.setResourceCommonFunctionKey("FUNCTION_SQR", Syntax.FUNCTION_SQR);
        this.setResourceCommonFunctionKey("FUNCTION_SQRT", Syntax.FUNCTION_SQRT);
        this.setResourceCommonFunctionKey("FUNCTION_COS", Syntax.FUNCTION_COS);
        this.setResourceCommonFunctionKey("FUNCTION_SIN", Syntax.FUNCTION_SIN);
        this.setResourceCommonFunctionKey("FUNCTION_TAN", Syntax.FUNCTION_TAN);
        this.setResourceCommonFunctionKey("FUNCTION_ACOS", Syntax.FUNCTION_ACOS);
        this.setResourceCommonFunctionKey("FUNCTION_ASIN", Syntax.FUNCTION_ASIN);
        this.setResourceCommonFunctionKey("FUNCTION_ATAN", Syntax.FUNCTION_ATAN);
        this.setResourceCommonFunctionKey("FUNCTION_COSH", Syntax.FUNCTION_COSH);
        this.setResourceCommonFunctionKey("FUNCTION_SINH", Syntax.FUNCTION_SINH);
        this.setResourceCommonFunctionKey("FUNCTION_TANH", Syntax.FUNCTION_TANH);
        this.setResourceCommonFunctionKey("FUNCTION_INTEGER", Syntax.FUNCTION_INTEGER);
        this.setResourceCommonFunctionKey("FUNCTION_FLOOR", Syntax.FUNCTION_FLOOR);
        this.setResourceCommonFunctionKey("FUNCTION_CEIL", Syntax.FUNCTION_CEIL);
        this.setResourceCommonFunctionKey("FUNCTION_ROUND", Syntax.FUNCTION_ROUND);
        this.setResourceCommonFunctionKey("FUNCTION_ABS", Syntax.FUNCTION_ABS);
        this.setResourceCommonFunctionKey("FUNCTION_OPPOSITE", Syntax.FUNCTION_OPPOSITE);
        this.setResourceCommonFunctionKey("FUNCTION_NOT", Syntax.FUNCTION_NOT);
        this.setResourceConditionPartKey("CONDITION_IF", Syntax.CONDITION_IF);
        this.setResourceConditionPartKey("CONDITION_THEN", Syntax.CONDITION_THEN);
        this.setResourceConditionPartKey("CONDITION_ELSE", Syntax.CONDITION_ELSE);
        this.setWhiteSpaceCharacters(this.getResourceString("WHITE_SPACE_CHARS"));
        this.setOpeningBracket(this.getResourceChar("OPEN_BRACKET"));
        this.setClosingBracket(this.getResourceChar("CLOSE_BRACKET"));
        this.setParameterSeparator(this.getResourceChar("PARAMETER_SEPARATOR"));
        this.setAssignmentOperator(this.getResourceString("ASSIGNMENT_OPERATOR"));
        this.setShortSyntax(this.getResourceBoolean("SHORT_SYNTAX"));
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceConstantKey(String string, Object object) {
        String string2 = this.getResourceString(string);
        if (string2 != null) {
            this.setConstantKey(string2, object);
            this.constants.put(object, string2);
        }
    }

    public void setResourceUnaryOperatorKey(String string, Object object) {
        String string2 = this.getResourceString(string);
        if (string2 != null) {
            this.setUnaryOperatorKey(string2, object);
            this.unaryOperators.put(object, string2);
        }
    }

    public void setResourceBinaryOperatorKey(String string, Object object) {
        String string2 = this.getResourceString(string);
        if (string2 != null) {
            this.setBinaryOperatorKey(string2, object);
            this.binaryOperators.put(object, string2);
        }
    }

    public void setResourceBinaryOperatorPriority(String string, Object object) {
        String string2 = this.getResourceString(string);
        if (string2 != null) {
            this.setBinaryOperatorPriority(object, Integer.parseInt(string2));
        }
    }

    public void setResourceConditionPartKey(String string, Object object) {
        String string2 = this.getResourceString(string);
        if (string2 != null) {
            this.setConditionPartKey(string2, object);
            this.conditionParts.put(object, string2);
        }
    }

    public void setResourceCommonFunctionKey(String string, Object object) {
        String string2 = this.getResourceString(string);
        if (string2 != null) {
            this.setCommonFunctionKey(string2, object);
            this.commonFunctions.put(object, string2);
        }
    }

    public String getResourceString(String string) {
        return ResourceSyntax.getResourceString(this.resourceBundle, string);
    }

    public static String getResourceString(ResourceBundle resourceBundle, String string) {
        try {
            String string2 = resourceBundle.getString(string);
            if (string2.length() > 0) {
                return string2;
            }
        }
        catch (MissingResourceException missingResourceException) {}
        return null;
    }

    public char getResourceChar(String string) {
        return ResourceSyntax.getResourceChar(this.resourceBundle, string);
    }

    public static char getResourceChar(ResourceBundle resourceBundle, String string) {
        String string2 = ResourceSyntax.getResourceString(resourceBundle, string);
        if (string2 != null) {
            return string2.charAt(0);
        }
        return '\u0000';
    }

    public boolean getResourceBoolean(String string) {
        return ResourceSyntax.getResourceBoolean(this.resourceBundle, string);
    }

    public static boolean getResourceBoolean(ResourceBundle resourceBundle, String string) {
        String string2 = ResourceSyntax.getResourceString(resourceBundle, string);
        if (string2 != null) {
            return Boolean.valueOf(string2);
        }
        return false;
    }

    public String getConstant(Object object) {
        return (String)this.constants.get(object);
    }

    public String getUnaryOperator(Object object) {
        return (String)this.unaryOperators.get(object);
    }

    public String getBinaryOperator(Object object) {
        return (String)this.binaryOperators.get(object);
    }

    public String getConditionPart(Object object) {
        return (String)this.conditionParts.get(object);
    }

    public String getCommonFunction(Object object) {
        return (String)this.commonFunctions.get(object);
    }
}

