/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.jeks;

import com.eteks.jeks.JeksCell;
import com.eteks.jeks.JeksCellEditor;
import com.eteks.jeks.JeksCodec;
import com.eteks.jeks.JeksExpressionSyntax;
import com.eteks.jeks.JeksFrame;
import com.eteks.jeks.JeksFunctionSyntax;
import com.eteks.jeks.JeksTable;
import com.eteks.parser.CompilationException;
import com.eteks.parser.CompiledFunction;
import com.eteks.tools.awt.SplashScreenWindow;
import com.eteks.tools.swing.HTMLDocumentViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class JeksFrame
extends JFrame {
    private JTable table;
    private JTextField textField;
    private JScrollPane scrollPane;
    private static final String TITLE_BASE = "Jeks";
    private String currentDirectory = System.getProperty("user.dir");
    private File currentFile;
    private boolean tableChanged;
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("com.eteks.jeks.resources.jeks");
    private HTMLDocumentViewer helpViewer;
    private ActionListener newAction = new 1();
    private FileFilter jeksFileFilter = new 2();
    private ActionListener openAction = new 3();
    private ActionListener saveAction = new 4();
    private ActionListener saveAsAction = new 5();
    private ActionListener quitAction = new 6();
    private ActionListener cutAction = new 7();
    private ActionListener copyAction = new 8();
    private ActionListener pasteAction = new 9();
    private ActionListener eraseAction = new 11();
    private ActionListener newFunctionAction = new 12();
    private ActionListener aboutAction = new 13();
    private ActionListener helpAction = new 14();
    private WindowListener windowListener = new 15();
    private TableModelListener changeListener = new 16();

    public JeksFrame() {
        super(TITLE_BASE);
        this.addWindowListener(this.windowListener);
        this.scrollPane = new JScrollPane();
        this.textField = new JTextField();
        this.setTable(new JeksTable());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.textField, "North");
        jPanel.add((Component)this.scrollPane, "Center");
        this.textField.addActionListener(new 17());
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)new JeksToolBar(), "North");
        this.setDefaultCloseOperation(0);
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("mac") >= 0 && string.indexOf("mac os x") < 0) {
            this.setMenuBar(new JeksMenuBar());
        } else {
            this.setJMenuBar(new JeksJMenuBar());
        }
        URL uRL = ClassLoader.getSystemResource("com/eteks/jeks/resources/jeksicon.gif");
        ((Frame)this).setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
        this.pack();
    }

    public JTable getTable() {
        return this.table;
    }

    public void setTable(JTable jTable) {
        this.table = jTable;
        this.scrollPane.setViewportView(jTable);
        18 var2_2 = new 18(jTable);
        JTable jTable2 = new JTable(var2_2);
        19 var4_4 = new 19();
        jTable2.getColumn(jTable2.getColumnName(0)).setCellRenderer(var4_4);
        jTable2.getColumn(jTable2.getColumnName(0)).setPreferredWidth(50);
        var4_4.setText("1");
        jTable2.setPreferredScrollableViewportSize(jTable2.getPreferredSize());
        jTable2.setRowHeight(var4_4.getPreferredSize().height);
        jTable.setRowHeight(var4_4.getPreferredSize().height);
        this.scrollPane.setRowHeaderView(jTable2);
        jTable.setRowSelectionInterval(0, 0);
        jTable.setColumnSelectionInterval(0, 0);
        this.tableChanged = false;
        jTable.getModel().addTableModelListener(this.changeListener);
        20 var5_5 = new 20(jTable, this);
        jTable.getSelectionModel().addListSelectionListener(var5_5);
        jTable.getColumnModel().addColumnModelListener(new 21(var5_5));
    }

    private boolean confirmCloseDocument() {
        if (!this.tableChanged) {
            return true;
        }
        switch (JOptionPane.showConfirmDialog(this, this.resourceBundle.getString("MODIFIED_DOCUMENT_DIALOG_TEXT"), this.resourceBundle.getString("MODIFIED_DOCUMENT_DIALOG_TITLE"), 1)) {
            case 0: {
                this.saveDocument();
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    private void openDocument() {
        if (this.confirmCloseDocument()) {
            JFileChooser jFileChooser = new JFileChooser(this.currentDirectory);
            jFileChooser.setFileFilter(this.jeksFileFilter);
            if (jFileChooser.showOpenDialog(this) == 0) {
                SwingUtilities.invokeLater(new 22(jFileChooser, this));
            }
        }
    }

    private void saveDocument() {
        if (this.currentFile == null) {
            this.saveAsDocument();
        } else {
            SwingUtilities.invokeLater(new 23());
        }
    }

    private void saveAsDocument() {
        JFileChooser jFileChooser = new JFileChooser(this.currentDirectory);
        jFileChooser.setFileFilter(this.jeksFileFilter);
        if (jFileChooser.showSaveDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            this.currentDirectory = file.getParent();
            if (!file.getName().toLowerCase().endsWith(".jks")) {
                file = new File(file.getParent(), String.valueOf(file.getName()) + ".jks");
            }
            this.currentFile = file;
            this.currentDirectory = file.getParent();
            this.saveDocument();
        }
    }

    private void createNewFunction() {
        JTable jTable = this.getTable();
        String string = "";
        CompiledFunction compiledFunction = null;
        if (jTable instanceof JeksTable) {
            while (compiledFunction == null) {
                try {
                    string = (String)JOptionPane.showInputDialog(this, this.resourceBundle.getString("NEW_FUNCTION_DIALOG_TEXT"), this.resourceBundle.getString("NEW_FUNCTION_DIALOG_TITLE"), -1, null, null, string);
                    if (string == null) {
                        return;
                    }
                    compiledFunction = ((JeksTable)jTable).getExpressionParser().getFunctionParser().compileFunction(string);
                    ((JeksTable)jTable).getExpressionParser().addUserFunction(compiledFunction);
                    this.tableChanged = true;
                }
                catch (CompilationException compilationException) {
                    JeksFunctionSyntax jeksFunctionSyntax = (JeksFunctionSyntax)((JeksTable)jTable).getExpressionParser().getFunctionParser().getSyntax();
                    String string2 = jeksFunctionSyntax.getExceptionMessage(compilationException);
                    JOptionPane.showMessageDialog(this, string2, jeksFunctionSyntax.getMessage(JeksFunctionSyntax.MESSAGE_COMPILATION_ERROR_TITLE), 0);
                }
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        URL uRL = ClassLoader.getSystemResource("com/eteks/jeks/resources/jeksscreen.jpg");
        SplashScreenWindow splashScreenWindow = new SplashScreenWindow(Toolkit.getDefaultToolkit().getImage(uRL), 5000L);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading L&F: " + exception);
        }
        JeksFrame jeksFrame = new JeksFrame();
        splashScreenWindow.join();
        ((Component)jeksFrame).setVisible(true);
    }

    static /* synthetic */ String access$15(JeksFrame jeksFrame) {
        return jeksFrame.currentDirectory;
    }

    private static class ToolBarButton
    extends JButton {
        public ToolBarButton(Icon icon) {
            super(icon);
            this.setBorder(new EtchedBorder(1));
        }
    }

    private class JeksToolBar
    extends JToolBar {
        JButton newButton;
        JButton openButton;
        JButton saveButton;
        JButton cutButton;
        JButton copyButton;
        JButton pasteButton;

        public JeksToolBar() {
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/New16.gif"));
            ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Open16.gif"));
            ImageIcon imageIcon3 = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Save16.gif"));
            ImageIcon imageIcon4 = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Cut16.gif"));
            ImageIcon imageIcon5 = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Copy16.gif"));
            ImageIcon imageIcon6 = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Paste16.gif"));
            this.newButton = new ToolBarButton(imageIcon);
            this.openButton = new ToolBarButton(imageIcon2);
            this.saveButton = new ToolBarButton(imageIcon3);
            this.cutButton = new ToolBarButton(imageIcon4);
            this.copyButton = new ToolBarButton(imageIcon5);
            this.pasteButton = new ToolBarButton(imageIcon6);
            this.newButton.addActionListener(JeksFrame.this.newAction);
            this.openButton.addActionListener(JeksFrame.this.openAction);
            this.saveButton.addActionListener(JeksFrame.this.saveAction);
            this.cutButton.addActionListener(JeksFrame.this.cutAction);
            this.copyButton.addActionListener(JeksFrame.this.copyAction);
            this.pasteButton.addActionListener(JeksFrame.this.pasteAction);
            this.add(this.newButton);
            this.add(this.openButton);
            this.add(this.saveButton);
            this.addSeparator();
            this.add(this.cutButton);
            this.add(this.copyButton);
            this.add(this.pasteButton);
            new Properties();
        }
    }

    private class JeksMenuBar
    extends MenuBar {
        MenuItem newMenuItem = new MenuItem();
        MenuItem openMenuItem = new MenuItem();
        MenuItem saveMenuItem = new MenuItem();
        MenuItem saveAsMenuItem = new MenuItem();
        MenuItem quitMenuItem = new MenuItem();
        MenuItem cutMenuItem = new MenuItem();
        MenuItem copyMenuItem = new MenuItem();
        MenuItem pasteMenuItem = new MenuItem();
        MenuItem eraseMenuItem = new MenuItem();
        MenuItem newFunctionMenuItem = new MenuItem();
        MenuItem helpMenuItem = new MenuItem();
        MenuItem aboutMenuItem = new MenuItem();

        public JeksMenuBar() {
            this.loadMenuLabel(this.newMenuItem, "FILE_NEW_MENU");
            this.loadMenuLabel(this.openMenuItem, "FILE_OPEN_MENU");
            this.loadMenuLabel(this.saveMenuItem, "FILE_SAVE_MENU");
            this.loadMenuLabel(this.saveAsMenuItem, "FILE_SAVE_AS_MENU");
            this.loadMenuLabel(this.quitMenuItem, "FILE_QUIT_MENU");
            this.loadMenuLabel(this.cutMenuItem, "EDIT_CUT_MENU");
            this.loadMenuLabel(this.copyMenuItem, "EDIT_COPY_MENU");
            this.loadMenuLabel(this.pasteMenuItem, "EDIT_PASTE_MENU");
            this.loadMenuLabel(this.eraseMenuItem, "EDIT_DELETE_MENU");
            this.loadMenuLabel(this.newFunctionMenuItem, "TOOLS_NEW_FUNCTION_MENU");
            this.loadMenuLabel(this.helpMenuItem, "HELP_HELP_MENU");
            this.loadMenuLabel(this.aboutMenuItem, "HELP_ABOUT_MENU");
            this.newMenuItem.setShortcut(new MenuShortcut(78));
            this.openMenuItem.setShortcut(new MenuShortcut(79));
            this.saveMenuItem.setShortcut(new MenuShortcut(83));
            this.quitMenuItem.setShortcut(new MenuShortcut(81));
            this.cutMenuItem.setShortcut(new MenuShortcut(88));
            this.copyMenuItem.setShortcut(new MenuShortcut(67));
            this.pasteMenuItem.setShortcut(new MenuShortcut(86));
            Menu menu = new Menu();
            this.loadMenuLabel(menu, "FILE_MENU");
            menu.add(this.newMenuItem);
            menu.add(this.openMenuItem);
            menu.addSeparator();
            menu.add(this.saveMenuItem);
            menu.add(this.saveAsMenuItem);
            menu.addSeparator();
            menu.add(this.quitMenuItem);
            Menu menu2 = new Menu();
            this.loadMenuLabel(menu2, "EDIT_MENU");
            menu2.add(this.cutMenuItem);
            menu2.add(this.copyMenuItem);
            menu2.add(this.pasteMenuItem);
            menu2.add(this.eraseMenuItem);
            Menu menu3 = new Menu();
            this.loadMenuLabel(menu3, "TOOLS_MENU");
            menu3.add(this.newFunctionMenuItem);
            Menu menu4 = new Menu();
            this.loadMenuLabel(menu4, "HELP_MENU");
            menu4.add(this.helpMenuItem);
            menu4.add(this.aboutMenuItem);
            this.add(menu);
            this.add(menu2);
            this.add(menu3);
            this.add(menu4);
            this.newMenuItem.addActionListener(JeksFrame.this.newAction);
            this.openMenuItem.addActionListener(JeksFrame.this.openAction);
            this.saveMenuItem.addActionListener(JeksFrame.this.saveAction);
            this.saveAsMenuItem.addActionListener(JeksFrame.this.saveAsAction);
            this.quitMenuItem.addActionListener(JeksFrame.this.quitAction);
            this.cutMenuItem.addActionListener(JeksFrame.this.cutAction);
            this.copyMenuItem.addActionListener(JeksFrame.this.copyAction);
            this.pasteMenuItem.addActionListener(JeksFrame.this.pasteAction);
            this.eraseMenuItem.addActionListener(JeksFrame.this.eraseAction);
            this.newFunctionMenuItem.addActionListener(JeksFrame.this.newFunctionAction);
            this.helpMenuItem.addActionListener(JeksFrame.this.helpAction);
            this.aboutMenuItem.addActionListener(JeksFrame.this.aboutAction);
        }

        private void loadMenuLabel(MenuItem menuItem, String string) {
            String string2 = JeksFrame.this.resourceBundle.getString(string);
            int n = string2.indexOf(38);
            if (n >= 0) {
                menuItem.setLabel(String.valueOf(string2.substring(0, n)) + string2.substring(n + 1));
            } else {
                menuItem.setLabel(string2);
            }
        }
    }

    private class JeksJMenuBar
    extends JMenuBar {
        JMenuItem newMenuItem = new JMenuItem();
        JMenuItem openMenuItem = new JMenuItem();
        JMenuItem saveMenuItem = new JMenuItem();
        JMenuItem saveAsMenuItem = new JMenuItem();
        JMenuItem quitMenuItem = new JMenuItem();
        JMenuItem cutMenuItem = new JMenuItem();
        JMenuItem copyMenuItem = new JMenuItem();
        JMenuItem pasteMenuItem = new JMenuItem();
        JMenuItem eraseMenuItem = new JMenuItem();
        JMenuItem newFunctionMenuItem = new JMenuItem();
        JMenuItem helpMenuItem = new JMenuItem();
        JMenuItem aboutMenuItem = new JMenuItem();

        public JeksJMenuBar() {
            this.loadMenuLabel(this.newMenuItem, "FILE_NEW_MENU");
            this.loadMenuLabel(this.openMenuItem, "FILE_OPEN_MENU");
            this.loadMenuLabel(this.saveMenuItem, "FILE_SAVE_MENU");
            this.loadMenuLabel(this.saveAsMenuItem, "FILE_SAVE_AS_MENU");
            this.loadMenuLabel(this.quitMenuItem, "FILE_QUIT_MENU");
            this.loadMenuLabel(this.cutMenuItem, "EDIT_CUT_MENU");
            this.loadMenuLabel(this.copyMenuItem, "EDIT_COPY_MENU");
            this.loadMenuLabel(this.pasteMenuItem, "EDIT_PASTE_MENU");
            this.loadMenuLabel(this.eraseMenuItem, "EDIT_DELETE_MENU");
            this.loadMenuLabel(this.newFunctionMenuItem, "TOOLS_NEW_FUNCTION_MENU");
            this.loadMenuLabel(this.helpMenuItem, "HELP_HELP_MENU");
            this.loadMenuLabel(this.aboutMenuItem, "HELP_ABOUT_MENU");
            int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, n));
            this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, n));
            this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, n));
            this.quitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, n));
            this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, n));
            this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, n));
            this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, n));
            this.helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
            JMenu jMenu = new JMenu();
            this.loadMenuLabel(jMenu, "FILE_MENU");
            jMenu.add(this.newMenuItem);
            jMenu.add(this.openMenuItem);
            jMenu.addSeparator();
            jMenu.add(this.saveMenuItem);
            jMenu.add(this.saveAsMenuItem);
            jMenu.addSeparator();
            jMenu.add(this.quitMenuItem);
            JMenu jMenu2 = new JMenu();
            this.loadMenuLabel(jMenu2, "EDIT_MENU");
            jMenu2.add(this.cutMenuItem);
            jMenu2.add(this.copyMenuItem);
            jMenu2.add(this.pasteMenuItem);
            jMenu2.add(this.eraseMenuItem);
            JMenu jMenu3 = new JMenu();
            this.loadMenuLabel(jMenu3, "TOOLS_MENU");
            jMenu3.add(this.newFunctionMenuItem);
            JMenu jMenu4 = new JMenu();
            this.loadMenuLabel(jMenu4, "HELP_MENU");
            jMenu4.add(this.helpMenuItem);
            jMenu4.add(this.aboutMenuItem);
            this.add(jMenu);
            this.add(jMenu2);
            this.add(jMenu3);
            this.add(jMenu4);
            this.newMenuItem.addActionListener(JeksFrame.this.newAction);
            this.openMenuItem.addActionListener(JeksFrame.this.openAction);
            this.saveMenuItem.addActionListener(JeksFrame.this.saveAction);
            this.saveAsMenuItem.addActionListener(JeksFrame.this.saveAsAction);
            this.quitMenuItem.addActionListener(JeksFrame.this.quitAction);
            this.cutMenuItem.addActionListener(JeksFrame.this.cutAction);
            this.copyMenuItem.addActionListener(JeksFrame.this.copyAction);
            this.pasteMenuItem.addActionListener(JeksFrame.this.pasteAction);
            this.eraseMenuItem.addActionListener(JeksFrame.this.eraseAction);
            this.newFunctionMenuItem.addActionListener(JeksFrame.this.newFunctionAction);
            this.helpMenuItem.addActionListener(JeksFrame.this.helpAction);
            this.aboutMenuItem.addActionListener(JeksFrame.this.aboutAction);
        }

        private void loadMenuLabel(JMenuItem jMenuItem, String string) {
            String string2 = JeksFrame.this.resourceBundle.getString(string);
            int n = string2.indexOf(38);
            if (n >= 0) {
                jMenuItem.setText(String.valueOf(string2.substring(0, n)) + string2.substring(n + 1));
                jMenuItem.setMnemonic(string2.charAt(n + 1));
            } else {
                jMenuItem.setText(string2);
            }
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (JeksFrame.this.confirmCloseDocument()) {
                JeksFrame.this.setTable(new JeksTable());
                JeksFrame.this.currentFile = null;
                JeksFrame.this.setTitle(TITLE_BASE);
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends FileFilter {
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".jks");
        }

        public String getDescription() {
            return "Jeks spreadsheet (*.jks)";
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JeksFrame.this.openDocument();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JeksFrame.this.saveDocument();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JeksFrame.this.saveAsDocument();
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (JeksFrame.this.confirmCloseDocument()) {
                System.exit(0);
            }
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (JeksFrame.this.table instanceof JeksTable) {
                ((JeksTable)JeksFrame.this.table).cutSelectedCells();
            }
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (JeksFrame.this.table instanceof JeksTable) {
                ((JeksTable)JeksFrame.this.table).copySelectedCells();
            }
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new 10(JeksFrame.this));
        }

        /* synthetic */ 9() {
        }
    }

    private final class 11
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (JeksFrame.this.table instanceof JeksTable) {
                ((JeksTable)JeksFrame.this.table).deleteSelectedCells();
            }
        }

        /* synthetic */ 11() {
        }
    }

    private final class 12
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JeksFrame.this.createNewFunction();
        }

        /* synthetic */ 12() {
        }
    }

    private final class 13
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane.showMessageDialog(JeksFrame.this, JeksFrame.this.resourceBundle.getString("ABOUT_DIALOG_TEXT"), JeksFrame.this.resourceBundle.getString("ABOUT_DIALOG_TITLE"), 1);
        }

        /* synthetic */ 13() {
        }
    }

    private final class 14
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (JeksFrame.this.helpViewer == null) {
                JeksFrame.this.helpViewer = new HTMLDocumentViewer();
                JeksFrame.this.helpViewer.setPage(ClassLoader.getSystemResource(JeksFrame.this.resourceBundle.getString("HELP_FILE")));
                Rectangle rectangle = JeksFrame.this.getBounds();
                rectangle.x += 20;
                rectangle.y += 20;
                ((Component)JeksFrame.this.helpViewer).setBounds(rectangle);
                ((Frame)JeksFrame.this.helpViewer).setIconImage(JeksFrame.this.getIconImage());
            }
            ((Component)JeksFrame.this.helpViewer).setVisible(true);
        }

        /* synthetic */ 14() {
        }
    }

    private final class 15
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            if (JeksFrame.this.confirmCloseDocument()) {
                System.exit(0);
            }
        }

        /* synthetic */ 15() {
        }
    }

    private final class 16
    implements TableModelListener {
        public void tableChanged(TableModelEvent tableModelEvent) {
            JeksFrame.this.tableChanged = true;
            JeksFrame.this.table.getModel().removeTableModelListener(this);
        }

        /* synthetic */ 16() {
        }
    }

    private final class 17
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = JeksFrame.this.getTable();
            String string = JeksFrame.this.textField.getText();
            if (jTable.getCellEditor(0, 0) instanceof JeksCellEditor) {
                int n = jTable.getSelectedRow();
                Object object = ((JeksCellEditor)jTable.getCellEditor(0, 0)).getModelValue(string, jTable.getModel(), new JeksCell(n, jTable.convertColumnIndexToModel(jTable.getSelectedColumn())));
                if (object != null) {
                    jTable.setValueAt(object, jTable.getSelectedRow(), jTable.getSelectedColumn());
                    jTable.setRowSelectionInterval(n + 1, n + 1);
                }
            }
        }

        /* synthetic */ 17() {
        }
    }

    private static final class 18
    extends AbstractTableModel {
        private final /* synthetic */ JTable val$table;

        public int getRowCount() {
            return this.val$table.getRowCount();
        }

        public int getColumnCount() {
            return 1;
        }

        public Object getValueAt(int n, int n2) {
            return this.val$table instanceof JeksTable ? ((JeksExpressionSyntax)((JeksTable)this.val$table).getExpressionParser().getSyntax()).getRowName(n) : String.valueOf(n + 1);
        }

        /* synthetic */ 18(JTable jTable) {
            this.val$table = jTable;
        }
    }

    private final class 19
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setForeground(JeksFrame.this.table.getTableHeader().getForeground());
            this.setBackground(JeksFrame.this.table.getTableHeader().getBackground());
            this.setFont(JeksFrame.this.table.getTableHeader().getFont());
            this.setHorizontalAlignment(0);
            this.setText(object == null ? "" : object.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }

        /* synthetic */ 19() {
        }
    }

    private static final class 20
    implements ListSelectionListener {
        private final /* synthetic */ JeksFrame this$0;
        private final /* synthetic */ JTable val$table;

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = this.val$table.getSelectedRow();
            int n2 = this.val$table.getSelectedColumn();
            Object object = this.val$table.getValueAt(n, n2);
            if (this.val$table instanceof JeksTable) {
                object = ((JeksTable)this.val$table).getExpressionParser().getEditedValue(object);
            }
            this.this$0.textField.setText(object == null ? "" : object.toString());
        }

        /* synthetic */ 20(JTable jTable, JeksFrame jeksFrame) {
            this.val$table = jTable;
            this.this$0 = jeksFrame;
        }
    }

    private static final class 21
    implements TableColumnModelListener {
        private final /* synthetic */ ListSelectionListener val$selectionListener;

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            this.val$selectionListener.valueChanged(listSelectionEvent);
        }

        /* synthetic */ 21(ListSelectionListener listSelectionListener) {
            this.val$selectionListener = listSelectionListener;
        }
    }

    private static final class 22
    implements Runnable {
        private final /* synthetic */ JFileChooser val$chooser;
        private final /* synthetic */ JeksFrame this$0;

        public void run() {
            InputStream inputStream = null;
            try {
                try {
                    this.this$0.setEnabled(false);
                    this.this$0.setCursor(Cursor.getPredefinedCursor(3));
                    this.this$0.currentDirectory = this.val$chooser.getSelectedFile().getParent();
                    inputStream = new FileInputStream(this.val$chooser.getSelectedFile());
                    this.this$0.setTable(new JeksCodec().decode(inputStream));
                    this.this$0.currentFile = this.val$chooser.getSelectedFile();
                    this.this$0.setTitle(String.valueOf(TITLE_BASE) + " - " + this.this$0.currentFile.getName());
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this.this$0, iOException.getMessage(), this.this$0.resourceBundle.getString("FILE_OPEN_MENU"), 0);
                }
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
                this.this$0.setCursor(Cursor.getDefaultCursor());
                this.this$0.setEnabled(true);
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            this.this$0.setCursor(Cursor.getDefaultCursor());
            this.this$0.setEnabled(true);
        }

        /* synthetic */ 22(JFileChooser jFileChooser, JeksFrame jeksFrame) {
            this.val$chooser = jFileChooser;
            this.this$0 = jeksFrame;
        }
    }

    private final class 23
    implements Runnable {
        public void run() {
            OutputStream outputStream = null;
            try {
                try {
                    JeksFrame.this.setEnabled(false);
                    JeksFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                    outputStream = new FileOutputStream(JeksFrame.this.currentFile);
                    JTable jTable = JeksFrame.this.getTable();
                    new JeksCodec().encode(outputStream, jTable);
                    JeksFrame.this.setTitle(String.valueOf(TITLE_BASE) + " - " + JeksFrame.this.currentFile.getName());
                    if (JeksFrame.this.tableChanged) {
                        jTable.getModel().addTableModelListener(JeksFrame.this.changeListener);
                    }
                    JeksFrame.this.tableChanged = false;
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(JeksFrame.this, iOException.getMessage(), JeksFrame.this.resourceBundle.getString("FILE_SAVE_MENU"), 0);
                }
                Object var3_4 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {}
                JeksFrame.this.setCursor(Cursor.getDefaultCursor());
                JeksFrame.this.setEnabled(true);
                throw throwable;
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
            JeksFrame.this.setCursor(Cursor.getDefaultCursor());
            JeksFrame.this.setEnabled(true);
        }

        /* synthetic */ 23() {
        }
    }
}

