/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui.sheet;

import csheets.ui.sheet.WorkbookPane;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.metal.MetalTabbedPaneUI;

public class WorkbookPaneUI
extends MetalTabbedPaneUI {
    protected ActionListener[] buttonListeners;

    public void installUI(JComponent jComponent) {
        this.tabPane = (JTabbedPane)jComponent;
        jComponent.setLayout(this.createLayoutManager());
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
        this.runCount = 1;
        this.selectedRun = 0;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallComponents();
        super.uninstallUI(jComponent);
    }

    protected LayoutManager createLayoutManager() {
        return new SingleRowTabbedLayout(this.tabPane);
    }

    protected void installComponents() {
        JButton[] jButtonArray = ((WorkbookPane)this.tabPane).getButtons();
        for (int i = 0; i < jButtonArray.length; ++i) {
            this.tabPane.add(jButtonArray[i]);
        }
    }

    protected void uninstallComponents() {
        JButton[] jButtonArray = ((WorkbookPane)this.tabPane).getButtons();
        for (int i = 0; i < jButtonArray.length; ++i) {
            this.tabPane.remove(jButtonArray[i]);
        }
    }

    protected void installListeners() {
        super.installListeners();
        WorkbookPane workbookPane = (WorkbookPane)this.tabPane;
        JButton[] jButtonArray = workbookPane.getButtons();
        int n = jButtonArray.length;
        this.buttonListeners = new ActionListener[n];
        for (int i = 0; i < n; ++i) {
            this.buttonListeners[i] = null;
            String string = jButtonArray[i].getActionCommand();
            if (string.equals("First tab")) {
                this.buttonListeners[i] = new TabShifter();
            } else if (string.equals("Previous tab")) {
                this.buttonListeners[i] = new TabShifter(){

                    protected int getStartIndex() {
                        return this.sPane.getVisibleStartIndex() - 1;
                    }
                };
            } else if (string.equals("Next tab")) {
                this.buttonListeners[i] = new TabShifter(){

                    protected int getStartIndex() {
                        return this.sPane.getVisibleStartIndex() + 1;
                    }
                };
            } else if (string.equals("Last tab")) {
                this.buttonListeners[i] = new TabShifter(){

                    protected int getStartIndex() {
                        return this.getStartIndex(this.sPane.getTabCount() - 1);
                    }
                };
            }
            jButtonArray[i].addActionListener(this.buttonListeners[i]);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        JButton[] jButtonArray = ((WorkbookPane)this.tabPane).getButtons();
        for (int i = 0; i < jButtonArray.length; ++i) {
            jButtonArray[i].removeActionListener(this.buttonListeners[i]);
        }
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        WorkbookPane workbookPane = (WorkbookPane)this.tabPane;
        int n3 = workbookPane.getVisibleCount();
        int n4 = workbookPane.getVisibleStartIndex();
        int n5 = 0;
        int n6 = n4;
        while (n5 < n3 && n5 < this.rects.length) {
            if (this.rects[n6].contains(n, n2)) {
                return n6;
            }
            ++n5;
            ++n6;
        }
        return -1;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n = this.tabPane.getSelectedIndex();
        int n2 = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        WorkbookPane workbookPane = (WorkbookPane)this.tabPane;
        int n3 = workbookPane.getVisibleCount();
        int n4 = workbookPane.getVisibleStartIndex();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = graphics.getClipBounds();
        this.tabRuns[0] = n4;
        int n5 = 0;
        int n6 = n4;
        while (n5 < n3 && n5 < this.rects.length) {
            if (this.rects[n6].intersects(rectangle3)) {
                this.paintTab(graphics, n2, this.rects, n6, rectangle, rectangle2);
            }
            ++n5;
            ++n6;
        }
        if (workbookPane.isVisibleTab(n) && this.rects[n].intersects(rectangle3)) {
            this.paintTab(graphics, n2, this.rects, n, rectangle, rectangle2);
        }
        this.paintContentBorder(graphics, n2, n);
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.selectHighlight);
        if (n != 1 || n2 < 0 || this.rects[n2].y + this.rects[n2].height + 1 < n4 || !((WorkbookPane)this.tabPane).isVisibleTab(n2)) {
            graphics.drawLine(n3, n4, n3 + n5 - 2, n4);
        } else {
            Rectangle rectangle = this.rects[n2];
            graphics.drawLine(n3, n4, rectangle.x + 1, n4);
            if (rectangle.x + rectangle.width < n3 + n5 - 2) {
                graphics.drawLine(rectangle.x + rectangle.width, n4, n3 + n5 - 2, n4);
            } else {
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + n5 - 2, n4, n3 + n5 - 2, n4);
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.darkShadow);
        if (n != 3 || n2 < 0 || this.rects[n2].y - 1 > n6 || !((WorkbookPane)this.tabPane).isVisibleTab(n2)) {
            graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
        } else {
            Rectangle rectangle = this.rects[n2];
            graphics.drawLine(n3, n4 + n6 - 1, rectangle.x, n4 + n6 - 1);
            if (rectangle.x + rectangle.width < n3 + n5 - 2) {
                graphics.drawLine(rectangle.x + rectangle.width, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
            }
        }
    }

    protected Insets getTabAreaInsets(int n) {
        WorkbookPane workbookPane = (WorkbookPane)this.tabPane;
        Dimension dimension = workbookPane.getPreferredButtonSize();
        int n2 = 4;
        Insets insets = new Insets(0, 0, 0, 0);
        insets.top = this.tabAreaInsets.bottom;
        insets.bottom = this.tabAreaInsets.top;
        insets.left = this.tabAreaInsets.left + n2 * dimension.width;
        insets.right = this.tabAreaInsets.right;
        return insets;
    }

    protected int lastTabInRun(int n, int n2) {
        WorkbookPane workbookPane = (WorkbookPane)this.tabPane;
        return workbookPane.getVisibleStartIndex() + workbookPane.getVisibleCount() - 1;
    }

    protected void ensureCurrentLayout() {
        SingleRowTabbedLayout singleRowTabbedLayout = (SingleRowTabbedLayout)this.tabPane.getLayout();
        singleRowTabbedLayout.calculateLayoutInfo();
        this.setButtonsEnabled();
    }

    protected void setButtonsEnabled() {
        WorkbookPane workbookPane = (WorkbookPane)this.tabPane;
        int n = workbookPane.getVisibleCount();
        int n2 = workbookPane.getVisibleStartIndex();
        JButton[] jButtonArray = workbookPane.getButtons();
        boolean bl = 0 < n2;
        boolean bl2 = n2 + n < this.tabPane.getTabCount();
        for (int i = 0; i < jButtonArray.length; ++i) {
            boolean bl3 = false;
            String string = jButtonArray[i].getActionCommand();
            if (string.equals("First tab")) {
                bl3 = bl;
            } else if (string.equals("Previous tab")) {
                bl3 = bl;
            } else if (string.equals("Next tab")) {
                bl3 = bl2;
            } else if (string.equals("Last tab")) {
                bl3 = bl2;
            }
            jButtonArray[i].setEnabled(bl3);
        }
    }

    protected void ensureVisibleTabAt(int n) {
        int n2;
        int n3;
        WorkbookPane workbookPane = (WorkbookPane)this.tabPane;
        int n4 = workbookPane.getVisibleCount();
        int n5 = workbookPane.getVisibleStartIndex();
        int n6 = n5 + n4 - 1;
        if (n5 < n && n < n6) {
            return;
        }
        if (n <= n5) {
            if (n5 == 0) {
                return;
            }
            workbookPane.setVisibleStartIndex(--n5);
            ((SingleRowTabbedLayout)this.tabPane.getLayout()).calculateLayoutInfo();
            n3 = workbookPane.getVisibleCount();
            n2 = workbookPane.getVisibleStartIndex();
            if (n2 > n || n > n2 + n3 - 1) {
                workbookPane.setVisibleStartIndex(++n5);
            }
        }
        if (n6 <= n) {
            if (n5 == n4 + 1) {
                return;
            }
            workbookPane.setVisibleStartIndex(++n5);
            ((SingleRowTabbedLayout)this.tabPane.getLayout()).calculateLayoutInfo();
            n3 = workbookPane.getVisibleCount();
            n2 = workbookPane.getVisibleStartIndex();
            if (n2 > n || n > n2 + n3 - 1) {
                workbookPane.setVisibleStartIndex(--n5);
            }
        }
    }

    protected void selectNextTab(int n) {
        for (int i = n + 1; i < this.tabPane.getTabCount(); ++i) {
            if (!this.tabPane.isEnabledAt(i)) continue;
            this.ensureVisibleTabAt(i);
            this.tabPane.setSelectedIndex(i);
            break;
        }
    }

    protected void selectPreviousTab(int n) {
        for (int i = n - 1; 0 <= i; --i) {
            if (!this.tabPane.isEnabledAt(i)) continue;
            this.ensureVisibleTabAt(i);
            this.tabPane.setSelectedIndex(i);
            break;
        }
    }

    void setMaxTabHeight(int n) {
        this.maxTabHeight = n;
    }

    int getMaxTabHeight() {
        return this.maxTabHeight;
    }

    Rectangle[] getRects() {
        return this.rects;
    }

    WorkbookPane getTabbedPane() {
        return (WorkbookPane)this.tabPane;
    }

    protected FontMetrics getFontMetrics() {
        Font font = this.tabPane.getFont();
        return this.tabPane.getFontMetrics(font);
    }

    protected int calculateMaxTabHeight(int n) {
        return super.calculateMaxTabHeight(n);
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        return super.calculateTabWidth(n, n2, fontMetrics);
    }

    protected void assureRectsCreated(int n) {
        super.assureRectsCreated(n);
    }

    protected class NavigateAction
    extends AbstractAction {
        private int direction;

        public NavigateAction(int n) {
            if (n != 13 && n != 12) {
                throw new IllegalArgumentException("A SwingConstants value expected");
            }
            this.direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WorkbookPaneUI.this.navigateSelectedTab(this.direction);
        }
    }

    protected class TabShifter
    implements ActionListener {
        WorkbookPane sPane;

        protected TabShifter() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.sPane = WorkbookPaneUI.this.getTabbedPane();
            int n = this.getStartIndex();
            this.sPane.setVisibleStartIndex(n);
            this.sPane.repaint();
        }

        protected int getStartIndex() {
            return 0;
        }

        protected int getStartIndex(int n) {
            int n2;
            Insets insets = this.sPane.getInsets();
            Insets insets2 = WorkbookPaneUI.this.getTabAreaInsets(this.sPane.getTabPlacement());
            int n3 = this.sPane.getSize().width - (insets.left + insets.right) - (insets2.left + insets2.right);
            Rectangle[] rectangleArray = WorkbookPaneUI.this.getRects();
            for (n2 = n; 0 <= n2 && (n3 -= rectangleArray[n2].width) >= 0; --n2) {
            }
            return ++n2;
        }
    }

    protected class SingleRowTabbedLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        JTabbedPane tabPane;

        public SingleRowTabbedLayout(JTabbedPane jTabbedPane) {
            super(WorkbookPaneUI.this);
            this.tabPane = jTabbedPane;
        }

        public void layoutContainer(Container container) {
            super.layoutContainer(container);
            if (this.tabPane.getComponentCount() < 1) {
                return;
            }
            int n = this.tabPane.getTabPlacement();
            int n2 = WorkbookPaneUI.this.calculateMaxTabHeight(n);
            Insets insets = WorkbookPaneUI.this.getTabAreaInsets(n);
            Insets insets2 = this.tabPane.getInsets();
            Rectangle rectangle = this.tabPane.getBounds();
            WorkbookPane workbookPane = (WorkbookPane)this.tabPane;
            Dimension dimension = workbookPane.getPreferredButtonSize();
            JButton[] jButtonArray = workbookPane.getButtons();
            int n3 = rectangle.y + rectangle.height - insets2.bottom - insets.bottom - n2;
            int n4 = rectangle.x + insets2.left;
            for (int i = 0; i < jButtonArray.length; ++i) {
                jButtonArray[i].setBounds(n4, n3, dimension.width, dimension.height);
                n4 += dimension.width;
            }
        }

        public void calculateLayoutInfo() {
            int n = this.tabPane.getTabCount();
            WorkbookPaneUI.this.assureRectsCreated(n);
            this.calculateTabWidths(this.tabPane.getTabPlacement(), n);
            this.calculateTabRects(this.tabPane.getTabPlacement(), n);
        }

        protected void calculateTabWidths(int n, int n2) {
            if (n2 == 0) {
                return;
            }
            FontMetrics fontMetrics = WorkbookPaneUI.this.getFontMetrics();
            int n3 = WorkbookPaneUI.this.calculateMaxTabHeight(n);
            WorkbookPaneUI.this.setMaxTabHeight(n3);
            Rectangle[] rectangleArray = WorkbookPaneUI.this.getRects();
            for (int i = 0; i < n2; ++i) {
                rectangleArray[i].width = WorkbookPaneUI.this.calculateTabWidth(n, i, fontMetrics);
                rectangleArray[i].height = n3;
            }
        }

        protected void calculateTabRects(int n, int n2) {
            if (n2 == 0) {
                return;
            }
            WorkbookPane workbookPane = (WorkbookPane)this.tabPane;
            Dimension dimension = this.tabPane.getSize();
            Insets insets = this.tabPane.getInsets();
            Insets insets2 = WorkbookPaneUI.this.getTabAreaInsets(n);
            int n3 = WorkbookPaneUI.this.getMaxTabHeight();
            int n4 = insets.left + insets2.left;
            int n5 = n == 1 ? insets.top + insets2.top : dimension.height - insets.bottom - insets2.bottom - n3;
            int n6 = dimension.width - (insets.right + insets2.right);
            Rectangle[] rectangleArray = WorkbookPaneUI.this.getRects();
            int n7 = workbookPane.getVisibleStartIndex();
            int n8 = 0;
            for (int i = n7; i < n2; ++i) {
                Rectangle rectangle = rectangleArray[i];
                rectangle.x = n7 < i ? rectangleArray[i - 1].x + rectangleArray[i - 1].width : n4;
                if (rectangle.x + rectangle.width > n6) break;
                ++n8;
                rectangle.y = n5;
            }
            workbookPane.setVisibleCount(n8);
            workbookPane.setVisibleStartIndex(n7);
        }
    }
}

