/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui.sheet;

import csheets.core.Cell;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;

public class CellTransferable
implements Transferable,
ClipboardOwner {
    public static final DataFlavor LOCAL_CELL_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref;class=" + Cell.class.getName(), "CleanSheets Cell Range (Local)");
    public static final DataFlavor SERIAL_CELL_FLAVOR = new DataFlavor(Cell.class, "CleanSheets Cell Range (Serialized)");
    private Cell[][] cells;

    public CellTransferable(Cell[][] cellArray) {
        this.cells = cellArray;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (LOCAL_CELL_FLAVOR.equals(dataFlavor)) {
            return this.cells;
        }
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            String string = "";
            for (Cell[] cellArray : this.cells) {
                for (int i = 0; i < cellArray.length; ++i) {
                    string = string + cellArray[i].getValue().toString();
                    if (i == cellArray.length - 1) continue;
                    string = string + "\t";
                }
                string = string + "\n";
            }
            return string;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{LOCAL_CELL_FLAVOR, DataFlavor.stringFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return LOCAL_CELL_FLAVOR.equals(dataFlavor) || DataFlavor.stringFlavor.equals(dataFlavor);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

