/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui.sheet;

import antlr.TokenStreamRecognitionException;
import csheets.core.Address;
import csheets.core.Cell;
import csheets.core.formula.compiler.FormulaCompilationException;
import csheets.core.formula.lang.UnknownElementException;
import csheets.ui.ctrl.SelectionEvent;
import csheets.ui.ctrl.SelectionListener;
import csheets.ui.ctrl.UIController;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class CellEditor
extends JTextField
implements TableCellEditor,
SelectionListener {
    public static final int CLICK_COUNT_TO_START = 2;
    public static final String CANCEL_COMMAND = "Cancel editing";
    private static Document document = new PlainDocument();
    private Cell cell;
    private boolean resumeOnNextEdit = false;
    private ChangeEvent changeEvent = new ChangeEvent(this);
    private UIController uiController;

    public CellEditor(UIController uIController) {
        this.uiController = uIController;
        uIController.addSelectionListener(this);
        this.setDocument(document);
        this.setAction(new StopAction(0, 1));
        this.getActionMap().put(CANCEL_COMMAND, new CancelAction());
        this.getActionMap().put("Stop and move up", new StopAction(0, -1));
        this.getActionMap().put("Stop and move down", new StopAction(0, 1));
        this.getActionMap().put("Stop and move left", new StopAction(-1, 0));
        this.getActionMap().put("Stop and move right", new StopAction(1, 0));
        this.getInputMap().put(KeyStroke.getKeyStroke(27, 0), CANCEL_COMMAND);
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "Stop and move up");
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "Stop and move down");
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 1), "Stop and move left");
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "Stop and move right");
    }

    public boolean stopCellEditing() {
        String string = this.getText();
        if (this.cell != null && string != null) {
            if (string.equals(this.cell.getContent())) {
                this.cancelCellEditing();
                return false;
            }
            try {
                this.cell.setContent(string);
            }
            catch (FormulaCompilationException formulaCompilationException) {
                String string2 = formulaCompilationException.getCause() instanceof TokenStreamRecognitionException ? "The parser responded: " + ((TokenStreamRecognitionException)formulaCompilationException.getCause()).recog.getMessage() : (formulaCompilationException instanceof UnknownElementException ? "The parser recognized the formula, but a language element (" + ((UnknownElementException)formulaCompilationException).getIdentifier() + ") could not be created." : formulaCompilationException.getMessage());
                Container container = SwingUtilities.getWindowAncestor(this);
                if (container == null) {
                    container = this;
                }
                JOptionPane.showMessageDialog(container, "The entered formula could not be compiled\n" + string2, "Formula compilation error", 0);
                return false;
            }
        }
        this.fireEditingStopped();
        return true;
    }

    public Cell getCellEditorValue() {
        return this.cell;
    }

    public boolean isCellEditable(EventObject eventObject) {
        boolean bl = this.resumeOnNextEdit = eventObject instanceof MouseEvent || eventObject instanceof ActionEvent && ((ActionEvent)eventObject).getActionCommand().equals("Edit active cell");
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= 2;
        }
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (object != null && object instanceof Cell) {
            this.cell = (Cell)object;
            if (this.resumeOnNextEdit) {
                this.setText(((Cell)object).getContent());
            } else {
                this.setText("");
            }
        }
        return this;
    }

    public void selectionChanged(SelectionEvent selectionEvent) {
        this.cell = selectionEvent.getCell();
        if (this.cell != null) {
            this.setText(this.cell.getContent());
        } else {
            this.setText("");
        }
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(CellEditorListener.class, cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    public CellEditorListener[] getCellEditorListeners() {
        return (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class);
    }

    private void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            ((CellEditorListener)objectArray[i + 1]).editingStopped(this.changeEvent);
        }
    }

    private void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            ((CellEditorListener)objectArray[i + 1]).editingCanceled(this.changeEvent);
        }
    }

    protected class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", CellEditor.CANCEL_COMMAND);
            this.putValue("ShortDescription", CellEditor.CANCEL_COMMAND);
            this.putValue("ActionCommandKey", CellEditor.CANCEL_COMMAND);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CellEditor.this.cancelCellEditing();
        }
    }

    protected class StopAction
    extends AbstractAction {
        private int columns = 0;
        private int rows = 0;

        public StopAction(int n, int n2) {
            this.columns = n;
            this.rows = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (CellEditor.this.stopCellEditing() && CellEditor.this.cell != null) {
                CellEditor.this.transferFocus();
                int n = CellEditor.this.cell.getAddress().getColumn() + this.columns;
                int n2 = CellEditor.this.cell.getAddress().getRow() + this.rows;
                if (n >= 0 && n2 >= 0) {
                    Address address = new Address(n, n2);
                    Cell cell = CellEditor.this.uiController.getActiveSpreadsheet().getCell(address);
                    CellEditor.this.uiController.setActiveCell(cell);
                }
            }
        }
    }
}

