/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui.ctrl;

import csheets.CleanSheets;
import csheets.core.Workbook;
import csheets.ui.FileChooser;
import csheets.ui.ctrl.BaseAction;
import csheets.ui.ctrl.UIController;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class SaveAsAction
extends BaseAction {
    protected CleanSheets app;
    protected UIController uiController;
    protected FileChooser chooser;

    public SaveAsAction(CleanSheets cleanSheets, UIController uIController, FileChooser fileChooser) {
        this.app = cleanSheets;
        this.uiController = uIController;
        this.chooser = fileChooser;
    }

    protected String getName() {
        return "Save As...";
    }

    protected void defineProperties() {
        this.putValue("MnemonicKey", 65);
        this.putValue("SmallIcon", new ImageIcon(CleanSheets.class.getResource("res/img/save_as.gif")));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Workbook workbook = this.uiController.getActiveWorkbook();
        File file = this.app.getFile(workbook);
        File file2 = null;
        boolean bl = true;
        while (bl) {
            file2 = this.chooser.getFileToSave();
            if (file2 != null) {
                if (file2.exists() && (file == null || !file2.equals(file))) {
                    int n = JOptionPane.showConfirmDialog(null, "The chosen file " + file2 + " already exists\n" + "Do you want to overwrite it?", "Replace existing file?", 1, 2);
                    if (n == 0) {
                        bl = false;
                        continue;
                    }
                    if (n != 2 && n != -1) continue;
                    return;
                }
                bl = false;
                continue;
            }
            return;
        }
        try {
            this.app.saveAs(workbook, file2);
        }
        catch (IOException iOException) {
            this.showErrorDialog("An I/O error occurred when saving the file.");
            return;
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(this.chooser == null ? false : bl);
    }

    protected boolean requiresFile() {
        return true;
    }
}

