/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui.ctrl;

import csheets.CleanSheets;
import csheets.core.Workbook;
import csheets.ui.FileChooser;
import csheets.ui.ctrl.SaveAsAction;
import csheets.ui.ctrl.UIController;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class SaveAction
extends SaveAsAction {
    public SaveAction(CleanSheets cleanSheets, UIController uIController, FileChooser fileChooser) {
        super(cleanSheets, uIController, fileChooser);
    }

    protected String getName() {
        return "Save";
    }

    protected void defineProperties() {
        this.putValue("MnemonicKey", 83);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
        this.putValue("SmallIcon", new ImageIcon(CleanSheets.class.getResource("res/img/save.gif")));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Workbook workbook = this.uiController.getActiveWorkbook();
        if (this.app.isWorkbookStored(workbook)) {
            try {
                this.app.save(workbook);
            }
            catch (IOException iOException) {
                this.showErrorDialog("An I/O error occurred when saving the file.");
                return;
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected boolean requiresModification() {
        return true;
    }

    protected boolean requiresFile() {
        return false;
    }
}

