/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui;

import csheets.CleanSheets;
import csheets.SpreadsheetAppEvent;
import csheets.SpreadsheetAppListener;
import csheets.core.Workbook;
import csheets.ui.ctrl.SelectionEvent;
import csheets.ui.ctrl.SelectionListener;
import csheets.ui.ctrl.UIController;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.KeyStroke;

public class WindowMenu
extends JMenu
implements SelectionListener,
SpreadsheetAppListener {
    private UIController uiController;
    private Map<Workbook, JCheckBoxMenuItem> items = new HashMap<Workbook, JCheckBoxMenuItem>();
    private ButtonGroup group = new ButtonGroup();
    private int nonWorkbookItems;

    public WindowMenu(CleanSheets cleanSheets, UIController uIController) {
        super("Window");
        this.uiController = uIController;
        cleanSheets.addSpreadsheetAppListener(this);
        uIController.addSelectionListener(this);
        this.setMnemonic(87);
    }

    public void workbookCreated(SpreadsheetAppEvent spreadsheetAppEvent) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new SelectWorkbookAction(spreadsheetAppEvent.getWorkbook(), this.uiController));
        int n = this.getItemCount() - this.nonWorkbookItems + 1;
        File file = spreadsheetAppEvent.getFile();
        jCheckBoxMenuItem.setText(file == null ? " Untitled" : file.getName());
        KeyStroke keyStroke = KeyStroke.getKeyStroke("ctrl " + n);
        jCheckBoxMenuItem.setMnemonic(keyStroke.getKeyChar());
        jCheckBoxMenuItem.setAccelerator(keyStroke);
        jCheckBoxMenuItem.setSelected(true);
        this.items.put(spreadsheetAppEvent.getWorkbook(), jCheckBoxMenuItem);
        this.group.add(jCheckBoxMenuItem);
        this.add(jCheckBoxMenuItem);
    }

    public void workbookLoaded(SpreadsheetAppEvent spreadsheetAppEvent) {
        this.workbookCreated(spreadsheetAppEvent);
    }

    public void workbookUnloaded(SpreadsheetAppEvent spreadsheetAppEvent) {
        JCheckBoxMenuItem jCheckBoxMenuItem = this.items.remove(spreadsheetAppEvent.getWorkbook());
        if (jCheckBoxMenuItem != null) {
            this.remove(jCheckBoxMenuItem);
        }
        int n = 1;
        for (Component component : this.getMenuComponents()) {
            jCheckBoxMenuItem = (JCheckBoxMenuItem)component;
            KeyStroke keyStroke = KeyStroke.getKeyStroke("ctrl " + n++);
            jCheckBoxMenuItem.setMnemonic(keyStroke.getKeyChar());
            jCheckBoxMenuItem.setAccelerator(keyStroke);
        }
    }

    public void workbookSaved(SpreadsheetAppEvent spreadsheetAppEvent) {
        this.items.get(spreadsheetAppEvent.getWorkbook()).setText(spreadsheetAppEvent.getFile().getName());
    }

    public void selectionChanged(SelectionEvent selectionEvent) {
        JCheckBoxMenuItem jCheckBoxMenuItem = this.items.get(selectionEvent.getWorkbook());
        if (jCheckBoxMenuItem != null) {
            jCheckBoxMenuItem.setSelected(true);
        }
    }

    protected static class SelectWorkbookAction
    extends AbstractAction {
        private Workbook workbook;
        private UIController uiController;

        public SelectWorkbookAction(Workbook workbook, UIController uIController) {
            this.workbook = workbook;
            this.uiController = uIController;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.uiController.setActiveWorkbook(this.workbook);
        }
    }
}

