/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.test.ui;

import csheets.core.Cell;
import csheets.core.Value;
import csheets.ext.test.TestCase;
import csheets.ext.test.TestCaseParam;
import csheets.ext.test.TestableCell;
import csheets.ext.test.TestableCellListener;
import csheets.ext.test.ui.TestCaseTable;
import csheets.ui.ctrl.SelectionEvent;
import csheets.ui.ctrl.SelectionListener;
import csheets.ui.ctrl.UIController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class TestCasePanel
extends JPanel
implements SelectionListener,
TestableCellListener {
    public static final String[] columnNames = new String[]{"Formula", "Result", "Validation state"};
    private DefaultTableModel tableModel = new DefaultTableModel(columnNames, 0);
    private TestCaseTable table = new TestCaseTable(this.tableModel);
    private boolean listening = true;

    public TestCasePanel(UIController uIController) {
        this.tableModel.addTableModelListener(new ValidationStateChanger(uIController));
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.add((Component)jScrollPane, "Center");
    }

    public void selectionChanged(SelectionEvent selectionEvent) {
        Cell cell = selectionEvent.getCell();
        if (cell != null) {
            TestableCell testableCell = (TestableCell)cell.getExtension("Test Cases");
            testableCell.addTestableCellListener(this);
            this.testCasesChanged(testableCell);
        } else {
            this.tableModel.setRowCount(0);
        }
        if (selectionEvent.getPreviousCell() != null) {
            ((TestableCell)selectionEvent.getPreviousCell().getExtension("Test Cases")).removeTestableCellListener(this);
        }
    }

    public void testCasesChanged(TestableCell testableCell) {
        this.tableModel.setRowCount(0);
        if (testableCell.hasTestCases()) {
            Set<TestCase> set = testableCell.getTestCases();
            this.tableModel.setRowCount(set.size());
            int n = 0;
            this.listening = false;
            for (TestCase testCase : set) {
                this.tableModel.setValueAt(testCase, n, 0);
                this.tableModel.setValueAt(testCase.evaluate(), n, 1);
                this.tableModel.setValueAt((Object)testCase.getValidationState(), n++, 2);
            }
            this.listening = true;
        }
        this.table.packColumns();
    }

    public void testCaseParametersChanged(TestableCell testableCell) {
    }

    protected class ValidationStateChanger
    implements TableModelListener {
        private UIController uiController;

        public ValidationStateChanger(UIController uIController) {
            this.uiController = uIController;
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (TestCasePanel.this.listening && tableModelEvent.getType() == 0 && tableModelEvent.getFirstRow() >= 0) {
                TestCasePanel.this.listening = false;
                TestCase testCase = (TestCase)TestCasePanel.this.tableModel.getValueAt(tableModelEvent.getFirstRow(), 0);
                TestCase.ValidationState validationState = (TestCase.ValidationState)((Object)TestCasePanel.this.tableModel.getValueAt(tableModelEvent.getFirstRow(), 2));
                if (validationState != testCase.getValidationState()) {
                    testCase.setValidationState(validationState);
                    TestableCell testableCell = testCase.getCell();
                    Value value = testCase.evaluate();
                    switch (validationState) {
                        case VALID: {
                            testableCell.addTestCaseParam(testCase.evaluate(), TestCaseParam.Type.DERIVED);
                            break;
                        }
                        case PENDING: 
                        case REJECTED: {
                            TestCaseParam testCaseParam = null;
                            for (TestCaseParam testCaseParam2 : testableCell.getTestCaseParams()) {
                                if (!value.equals(testCaseParam2.getValue())) continue;
                                testCaseParam = testCaseParam2;
                            }
                            if (testCaseParam == null) break;
                            testableCell.removeTestCaseParam(testCaseParam, TestCaseParam.Type.DERIVED);
                        }
                    }
                    this.uiController.setWorkbookModified(testableCell.getSpreadsheet().getWorkbook());
                }
                TestCasePanel.this.listening = true;
            }
        }
    }
}

