/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.test;

import csheets.core.Value;
import csheets.core.formula.Literal;
import csheets.ext.test.TestableCell;
import java.io.Serializable;

public class TestCaseParam
extends Literal
implements Serializable {
    private static final long serialVersionUID = -6821036933997460416L;
    private TestableCell cell;
    private int userEntered = 0;
    private int systemGenerated = 0;
    private int derived = 0;

    public TestCaseParam(TestableCell testableCell, Value value, Type type) {
        super(value);
        this.cell = testableCell;
        switch (type) {
            case USER_ENTERED: {
                ++this.userEntered;
                break;
            }
            case SYSTEM_GENERATED: {
                ++this.systemGenerated;
                break;
            }
            case DERIVED: {
                ++this.derived;
            }
        }
    }

    public TestableCell getCell() {
        return this.cell;
    }

    public boolean hasType(Type type) {
        switch (type) {
            case USER_ENTERED: {
                return this.userEntered > 0;
            }
            case SYSTEM_GENERATED: {
                return this.systemGenerated > 0;
            }
            case DERIVED: {
                return this.derived > 0;
            }
        }
        return false;
    }

    public void setType(Type type, boolean bl) {
        switch (type) {
            case USER_ENTERED: {
                if (bl) {
                    ++this.userEntered;
                    break;
                }
                --this.userEntered;
                break;
            }
            case SYSTEM_GENERATED: {
                if (bl) {
                    ++this.systemGenerated;
                    break;
                }
                --this.systemGenerated;
                break;
            }
            case DERIVED: {
                if (bl) {
                    ++this.derived;
                    break;
                }
                --this.derived;
            }
        }
    }

    public boolean hasNoType() {
        return this.userEntered <= 0 && this.systemGenerated <= 0 && this.derived <= 0;
    }

    public boolean isUserEntered() {
        return this.userEntered > 0;
    }

    public boolean isSystemGenerated() {
        return this.systemGenerated > 0;
    }

    public boolean isDerived() {
        return this.derived > 0;
    }

    public String toString2() {
        String string = this.toString();
        if (this.userEntered > 0) {
            string = string + " user entered";
        }
        if (this.systemGenerated > 0) {
            string = string + " system generated";
        }
        if (this.derived > 0) {
            string = string + " derived";
        }
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TestCaseParam) || object == null) {
            return false;
        }
        TestCaseParam testCaseParam = (TestCaseParam)object;
        return this.getValue().equals(testCaseParam.getValue());
    }

    public int hashCode() {
        return this.cell.hashCode() + this.getValue().hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        USER_ENTERED,
        SYSTEM_GENERATED,
        DERIVED;

    }
}

