/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.style.ui;

import csheets.core.Cell;
import csheets.core.IllegalValueTypeException;
import csheets.core.Value;
import csheets.ext.style.StylableCell;
import csheets.ext.style.StyleExtension;
import csheets.ext.style.ui.FormatChooser;
import csheets.ui.ctrl.FocusOwnerAction;
import csheets.ui.ctrl.SelectionEvent;
import csheets.ui.ctrl.SelectionListener;
import csheets.ui.ctrl.UIController;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import javax.swing.ImageIcon;

public class FormatAction
extends FocusOwnerAction
implements SelectionListener {
    private UIController uiController;
    private StylableCell cell;

    public FormatAction(UIController uIController) {
        this.uiController = uIController;
        uIController.addSelectionListener(this);
    }

    protected String getName() {
        return "Format...";
    }

    protected void defineProperties() {
        this.putValue("MnemonicKey", 68);
        this.putValue("SmallIcon", new ImageIcon(StyleExtension.class.getResource("res/img/format.gif")));
    }

    public void selectionChanged(SelectionEvent selectionEvent) {
        Cell cell = selectionEvent.getCell();
        this.cell = cell == null ? null : (StylableCell)cell.getExtension("Style");
        this.setEnabled(cell == null ? false : this.cell.isFormattable());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.focusOwner == null) {
            return;
        }
        Format format = null;
        try {
            if (this.cell.getValue().getType() == Value.Type.NUMERIC) {
                format = new FormatChooser((NumberFormat)this.cell.getFormat().clone(), this.cell.getValue().toNumber()).showDialog(null, "Choose Format");
            } else if (this.cell.getValue().getType() == Value.Type.DATE) {
                format = new FormatChooser((DateFormat)this.cell.getFormat().clone(), this.cell.getValue().toDate()).showDialog(null, "Choose Format");
            }
        }
        catch (IllegalValueTypeException illegalValueTypeException) {
            // empty catch block
        }
        if (format != null) {
            Cell[][] cellArray = this.focusOwner.getSelectedCells();
            int n = cellArray.length;
            for (int i = 0; i < n; ++i) {
                Cell[] cellArray2;
                for (Cell cell : cellArray2 = cellArray[i]) {
                    StylableCell stylableCell;
                    stylableCell.setFormat((stylableCell = (StylableCell)cell.getExtension("Style")).isFormattable() ? format : null);
                }
            }
            this.uiController.setWorkbookModified(this.focusOwner.getSpreadsheet().getWorkbook());
            this.focusOwner.repaint();
        }
    }
}

