/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.assertion;

import antlr.MismatchedCharException;
import antlr.MismatchedTokenException;
import antlr.NoViableAltException;
import antlr.NoViableAltForCharException;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.TokenStreamException;
import csheets.ext.assertion.Assertion;
import csheets.ext.assertion.AssertionException;
import csheets.ext.assertion.AssertionLexer;
import csheets.ext.assertion.AssertionParser;
import csheets.ext.assertion.AssertionWarning;
import csheets.ext.assertion.Interval;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class USAssertion
extends Assertion {
    private static final long serialVersionUID = -7911803174007268562L;
    protected String assertion;
    private List<AssertionWarning> warnings = new Vector<AssertionWarning>();

    public USAssertion(String string) throws AssertionException {
        Interval interval;
        ListIterator listIterator;
        Interval interval22;
        Vector<Interval> vector = new Vector<Interval>();
        Vector<Interval> vector2 = new Vector<Interval>();
        AssertionLexer assertionLexer = new AssertionLexer(new StringReader(string));
        AssertionParser assertionParser = new AssertionParser(assertionLexer);
        try {
            assertionParser.assertion(this, vector, vector2);
        }
        catch (MismatchedCharException mismatchedCharException) {
            throw new AssertionException(mismatchedCharException);
        }
        catch (MismatchedTokenException mismatchedTokenException) {
            throw new AssertionException(mismatchedTokenException);
        }
        catch (NoViableAltException noViableAltException) {
            throw new AssertionException(noViableAltException);
        }
        catch (NoViableAltForCharException noViableAltForCharException) {
            throw new AssertionException(noViableAltForCharException);
        }
        catch (SemanticException semanticException) {
            throw new AssertionException(semanticException);
        }
        catch (RecognitionException recognitionException) {
            throw new AssertionException(recognitionException);
        }
        catch (TokenStreamException tokenStreamException) {
            throw new AssertionException(tokenStreamException);
        }
        this.assertion = string;
        Iterator iterator = vector.listIterator();
        while (iterator.hasNext()) {
            interval22 = (Interval)iterator.next();
            listIterator = vector.listIterator(iterator.nextIndex());
            while (listIterator.hasNext()) {
                interval = (Interval)listIterator.next();
                if (!interval22.intersects(interval)) continue;
                if (interval22.encloses(interval)) {
                    this.warnings.add(new AssertionWarning(AssertionWarning.Type.ENCLOSING, interval, interval22));
                    continue;
                }
                if (interval.encloses(interval22)) {
                    this.warnings.add(new AssertionWarning(AssertionWarning.Type.ENCLOSING, interval22, interval));
                    continue;
                }
                this.warnings.add(new AssertionWarning(AssertionWarning.Type.INTERSECTING, interval22, interval));
            }
        }
        iterator = vector2.listIterator();
        while (iterator.hasNext()) {
            interval22 = (Interval)iterator.next();
            listIterator = vector2.listIterator(iterator.nextIndex());
            while (listIterator.hasNext()) {
                interval = (Interval)listIterator.next();
                if (!interval22.intersects(interval)) continue;
                if (interval22.encloses(interval)) {
                    this.warnings.add(new AssertionWarning(AssertionWarning.Type.ENCLOSING, interval, interval22));
                    continue;
                }
                if (interval.encloses(interval22)) {
                    this.warnings.add(new AssertionWarning(AssertionWarning.Type.ENCLOSING, interval22, interval));
                    continue;
                }
                this.warnings.add(new AssertionWarning(AssertionWarning.Type.INTERSECTING, interval22, interval));
            }
        }
        iterator = vector2.listIterator();
        while (iterator.hasNext()) {
            interval22 = (Interval)iterator.next();
            listIterator = vector.listIterator();
            while (listIterator.hasNext()) {
                interval = (Interval)listIterator.next();
                if (!interval22.encloses(interval)) continue;
                this.warnings.add(new AssertionWarning(AssertionWarning.Type.EXCLUDING, interval22, interval));
            }
        }
        for (Interval interval22 : vector) {
            this.intervals.include(interval22);
        }
        for (Interval interval22 : vector2) {
            this.intervals.exclude(interval22);
        }
        if (this.isInteger && vector.isEmpty() && vector2.isEmpty()) {
            this.intervals.include(new Interval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, false, false));
        }
    }

    public boolean isConsistent() {
        return this.warnings.isEmpty();
    }

    public List<AssertionWarning> getWarnings() {
        return this.warnings;
    }

    @Override
    public String toString() {
        return this.assertion;
    }

    public String prettyString() {
        return super.toString();
    }

    public void printWarnings() {
        List<AssertionWarning> list = this.getWarnings();
        Iterator<AssertionWarning> iterator = list.iterator();
        System.out.println("\nWarnings for: " + this.toString());
        while (iterator.hasNext()) {
            AssertionWarning assertionWarning = iterator.next();
            System.out.println(assertionWarning.toString());
        }
    }
}

