/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.assertion;

import csheets.ext.assertion.MathException;
import java.io.Serializable;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interval
implements Comparable<Interval>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -1176661760834511074L;
    private double lowerLimit;
    private double upperLimit;
    private boolean lowerLimitClosed;
    private boolean upperLimitClosed;

    public Interval(double d, double d2, boolean bl, boolean bl2) throws IllegalArgumentException {
        if (d > d2) {
            throw new IllegalArgumentException("Lower limit of interval must not be larger than upper limit");
        }
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("An interval limit must not be NaN");
        }
        if (Double.isInfinite(d) && bl || Double.isInfinite(d2) && bl2) {
            throw new IllegalArgumentException("A limit that is infinite cannot be closed");
        }
        this.lowerLimit = d;
        this.upperLimit = d2;
        this.lowerLimitClosed = bl;
        this.upperLimitClosed = bl2;
    }

    public Interval(double d) throws IllegalArgumentException {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("An interval limit must not be NaN");
        }
        if (Double.isInfinite(d)) {
            throw new IllegalArgumentException("A single value interval must not be infinity");
        }
        this.lowerLimit = this.upperLimit = d;
        this.upperLimitClosed = true;
        this.lowerLimitClosed = true;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public boolean isLowerLimitClosed() {
        return this.lowerLimitClosed;
    }

    public boolean isUpperLimitClosed() {
        return this.upperLimitClosed;
    }

    public boolean contains(double d) {
        return d > this.lowerLimit && d < this.upperLimit || this.lowerLimitClosed && d == this.lowerLimit || this.upperLimitClosed && d == this.upperLimit;
    }

    public boolean intersects(Interval interval) {
        if (interval == null) {
            return false;
        }
        if (interval == this) {
            return true;
        }
        if (this.equals(interval)) {
            return true;
        }
        if (!(this.upperLimit != interval.lowerLimit || this.upperLimitClosed && interval.lowerLimitClosed)) {
            return false;
        }
        if (!(interval.upperLimit != this.lowerLimit || interval.upperLimitClosed && this.lowerLimitClosed)) {
            return false;
        }
        return this.contains(interval.getLowerLimit()) || this.contains(interval.getUpperLimit()) || interval.contains(this.getLowerLimit()) || interval.contains(this.getUpperLimit());
    }

    public boolean encloses(Interval interval) {
        return this.contains(interval.lowerLimit) && this.contains(interval.upperLimit);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Interval)) {
            return false;
        }
        Interval interval = (Interval)object;
        return this.lowerLimit == interval.lowerLimit && this.upperLimit == interval.upperLimit && this.lowerLimitClosed == interval.lowerLimitClosed && this.upperLimitClosed == interval.upperLimitClosed;
    }

    @Override
    public int compareTo(Interval interval) {
        if (this.lowerLimit < interval.lowerLimit) {
            return -1;
        }
        if (this.lowerLimit > interval.lowerLimit) {
            return 1;
        }
        if (this.lowerLimitClosed && !interval.lowerLimitClosed) {
            return -1;
        }
        if (!this.lowerLimitClosed && interval.lowerLimitClosed) {
            return 1;
        }
        if (this.upperLimit < interval.upperLimit) {
            return -1;
        }
        if (this.upperLimit > interval.upperLimit) {
            return 1;
        }
        if (this.upperLimitClosed && !interval.upperLimitClosed) {
            return 1;
        }
        if (!this.upperLimitClosed && interval.upperLimitClosed) {
            return -1;
        }
        return 0;
    }

    public static Interval union(Interval interval, Interval interval2) {
        if (interval.intersects(interval2)) {
            boolean bl;
            double d;
            if (interval.compareTo(interval2) > 0) {
                Interval interval3 = interval;
                interval = interval2;
                interval2 = interval3;
            }
            double d2 = interval.lowerLimit;
            boolean bl2 = interval.lowerLimitClosed;
            if (interval.upperLimit > interval2.upperLimit) {
                d = interval.upperLimit;
                bl = interval.upperLimitClosed;
            } else if (interval.upperLimit < interval2.upperLimit) {
                d = interval2.upperLimit;
                bl = interval2.upperLimitClosed;
            } else {
                d = interval.upperLimit;
                bl = interval.upperLimitClosed || interval2.upperLimitClosed;
            }
            return new Interval(d2, d, bl2, bl);
        }
        if (interval.lowerLimit == interval2.upperLimit && (interval.lowerLimitClosed || interval2.upperLimitClosed) || interval.upperLimit == interval2.lowerLimit && (interval.upperLimitClosed || interval2.lowerLimitClosed)) {
            if (interval2.upperLimit == interval.lowerLimit) {
                Interval interval4 = interval2;
                interval2 = interval;
                interval = interval4;
            }
            return new Interval(interval.lowerLimit, interval2.upperLimit, interval.lowerLimitClosed, interval2.upperLimitClosed);
        }
        return null;
    }

    public static Interval negate(Interval interval) {
        return new Interval(-interval.upperLimit, -interval.lowerLimit, interval.upperLimitClosed, interval.lowerLimitClosed);
    }

    public static Interval add(Interval interval, Interval interval2) {
        boolean bl = interval.lowerLimitClosed && interval2.lowerLimitClosed;
        boolean bl2 = interval.upperLimitClosed && interval2.upperLimitClosed;
        return new Interval(interval.lowerLimit + interval2.lowerLimit, interval.upperLimit + interval2.upperLimit, bl, bl2);
    }

    public static Interval sub(Interval interval, Interval interval2) {
        boolean bl = interval.lowerLimitClosed && interval2.upperLimitClosed;
        boolean bl2 = interval.upperLimitClosed && interval2.lowerLimitClosed;
        return new Interval(interval.lowerLimit - interval2.upperLimit, interval.upperLimit - interval2.lowerLimit, bl, bl2);
    }

    public static Interval mul(Interval interval, Interval interval2) {
        boolean bl;
        double d;
        boolean bl2;
        double d2;
        TreeSet<Double> treeSet = new TreeSet<Double>();
        TreeSet<Double> treeSet2 = new TreeSet<Double>();
        double d3 = interval.lowerLimit * interval2.lowerLimit;
        if (interval.lowerLimitClosed && interval2.lowerLimitClosed) {
            treeSet.add(d3);
        } else {
            treeSet2.add(d3);
        }
        d3 = interval.lowerLimit * interval2.upperLimit;
        if (interval.lowerLimitClosed && interval2.upperLimitClosed) {
            treeSet.add(d3);
        } else {
            treeSet2.add(d3);
        }
        d3 = interval.upperLimit * interval2.lowerLimit;
        if (interval.upperLimitClosed && interval2.lowerLimitClosed) {
            treeSet.add(d3);
        } else {
            treeSet2.add(d3);
        }
        d3 = interval.upperLimit * interval2.upperLimit;
        if (interval.upperLimitClosed && interval2.upperLimitClosed) {
            treeSet.add(d3);
        } else {
            treeSet2.add(d3);
        }
        if (treeSet.size() > 0 && treeSet2.size() > 0) {
            if ((Double)treeSet.first() <= (Double)treeSet2.first()) {
                d2 = (Double)treeSet.first();
                bl2 = true;
            } else {
                d2 = (Double)treeSet2.first();
                bl2 = false;
            }
            if ((Double)treeSet.last() >= (Double)treeSet2.last()) {
                d = (Double)treeSet.last();
                bl = true;
            } else {
                d = (Double)treeSet2.last();
                bl = false;
            }
        } else if (treeSet.size() > 0) {
            bl2 = true;
            bl = true;
            d2 = (Double)treeSet.first();
            d = (Double)treeSet.last();
        } else {
            bl2 = false;
            bl = false;
            d2 = (Double)treeSet2.first();
            d = (Double)treeSet2.last();
        }
        return new Interval(d2, d, bl2, bl);
    }

    public static Interval cos(Interval interval) {
        if (interval.size() > Math.PI * 2) {
            return new Interval(-1.0, 1.0, true, true);
        }
        double d = interval.lowerLimit % (Math.PI * 2);
        double d2 = interval.upperLimit % (Math.PI * 2);
        boolean bl = interval.lowerLimitClosed;
        boolean bl2 = interval.upperLimitClosed;
        if (d > d2) {
            d -= Math.PI * 2;
        }
        Interval interval2 = new Interval(d, d2, bl, bl2);
        if (interval2.lowerLimit >= Math.PI) {
            return Interval.negate(Interval.cos(Interval.sub(interval, new Interval(Math.PI))));
        }
        if (interval2.lowerLimit < 0.0 && interval2.upperLimit < 0.0) {
            Interval interval3 = new Interval(Math.PI * 2 * Math.ceil(-interval2.lowerLimit));
            Interval interval4 = Interval.add(interval3, interval2);
            return Interval.cos(interval4);
        }
        if (interval2.lowerLimit < 0.0 && interval2.upperLimit >= 0.0) {
            Interval interval5 = new Interval(0.0, -interval2.lowerLimit, false, interval2.lowerLimitClosed);
            Interval interval6 = new Interval(0.0, interval2.upperLimit, true, interval2.upperLimitClosed);
            return Interval.union(Interval.cos(interval5), Interval.cos(interval6));
        }
        double d3 = interval2.lowerLimit;
        double d4 = interval2.upperLimit;
        if (d4 <= Math.PI) {
            return new Interval(Math.cos(d4), Math.cos(d3), interval2.upperLimitClosed, interval2.lowerLimitClosed);
        }
        if (d4 <= Math.PI * 2) {
            return new Interval(-1.0, Math.cos(Math.min(Math.PI * 2 - d4, d3)), true, Math.PI * 2 - d4 < d3 ? interval.upperLimitClosed : interval.lowerLimitClosed);
        }
        return new Interval(-1.0, 1.0, true, true);
    }

    public static Interval sin(Interval interval) {
        Interval interval2 = Interval.sub(interval, new Interval(1.5707963267948966));
        return Interval.cos(interval2);
    }

    public static Interval tan(Interval interval) throws MathException {
        Interval interval2 = Interval.sin(interval);
        Interval interval3 = Interval.cos(interval);
        try {
            Interval interval4 = Interval.div(interval2, interval3);
            return interval4;
        }
        catch (MathException mathException) {
            throw new MathException("Illegal tan value condition");
        }
    }

    public static Interval div(Interval interval, Interval interval2) throws MathException {
        boolean bl;
        double d;
        boolean bl2;
        double d2;
        double d3;
        if (interval2.contains(0.0)) {
            throw new MathException("Division by zero condition");
        }
        TreeSet<Double> treeSet = new TreeSet<Double>();
        TreeSet<Double> treeSet2 = new TreeSet<Double>();
        if (interval2.lowerLimit != Double.NEGATIVE_INFINITY) {
            if (interval2.lowerLimit != 0.0) {
                d3 = interval.lowerLimit / interval2.lowerLimit;
                if (interval.lowerLimitClosed && interval2.lowerLimitClosed) {
                    treeSet2.add(d3);
                } else {
                    treeSet.add(d3);
                }
                d3 = interval.upperLimit / interval2.lowerLimit;
                if (interval.upperLimitClosed && interval2.lowerLimitClosed) {
                    treeSet2.add(d3);
                } else {
                    treeSet.add(d3);
                }
            } else {
                if (interval.lowerLimit < 0.0) {
                    treeSet.add(Double.NEGATIVE_INFINITY);
                }
                if (interval.upperLimit > 0.0) {
                    treeSet.add(Double.POSITIVE_INFINITY);
                }
            }
        } else {
            treeSet.add(0.0);
        }
        if (interval2.upperLimit != Double.POSITIVE_INFINITY) {
            if (interval2.upperLimit != 0.0) {
                d3 = interval.lowerLimit / interval2.upperLimit;
                if (interval.lowerLimitClosed && interval2.upperLimitClosed) {
                    treeSet2.add(d3);
                } else {
                    treeSet.add(d3);
                }
                d3 = interval.upperLimit / interval2.upperLimit;
                if (interval.upperLimitClosed && interval2.upperLimitClosed) {
                    treeSet2.add(d3);
                } else {
                    treeSet.add(d3);
                }
            } else {
                if (interval.lowerLimit < 0.0) {
                    treeSet.add(Double.POSITIVE_INFINITY);
                }
                if (interval.upperLimit > 0.0) {
                    treeSet.add(Double.NEGATIVE_INFINITY);
                }
            }
        } else {
            treeSet.add(0.0);
        }
        if (treeSet2.size() > 0 && treeSet.size() > 0) {
            if ((Double)treeSet2.first() <= (Double)treeSet.first()) {
                d2 = (Double)treeSet2.first();
                bl2 = true;
            } else {
                d2 = (Double)treeSet.first();
                bl2 = false;
            }
            if ((Double)treeSet2.last() >= (Double)treeSet.last()) {
                d = (Double)treeSet2.last();
                bl = true;
            } else {
                d = (Double)treeSet.last();
                bl = false;
            }
        } else if (treeSet2.size() > 0) {
            bl2 = true;
            bl = true;
            d2 = (Double)treeSet2.first();
            d = (Double)treeSet2.last();
        } else {
            bl2 = false;
            bl = false;
            d2 = (Double)treeSet.first();
            d = (Double)treeSet.last();
        }
        return new Interval(d2, d, bl2, bl);
    }

    public static Interval pow(Interval interval, Interval interval2) throws MathException {
        boolean bl;
        double d;
        boolean bl2;
        double d2;
        if (interval.lowerLimit < 0.0 && Math.ceil(interval2.lowerLimit) != Math.floor(interval2.upperLimit)) {
            throw new MathException("Negative number raised to a non integer condition");
        }
        TreeSet<Double> treeSet = new TreeSet<Double>();
        TreeSet<Double> treeSet2 = new TreeSet<Double>();
        if (interval.lowerLimitClosed && interval2.lowerLimitClosed) {
            treeSet2.add(Math.pow(interval.lowerLimit, interval2.lowerLimit));
        } else {
            treeSet.add(Math.pow(interval.lowerLimit, interval2.lowerLimit));
        }
        if (interval.lowerLimitClosed && interval2.upperLimitClosed) {
            treeSet2.add(Math.pow(interval.lowerLimit, interval2.upperLimit));
        } else {
            treeSet.add(Math.pow(interval.lowerLimit, interval2.upperLimit));
        }
        if (interval.upperLimitClosed && interval2.lowerLimitClosed) {
            treeSet2.add(Math.pow(interval.upperLimit, interval2.lowerLimit));
        } else {
            treeSet.add(Math.pow(interval.upperLimit, interval2.lowerLimit));
        }
        if (interval.upperLimitClosed && interval2.upperLimitClosed) {
            treeSet2.add(Math.pow(interval.upperLimit, interval2.upperLimit));
        } else {
            treeSet.add(Math.pow(interval.upperLimit, interval2.upperLimit));
        }
        if (interval.contains(0.0)) {
            treeSet2.add(0.0);
        }
        if (treeSet2.size() > 0 && treeSet.size() > 0) {
            if ((Double)treeSet2.first() <= (Double)treeSet.first()) {
                d2 = (Double)treeSet2.first();
                bl2 = true;
            } else {
                d2 = (Double)treeSet.first();
                bl2 = false;
            }
            if ((Double)treeSet2.last() >= (Double)treeSet.last()) {
                d = (Double)treeSet2.last();
                bl = true;
            } else {
                d = (Double)treeSet.last();
                bl = false;
            }
        } else if (treeSet2.size() > 0) {
            bl2 = true;
            bl = true;
            d2 = (Double)treeSet2.first();
            d = (Double)treeSet2.last();
        } else {
            bl2 = false;
            bl = false;
            d2 = (Double)treeSet.first();
            d = (Double)treeSet.last();
        }
        return new Interval(d2, d, bl2, bl);
    }

    public static Interval ln(Interval interval) throws MathException {
        if (interval.lowerLimit < 0.0 || interval.contains(0.0)) {
            throw new MathException("Natural logarithm on a value below zero condition");
        }
        double d = Math.log(interval.lowerLimit);
        double d2 = Math.log(interval.upperLimit);
        boolean bl = d == Double.NEGATIVE_INFINITY ? false : interval.lowerLimitClosed;
        boolean bl2 = interval.upperLimitClosed;
        return new Interval(d, d2, bl, bl2);
    }

    public static Interval log10(Interval interval) throws MathException {
        if (interval.lowerLimit < 0.0 || interval.contains(0.0)) {
            throw new MathException("Logarithm on a value below zero condition");
        }
        double d = Math.log10(interval.lowerLimit);
        double d2 = Math.log10(interval.upperLimit);
        boolean bl = d == Double.NEGATIVE_INFINITY ? false : interval.lowerLimitClosed;
        boolean bl2 = interval.upperLimitClosed;
        return new Interval(d, d2, bl, bl2);
    }

    public static Interval exp(Interval interval) {
        double d = Math.exp(interval.lowerLimit);
        double d2 = Math.exp(interval.upperLimit);
        boolean bl = d2 == Double.POSITIVE_INFINITY ? false : interval.upperLimitClosed;
        boolean bl2 = interval.lowerLimitClosed;
        return new Interval(d, d2, bl2, bl);
    }

    public static Interval sqrt(Interval interval) throws MathException {
        if (interval.lowerLimit < 0.0) {
            throw new MathException("Square root of a value below zero condition");
        }
        return new Interval(Math.sqrt(interval.lowerLimit), Math.sqrt(interval.upperLimit), interval.lowerLimitClosed, interval.upperLimitClosed);
    }

    public static Interval toInt(Interval interval) {
        double d = interval.lowerLimit < 0.0 && Math.ceil(interval.lowerLimit) == Math.floor(interval.lowerLimit) && !interval.lowerLimitClosed ? (double)((int)interval.lowerLimit + 1) : (double)((int)interval.lowerLimit);
        double d2 = interval.upperLimit > 0.0 && Math.ceil(interval.upperLimit) == Math.floor(interval.upperLimit) && !interval.upperLimitClosed ? (double)((int)interval.upperLimit - 1) : (double)((int)interval.upperLimit);
        return new Interval(d, d2, true, true);
    }

    public static Interval abs(Interval interval) {
        boolean bl;
        double d;
        boolean bl2;
        double d2;
        double d3 = Math.abs(interval.lowerLimit);
        double d4 = Math.abs(interval.upperLimit);
        if (interval.contains(0.0)) {
            d2 = 0.0;
            bl2 = true;
            if (d3 < d4) {
                d = d4;
                bl = interval.upperLimitClosed;
            } else if (d3 > d4) {
                d = d3;
                bl = interval.lowerLimitClosed;
            } else {
                d = d4;
                bl = interval.lowerLimitClosed || interval.upperLimitClosed;
            }
        } else if (d3 < d4) {
            d2 = d3;
            d = d4;
            bl2 = interval.lowerLimitClosed;
            bl = interval.upperLimitClosed;
        } else {
            d2 = d4;
            d = d3;
            bl2 = interval.upperLimitClosed;
            bl = interval.lowerLimitClosed;
        }
        return new Interval(d2, d, bl2, bl);
    }

    public static Interval rand() {
        return new Interval(0.0, 1.0, true, false);
    }

    public static Interval fact(Interval interval) throws MathException {
        if (interval.lowerLimit < 0.0) {
            throw new MathException("Faculty on a value below zero condition");
        }
        double d = Interval.fac(interval.lowerLimit);
        double d2 = !interval.upperLimitClosed && Math.floor(interval.upperLimit) == Math.ceil(interval.upperLimit) ? (double)Interval.fac(interval.upperLimit - 1.0) : (double)Interval.fac(interval.upperLimit);
        return new Interval(d, d2, true, true);
    }

    public static Interval sum(List<Interval> list) {
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = true;
        boolean bl2 = true;
        for (Interval interval : list) {
            d += interval.lowerLimit;
            d2 += interval.upperLimit;
            bl &= interval.lowerLimitClosed;
            bl2 &= interval.upperLimitClosed;
        }
        return new Interval(d, d2, bl, bl2);
    }

    public static Interval avg(List<Interval> list) {
        Interval interval = new Interval(0.0);
        try {
            interval = Interval.div(Interval.sum(list), new Interval(list.size()));
        }
        catch (MathException mathException) {
            mathException.printStackTrace();
        }
        return interval;
    }

    public Interval clone() {
        return new Interval(this.lowerLimit, this.upperLimit, this.lowerLimitClosed, this.upperLimitClosed);
    }

    public double size() {
        double d = this.lowerLimitClosed ? this.lowerLimit : this.lowerLimit + Math.ulp(this.lowerLimit);
        double d2 = this.upperLimitClosed ? this.upperLimit : this.upperLimit - Math.ulp(this.upperLimit);
        return d2 - d;
    }

    public String toString() {
        String string = "";
        if (this.lowerLimitClosed && this.upperLimitClosed && this.lowerLimit == this.upperLimit) {
            string = string + this.lowerLimit;
            return string;
        }
        if (this.lowerLimit == Double.NEGATIVE_INFINITY && this.upperLimit != Double.POSITIVE_INFINITY) {
            string = string + (this.upperLimitClosed ? "<= " : "< ") + this.upperLimit;
            return string;
        }
        if (this.upperLimit == Double.POSITIVE_INFINITY && this.lowerLimit != Double.NEGATIVE_INFINITY) {
            string = string + (this.lowerLimitClosed ? ">= " : "> ") + this.lowerLimit;
            return string;
        }
        string = this.lowerLimitClosed ? string + "[" : string + "]";
        string = string + this.lowerLimit + " to " + this.upperLimit;
        string = this.upperLimitClosed ? string + "]" : string + "[";
        return string;
    }

    private static int fac(double d) {
        int n = 1;
        for (int i = (int)d; i > 0; --i) {
            n *= i;
        }
        return n;
    }

    private static double mod(double d, double d2) {
        long l = (long)d;
        long l2 = (long)d2;
        int n = 0;
        while (d > (double)l || d2 > (double)l2) {
            l = (long)(d *= 10.0);
            l2 = (long)(d2 *= 10.0);
            ++n;
        }
        return (double)(l % l2) / Math.pow(10.0, n);
    }
}

