/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula.util;

import csheets.core.Address;
import csheets.core.formula.Expression;
import csheets.core.formula.Reference;
import csheets.core.formula.lang.CellReference;
import csheets.core.formula.util.ExpressionBuilder;

public class ReferenceTransposer
extends ExpressionBuilder {
    private int columns;
    private int rows;

    public ReferenceTransposer(int n, int n2) {
        this.columns = n;
        this.rows = n2;
    }

    public Expression getExpression(Expression expression) {
        return (Expression)expression.accept(this);
    }

    public Expression visitReference(Reference reference) {
        if (reference instanceof CellReference) {
            CellReference cellReference = (CellReference)reference;
            Address address = cellReference.getCell().getAddress();
            int n = address.getColumn();
            if (!cellReference.isColumnAbsolute()) {
                n += this.columns;
            }
            int n2 = address.getRow();
            if (!cellReference.isRowAbsolute()) {
                n2 += this.rows;
            }
            return new CellReference(cellReference.getCell().getSpreadsheet().getCell(new Address(n, n2)), cellReference.isColumnAbsolute(), cellReference.isRowAbsolute());
        }
        return super.visitReference(reference);
    }
}

