/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula.lang;

import csheets.core.IllegalValueTypeException;
import csheets.core.Value;
import csheets.core.formula.BinaryOperator;
import csheets.core.formula.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationalOperator
implements BinaryOperator {
    @Override
    public final Value applyTo(Expression expression, Expression expression2) throws IllegalValueTypeException {
        Value value = expression.evaluate();
        switch (value.getType()) {
            case NUMERIC: {
                return new Value(this.compare(Double.valueOf(value.toDouble()), expression2.evaluate().toDouble()));
            }
            case TEXT: {
                return new Value(this.compare((Comparable)((Object)value.toText()), (Object)expression2.evaluate().toText()));
            }
            case BOOLEAN: {
                return new Value(this.compare(value.toBoolean(), expression2.evaluate().toBoolean()));
            }
            case DATE: {
                return new Value(this.compare(value.toDate(), expression2.evaluate().toDate()));
            }
        }
        throw new IllegalValueTypeException(value, Value.Type.NUMERIC);
    }

    public abstract <T> boolean compare(Comparable<T> var1, T var2);

    @Override
    public Value.Type getOperandValueType() {
        return Value.Type.NUMERIC;
    }

    public String toString() {
        return this.getIdentifier();
    }
}

