/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula.compiler;

import antlr.ANTLRException;
import antlr.collections.AST;
import csheets.core.Cell;
import csheets.core.Value;
import csheets.core.formula.BinaryOperation;
import csheets.core.formula.BinaryOperator;
import csheets.core.formula.Expression;
import csheets.core.formula.Function;
import csheets.core.formula.FunctionCall;
import csheets.core.formula.Literal;
import csheets.core.formula.Reference;
import csheets.core.formula.UnaryOperation;
import csheets.core.formula.compiler.ExpressionCompiler;
import csheets.core.formula.compiler.FormulaCompilationException;
import csheets.core.formula.compiler.FormulaLexer;
import csheets.core.formula.compiler.FormulaParser;
import csheets.core.formula.lang.CellReference;
import csheets.core.formula.lang.Language;
import csheets.core.formula.lang.RangeReference;
import csheets.core.formula.lang.ReferenceOperation;
import csheets.core.formula.lang.UnknownElementException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;

public class ExcelExpressionCompiler
implements ExpressionCompiler {
    public static final char FORMULA_STARTER = '=';

    public char getStarter() {
        return '=';
    }

    public Expression compile(Cell cell, String string) throws FormulaCompilationException {
        FormulaParser formulaParser = new FormulaParser(new FormulaLexer(new StringReader(string)));
        try {
            formulaParser.expression();
        }
        catch (ANTLRException aNTLRException) {
            throw new FormulaCompilationException(aNTLRException);
        }
        return this.convert(cell, formulaParser.getAST());
    }

    protected Expression convert(Cell cell, AST aST) throws FormulaCompilationException {
        if (aST.getNumberOfChildren() == 0) {
            try {
                switch (aST.getType()) {
                    case 24: {
                        return new Literal(Value.parseNumericValue(aST.getText()));
                    }
                    case 25: {
                        return new Literal(Value.parseValue(aST.getText(), Value.Type.BOOLEAN, Value.Type.DATE));
                    }
                    case 21: {
                        return new CellReference(cell.getSpreadsheet(), aST.getText());
                    }
                }
            }
            catch (ParseException parseException) {
                throw new FormulaCompilationException(parseException);
            }
        }
        Function function = null;
        try {
            function = Language.getInstance().getFunction(aST.getText());
        }
        catch (UnknownElementException unknownElementException) {
            // empty catch block
        }
        if (function != null) {
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            AST aST2 = aST.getFirstChild();
            if (aST2 != null) {
                arrayList.add(this.convert(cell, aST2));
                while ((aST2 = aST2.getNextSibling()) != null) {
                    arrayList.add(this.convert(cell, aST2));
                }
            }
            Expression[] expressionArray = arrayList.toArray(new Expression[arrayList.size()]);
            return new FunctionCall(function, expressionArray);
        }
        if (aST.getNumberOfChildren() == 1) {
            return new UnaryOperation(Language.getInstance().getUnaryOperator(aST.getText()), this.convert(cell, aST.getFirstChild()));
        }
        if (aST.getNumberOfChildren() == 2) {
            BinaryOperator binaryOperator = Language.getInstance().getBinaryOperator(aST.getText());
            if (binaryOperator instanceof RangeReference) {
                return new ReferenceOperation((Reference)this.convert(cell, aST.getFirstChild()), (RangeReference)binaryOperator, (Reference)this.convert(cell, aST.getFirstChild().getNextSibling()));
            }
            return new BinaryOperation(this.convert(cell, aST.getFirstChild()), binaryOperator, this.convert(cell, aST.getFirstChild().getNextSibling()));
        }
        throw new FormulaCompilationException();
    }
}

