/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula;

import csheets.core.IllegalValueTypeException;
import csheets.core.Value;
import csheets.core.formula.BinaryOperator;
import csheets.core.formula.Expression;
import csheets.core.formula.Operation;
import csheets.core.formula.util.ExpressionVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryOperation
extends Operation<BinaryOperator> {
    private static final long serialVersionUID = 2326739272985753461L;
    private Expression leftOperand;
    private Expression rightOperand;

    public BinaryOperation(Expression expression, BinaryOperator binaryOperator, Expression expression2) {
        super(binaryOperator);
        this.leftOperand = expression;
        this.rightOperand = expression2;
    }

    @Override
    public Value evaluate() throws IllegalValueTypeException {
        return ((BinaryOperator)this.operator).applyTo(this.leftOperand, this.rightOperand);
    }

    public Expression getLeftOperand() {
        return this.leftOperand;
    }

    public Expression getRightOperand() {
        return this.rightOperand;
    }

    @Override
    public Object accept(ExpressionVisitor expressionVisitor) {
        return expressionVisitor.visitBinaryOperation(this);
    }

    public String toString() {
        return this.leftOperand + ((BinaryOperator)this.operator).toString() + this.rightOperand;
    }
}

