/*
 * 01/09/2002 - 20:43:57
 *
 * ProxyButton.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package info.jdictionary.gui;


import info.jdictionary.JDictionary;
import info.jdictionary.IconBank;
import javax.swing.JButton;
import javax.swing.ImageIcon;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;


public class ProxyButton extends JButton {

    private JDictionary jDictionary;


    public ProxyButton(JDictionary jDictionary) {
        super();
        this.jDictionary = jDictionary;
        setText(JDictionary.getString("ProxySet"));
        setIcon(IconBank.getIconByName("Network.png"));
        addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                this_actionPerformed(e);
            }
        });
    }


    public ProxyButton(JDictionary jDictionary, ImageIcon buttonIcon, String buttonText) {
        super();
        this.jDictionary = jDictionary;
        setText(buttonText);
        setIcon(buttonIcon);
        addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                this_actionPerformed(e);
            }
        });
    }


    void this_actionPerformed(ActionEvent e) {
        jDictionary.getAssembler().getOutput().show(jDictionary.getPreferencesScreen());
    }
}