/*
 * 01/09/2002 - 20:43:57
 *
 * PluginDeployer.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



package info.jdictionary.pluginstuff;

import java.io.*;
import info.jdictionary.*;

public class PluginDeployer {

    boolean deploy(byte[] b, String fileName) {
        File plugin = new File(JDictionary.getPluginDirPath() + JDictionary.getFileSeparator() + fileName);
        if (plugin.exists()) {
            int n = 0;
            while (n < 20) {
                if (plugin.delete())
                    break;
                else
                    try {
                        System.out.println("PluginDeployer: unable to delete " + plugin.getName()+ " Sleeping a bit...");
                        Thread.sleep(300);
                    } catch (java.lang.InterruptedException e) {}
                n++;
            }
        }

        //this can never happen
        if(plugin.exists())
            System.out.println("PluginDeployer: Unable to deploy " + plugin.getName() + " File already exist");

        try {
            FileOutputStream fos = new FileOutputStream(plugin);
            fos.write(b);
            fos.close();
        }
        catch (java.io.FileNotFoundException ex) {
            return false;
        }
        catch (java.io.IOException ex) {
            return false;
        }
        return true;
    }
}