/*
 * 01/09/2002 - 20:43:57
 *
 * DefaultToolBar.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package info.jdictionary.modules;

import info.jdictionary.JDictionary;
import info.jdictionary.DefaultFrameAssembler;
import info.jdictionary.IconBank;
import javax.swing.JToolBar;
import javax.swing.JButton;
import java.awt.event.ActionEvent;
import java.awt.Component;

public class DefaultToolBar extends JToolBar {

    DefaultFrameAssembler assembler;
    JButton downloadSmallButton = new JButton();
    JButton activateSmallButton = new JButton();
    JButton rescanSmallButton = new JButton();

    public DefaultToolBar(DefaultFrameAssembler assembler) {
        super();
        this.assembler = assembler;
        setFloatable(false);
        putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        add(rescanSmallButton);
        add(activateSmallButton);
        add(downloadSmallButton);

        downloadSmallButton.setIcon(IconBank.FolderIn);
        downloadSmallButton.setToolTipText(JDictionary.getString("Download&Install"));
        downloadSmallButton.addActionListener(new java.awt.event.ActionListener() {
                                                  public void actionPerformed(ActionEvent e) {
                                                      downloadButton_actionPerformed(e);
                                                  }
                                              }
                                             );

        activateSmallButton.setIcon(IconBank.plug);
        activateSmallButton.setToolTipText(JDictionary.getString("ActivateDeactivate"));
        activateSmallButton.addActionListener(new java.awt.event.ActionListener() {
                                                public void actionPerformed(ActionEvent e) {
                                                    activateButton_actionPerformed(e);
                                                }
                                            }
                                           );

        rescanSmallButton.setIcon(IconBank.rescan);
        rescanSmallButton.setToolTipText(JDictionary.getString("Rescan"));
        rescanSmallButton.addActionListener(new java.awt.event.ActionListener() {
                                                public void actionPerformed(ActionEvent e) {
                                                    rescanButton_actionPerformed(e);
                                                }
                                            }
                                           );
}


    void downloadButton_actionPerformed(ActionEvent e) {
        assembler.getOutput().show(assembler.getJDictionary().getPluginDownloader());
    }

    void activateButton_actionPerformed(ActionEvent e) {
        assembler.getOutput().show(assembler.getJDictionary().getPluginStatusChanger());
    }

    void rescanButton_actionPerformed(ActionEvent e) {
        assembler.getJDictionary().getPluginManager().scanPlugins();
    }
}