/*
 * 01/09/2002 - 20:43:57
 *
 * DefaultOutput.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package info.jdictionary.modules;

import info.jdictionary.JDictionary;
import info.jdictionary.DefaultFrameAssembler;
import info.jdictionary.Plugin;
import info.jdictionary.pluginstuff.PluginInfoSheet;
import info.jdictionary.pluginstuff.PluginManager;
import info.jdictionary.gui.OutputTabbedPane;
import info.jdictionary.events.PluginSelectionEvent;
import info.jdictionary.listeners.PluginSelectionListener;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.SwingUtilities;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.HashMap;

public class DefaultOutput extends JPanel {

    DefaultFrameAssembler assembler;
    HashMap outputCache = new HashMap();
    BorderLayout borderLayout = new BorderLayout();

    public DefaultOutput(DefaultFrameAssembler assembler) {
        super();
        this.assembler = assembler;
        setLayout(borderLayout);

        assembler.getJDictionary().getPluginManager().addPluginSelectionListener(new PluginSelectionListener() {
            public void pluginSelected(PluginSelectionEvent e) {
                if(!(e.getSelectedPlugin() == null))
                    if(e.getSelectedSubPlugin() == null)
                        show(e.getSelectedPlugin());
                    else
                        show(e.getSelectedPlugin(), e.getSelectedSubPlugin());
            }

        });
    }


    private void show(PluginInfoSheet sheet) {
        JTabbedPane outputTabbedPane = (JTabbedPane)outputCache.get(sheet);
        if(outputTabbedPane == null)
            outputTabbedPane = buildOutputTabbedPane(sheet);
        if(getComponentCount()> 0 && (getComponent(0) == outputTabbedPane)) {
            return;
            }

        removeAll();
        add(outputTabbedPane);
        startPlugin(outputTabbedPane);
    }

    private void show(PluginInfoSheet sheet, String name) {
        JTabbedPane outputTabbedPane = (JTabbedPane)outputCache.get(sheet);
        if(outputTabbedPane == null)
            outputTabbedPane = buildOutputTabbedPane(sheet);
        for(int i = 0; i < outputTabbedPane.getTabCount(); i++) {
            if(outputTabbedPane.getTitleAt(i).equals(name)) {
                  if(getComponentCount() > 0 && getComponent(0) instanceof OutputTabbedPane && ((JTabbedPane)getComponent(0)) == outputTabbedPane) {
                      if(((JTabbedPane)getComponent(0)).getSelectedIndex() != i) {
                          outputTabbedPane.setSelectedIndex(i);
                          startPlugin(outputTabbedPane);
                      }
                  return;
                  }
              removeAll();
              add(outputTabbedPane);
              outputTabbedPane.setSelectedIndex(i);
              startPlugin(outputTabbedPane);
              return;
            }
        }
        show(sheet);
    }


    public void show(final Component comp) {
        SwingUtilities.invokeLater(new Runnable() {
        public void run() {
            removeAll();
            add(comp);
            assembler.outputScrollPane.validate();
            assembler.outputScrollPane.repaint();
            assembler.getJDictionary().getPluginManager().selectPlugin(null, null);
        }});
    }


    OutputTabbedPane buildOutputTabbedPane(PluginInfoSheet sheet) {
        OutputTabbedPane outputTabbedPane = new OutputTabbedPane(sheet);
        ArrayList plugin = assembler.getJDictionary().getPluginManager().getPlugin(sheet);
        int count = plugin.size() - 1;
        while (count >= 0) {
            Plugin pluginPiece = (Plugin)plugin.get(count);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            outputTabbedPane.add(pluginPiece.toString(), jPanel);
            count--;
        }

        outputTabbedPane.addChangeListener(new javax.swing.event.ChangeListener() {
                                              public void stateChanged(ChangeEvent e) {
                                                  outputTabbedPane_stateChanged(e);
                                              }
                                          }
                                         );
        outputCache.put(sheet, outputTabbedPane);
        return outputTabbedPane;
    }


    void outputTabbedPane_stateChanged(ChangeEvent e) {
        OutputTabbedPane outputTabbedPane = (OutputTabbedPane)e.getSource();
        startPlugin(outputTabbedPane);
        assembler.getJDictionary().getPluginManager().selectPlugin(outputTabbedPane.getSheet(), outputTabbedPane.getTitleAt(outputTabbedPane.getSelectedIndex()));
    }


    void startPlugin(JTabbedPane outputTabbedPane) {
        int selectedIndex = outputTabbedPane.getSelectedIndex();
        final JPanel contentPane = (JPanel)outputTabbedPane.getComponentAt(selectedIndex);
        if (contentPane.getComponentCount() > 0) {
            assembler.outputScrollPane.validate();
            assembler.outputScrollPane.repaint();
            return;
        }
        ArrayList plugin = assembler.getJDictionary().getPluginManager().getPlugin(((OutputTabbedPane)outputTabbedPane).getSheet());
        final Plugin pluginPiece = (Plugin)plugin.get(plugin.size() - (selectedIndex + 1));
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                pluginPiece.construct(contentPane);
                pluginPiece.start();
                assembler.outputScrollPane.validate();
                assembler.outputScrollPane.repaint();
            }});

    }
}