/*
 * 01/09/2002 - 20:43:57
 *
 * PluginInfoSheetPanel.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package info.jdictionary.gui;

import info.jdictionary.*;
import info.jdictionary.pluginstuff.*;
import javax.swing.*;
import javax.swing.text.*;

public class PluginInfoSheetPanel extends JTextPane {

    public PluginInfoSheetPanel(PluginInfoSheet sheet) {
        setEditable(false);
        Style def = StyleContext.getDefaultStyleContext().getStyle(StyleContext.DEFAULT_STYLE);
        Style regular = addStyle("regular", def);
        StyleConstants.setFontFamily(def, "SansSerif");
        Style s = addStyle("italic", regular);
        StyleConstants.setItalic(s, true);
        s = addStyle("bold", regular);
        StyleConstants.setBold(s, true);
        fillupTextPane(sheet);
        setCaretPosition(0);
    }


    void fillupTextPane(PluginInfoSheet sheet) {
        Document doc = getDocument();
        try {
            doc.insertString(0, JDictionary.getString("PluginName"), getStyle("bold"));
            doc.insertString(doc.getLength(), sheet.getName() + '\n', getStyle("regular"));
            doc.insertString(doc.getLength(), JDictionary.getString("PluginVersion"), getStyle("bold"));
            doc.insertString(doc.getLength(), sheet.getVersion() + '\n', getStyle("regular"));
            doc.insertString(doc.getLength(), JDictionary.getString("PluginSize"), getStyle("bold"));
            doc.insertString(doc.getLength(), sheet.getSizeInKB() + " " + JDictionary.getString("KB") + '\n', getStyle("regular"));
            doc.insertString(doc.getLength(), JDictionary.getString("PluginAuthor"), getStyle("bold"));
            doc.insertString(doc.getLength(), sheet.getAuthor() + '\n', getStyle("regular"));
            doc.insertString(doc.getLength(), JDictionary.getString("PluginDescription"), getStyle("bold"));
            doc.insertString(doc.getLength(), sheet.getDescription(), getStyle("regular"));
        }
        catch (javax.swing.text.BadLocationException e) {}
    }
}


