/*
 * Decompiled with CFR 0.152.
 */
package boplanets.gui;

import boplanets.AppException;
import boplanets.gui.CmbPlanetsCellRenderer;
import boplanets.gui.HorizontSystem;
import boplanets.gui.ILocationReceiver;
import boplanets.gui.Location;
import boplanets.gui.PlanetsPanel;
import boplanets.gui.PlanetsView;
import boplanets.gui.PnlLocations;
import boplanets.planetSystem.Planet;
import boplanets.util.CalUtil;
import boplanets.util.NumberConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;

public class PnlRiseTransSet
extends JPanel
implements ILocationReceiver {
    private JButton BtnApply;
    private JButton BtnClose;
    private JButton btnBrowseLocations;
    private JCheckBox chkGMTTime;
    private JCheckBox chkLocalTime;
    private JComboBox cmbAltitude;
    private JComboBox cmbPlanets;
    private ButtonGroup grpDateType;
    private JPanel pnlDate;
    private JPanel pnlObserver;
    private JPanel pnlTimeType;
    private JScrollPane scrpResults;
    private JTextArea txaResults;
    private JTextField txtLatitude;
    private JTextField txtLongitude;
    private JTextField txtName;
    private JTextField txtNoTransits;
    private JTextField txtStartDate;
    private JTextField txtTimeZone;
    private JTextField txtTzOffset;
    private PlanetsView _parent;
    private static final String ORB_PARAMETERS_MODIFIED = "Some orbital parameters of the observer or planet were modified. So rise, transit and set times make no sense.\n";
    private static final String OBS_MODIFIED = "Close the view and start it again.";
    private static final String OBS_MODIFIED2 = " This window will be closed now.";
    private static final String PLANET_MODIFIED = "Select another planet or close the view and start it again.";
    private static final int MAX_NO_TRANSITS = 366;
    private static final int MAX_ITERATIONS = 20;
    private static final double EPSILON = 1.0E-5;
    private static final int LOWER_TRANS = -1;
    private static final int UPPER_TRANS = 1;
    private static final int NO_TRANS = 0;
    private static final String EMPTY_DATE = "          --              ";
    private static final String EMPTY_ANGLE = "  --  ";
    private static final String HEADER_RISE = "Rise time                 ";
    private static final String HEADER_RISE_AZ = "  Az";
    private static final String HEADER_TRANS = "Transit time             ";
    private static final String HEADER_ALT = "  Alt.";
    private static final String HEADER_SET = "Set time                 ";
    private static final String HEADER_SET_AZ = "  Az";
    private static final String UNDERLINE34 = "__________________________________";
    private static final double LIGHT_REFRACTION_EARTH = -0.56666;
    private static final double[] ALTITUDES_RISE_SET = new double[]{0.0, Math.toRadians(-0.56666), Math.toRadians(-6.0), Math.toRadians(-12.0), Math.toRadians(-18.0)};
    private final GregorianCalendar GMT_CALENDAR = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    private static final long MIN_DATE_MILLIS = new GregorianCalendar(1, 0, 1, 0, 0, 0).getTimeInMillis();
    private static final long MAX_DATE_MILLIS = new GregorianCalendar(3001, 0, 1, 0, 0, 0).getTimeInMillis();
    private static final String PREF_LOCAL_PATTERN = "dd.MM.yyyy HH:mm:ss 'TZ";
    private static final String GMT_PATTERN_NO_ERA = "dd.MM.yyyy HH:mm:ss z";
    private static final DateFormat _dateFormat = DateFormat.getDateInstance(2);
    private static final double MIN_LATITUDE = -90.0;
    private static final double MAX_LATITUDE = 90.0;
    private static final double MIN_LONGITUDE = -180.0;
    private static final double MAX_LONGITUDE = 180.0;
    private StringBuffer _resultBuffer;
    private static HorizontSystem _horizonSys;
    private Planet[] _arrPlanets;
    private JDialog _dialog;
    private JDialog _dialogLoc = null;
    private PnlLocations _locations = null;
    private WindowAdapter _dialogWindowListener;
    private Planet _objObserver;
    private static final int EARTH_ID = 3;
    private int _idObserver;
    private Planet _selPlanet;
    private int _noPlanets;
    private double _longDegrees;
    private double _longRadians;
    private double _latDegrees;
    private double _latRadians;
    private int _noTimeZone;
    private int _noTransits;
    private Date _startDate;
    private double _altRiseSet;
    private int _indexRiseSet;
    private long _rotPeriodMillis;
    private long _sundayObsMillis;

    public PnlRiseTransSet(PlanetsView planetsView, PlanetsPanel planetsPanel) {
        this._parent = planetsView;
        this._arrPlanets = planetsPanel.getAllPlanets();
        this._noPlanets = this._arrPlanets.length - 1;
        this._objObserver = this._arrPlanets[this._noPlanets];
        this._idObserver = this._objObserver.iIndex;
        if (this._objObserver.orbParamsModified) {
            String string = "Some orbital parameters of the observer or planet were modified. So rise, transit and set times make no sense.\nClose the view and start it again.";
            JOptionPane.showMessageDialog(null, string, "Orbital parameters modified", 2);
            this._parent.PnlRiseTransSetClosed();
            return;
        }
        this.initComponents();
        this._longDegrees = 11.583;
        this._latDegrees = 48.133;
        this._noTimeZone = 1;
        this.txtName.setText(this._objObserver.sName);
        String string = NumberConverter.format(this._longDegrees);
        this.txtLongitude.setText(string);
        string = NumberConverter.format(this._latDegrees);
        this.txtLatitude.setText(string);
        this.txtTimeZone.setText(String.valueOf(this._noTimeZone));
        for (int i = 0; i < this._noPlanets; ++i) {
            this.cmbPlanets.addItem(this._arrPlanets[i]);
        }
        this.cmbPlanets.setSelectedIndex(0);
        this._selPlanet = (Planet)this.cmbPlanets.getSelectedItem();
        long l = System.currentTimeMillis();
        long l2 = l / 86400000L * 86400000L;
        this.GMT_CALENDAR.setTimeInMillis(l2);
        this._startDate = this.GMT_CALENDAR.getTime();
        _dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.txtStartDate.setText(_dateFormat.format(this._startDate));
        this._noTransits = 5;
        this.txtNoTransits.setText(String.valueOf(this._noTransits));
        this._indexRiseSet = this._idObserver == 3 ? 1 : 0;
        this.cmbAltitude.setSelectedIndex(this._indexRiseSet);
        this._altRiseSet = ALTITUDES_RISE_SET[this._indexRiseSet];
        double d = this._objObserver.rotPer;
        this._rotPeriodMillis = (long)(d * 8.64E7);
        double d2 = this._objObserver.sunDay;
        this._sundayObsMillis = (long)(d2 * 8.64E7);
        string = this.formatDuration((long)this._noTimeZone * this._sundayObsMillis / 24L);
        this.txtTzOffset.setText(string);
        _horizonSys = null;
        this._dialog = new JDialog(planetsView, "Rise, transit and set times of planets", false);
        this._dialog.getContentPane().add(this);
        URL uRL = this.getClass().getResource("images/icon_parameters.jpg");
        this._dialog.setIconImage(new ImageIcon(uRL).getImage());
        this._dialog.setSize(750, 520);
        this._dialog.setResizable(false);
        this._dialog.setDefaultCloseOperation(2);
        this._dialogWindowListener = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                PnlRiseTransSet.this.Dialog_WindowClosed(windowEvent);
            }
        };
        this._dialog.addWindowListener(this._dialogWindowListener);
        this._dialog.setVisible(true);
    }

    private void initComponents() {
        this.grpDateType = new ButtonGroup();
        this.pnlObserver = new JPanel();
        this.txtName = new JTextField();
        this.txtLongitude = new JTextField();
        this.txtLatitude = new JTextField();
        this.txtTimeZone = new JTextField();
        this.txtTzOffset = new JTextField();
        this.btnBrowseLocations = new JButton();
        this.cmbPlanets = new JComboBox();
        this.pnlDate = new JPanel();
        this.pnlTimeType = new JPanel();
        this.chkGMTTime = new JCheckBox();
        this.chkLocalTime = new JCheckBox();
        this.txtStartDate = new JTextField();
        this.txtNoTransits = new JTextField();
        this.cmbAltitude = new JComboBox();
        this.BtnApply = new JButton();
        this.BtnClose = new JButton();
        this.scrpResults = new JScrollPane();
        this.txaResults = new JTextArea();
        this.setFocusable(false);
        this.setFont(new Font("Arial", 0, 11));
        this.setPreferredSize(new Dimension(330, 400));
        this.setRequestFocusEnabled(false);
        this.pnlObserver.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")), "Observer", 0, 0, new Font("Arial", 0, 11), Color.blue));
        this.pnlObserver.setFocusable(false);
        this.pnlObserver.setPreferredSize(new Dimension(740, 85));
        this.pnlObserver.setRequestFocusEnabled(false);
        this.txtName.setEditable(false);
        this.txtName.setFont(new Font("Arial", 0, 11));
        this.txtName.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")), "Name", 0, 0, new Font("Arial", 0, 11), Color.blue));
        this.txtName.setFocusable(false);
        this.txtName.setPreferredSize(new Dimension(70, 45));
        this.txtName.setRequestFocusEnabled(false);
        this.pnlObserver.add(this.txtName);
        this.txtLongitude.setFont(new Font("Arial", 0, 11));
        this.txtLongitude.setHorizontalAlignment(4);
        this.txtLongitude.setToolTipText("longitude of the observer location in degrees within  [-180.0, +180.0]");
        this.txtLongitude.setAutoscrolls(false);
        this.txtLongitude.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")), "Longitude", 0, 0, new Font("Arial", 0, 11), Color.blue));
        this.txtLongitude.setPreferredSize(new Dimension(70, 45));
        this.txtLongitude.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PnlRiseTransSet.this.txtLongitude_FocusLost(focusEvent);
            }
        });
        this.pnlObserver.add(this.txtLongitude);
        this.txtLatitude.setFont(new Font("Arial", 0, 11));
        this.txtLatitude.setHorizontalAlignment(4);
        this.txtLatitude.setToolTipText("latitude of the observer location in degrees within  [-90.0, +90.0]");
        this.txtLatitude.setAutoscrolls(false);
        this.txtLatitude.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")), "Latitude", 0, 0, new Font("Arial", 0, 11), Color.blue));
        this.txtLatitude.setPreferredSize(new Dimension(70, 45));
        this.txtLatitude.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PnlRiseTransSet.this.txtLatitude_FocusLost(focusEvent);
            }
        });
        this.pnlObserver.add(this.txtLatitude);
        this.txtTimeZone.setFont(new Font("Arial", 0, 11));
        this.txtTimeZone.setHorizontalAlignment(4);
        this.txtTimeZone.setToolTipText("no of the time zone of the observer location; valid values [-12, +12]");
        this.txtTimeZone.setAutoscrolls(false);
        this.txtTimeZone.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")), "#Time Zone ", 0, 0, new Font("Tahoma", 0, 11), Color.blue));
        this.txtTimeZone.setPreferredSize(new Dimension(70, 45));
        this.txtTimeZone.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PnlRiseTransSet.this.txtTimeZone_FocusLost(focusEvent);
            }
        });
        this.pnlObserver.add(this.txtTimeZone);
        this.txtTzOffset.setEditable(false);
        this.txtTzOffset.setFont(new Font("Arial", 0, 11));
        this.txtTzOffset.setHorizontalAlignment(4);
        this.txtTzOffset.setToolTipText("time zone offset");
        this.txtTzOffset.setAutoscrolls(false);
        this.txtTzOffset.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")), "Time zone offset", 0, 0, new Font("Arial", 0, 11), Color.blue));
        this.txtTzOffset.setFocusable(false);
        this.txtTzOffset.setPreferredSize(new Dimension(95, 45));
        this.txtTzOffset.setRequestFocusEnabled(false);
        this.pnlObserver.add(this.txtTzOffset);
        this.btnBrowseLocations.setFont(new Font("Arial", 0, 11));
        this.btnBrowseLocations.setText("browse");
        this.btnBrowseLocations.setToolTipText("browse for named locations");
        this.btnBrowseLocations.setBorder(new SoftBevelBorder(0));
        this.btnBrowseLocations.setPreferredSize(new Dimension(71, 25));
        this.btnBrowseLocations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PnlRiseTransSet.this.btnBrowseLocations_ActionPerformed(actionEvent);
            }
        });
        this.pnlObserver.add(this.btnBrowseLocations);
        this.add(this.pnlObserver);
        this.cmbPlanets.setFont(new Font("Arial", 0, 11));
        this.cmbPlanets.setToolTipText("select the planet, whose date&times to be determined.");
        this.cmbPlanets.setBorder(BorderFactory.createTitledBorder(null, "Select Planet", 0, 0, new Font("Arial", 0, 11), Color.blue));
        this.cmbPlanets.setPreferredSize(new Dimension(85, 45));
        this.cmbPlanets.setRenderer(new CmbPlanetsCellRenderer());
        this.cmbPlanets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PnlRiseTransSet.this.cmbPlanets_ActionPerformed(actionEvent);
            }
        });
        this.add(this.cmbPlanets);
        this.pnlDate.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")), "Start date, No of Transits, Altitude", 0, 0, new Font("Arial", 0, 11), Color.blue));
        this.pnlDate.setFocusable(false);
        this.pnlDate.setFont(new Font("Arial", 0, 11));
        this.pnlDate.setPreferredSize(new Dimension(740, 85));
        this.pnlDate.setRequestFocusEnabled(false);
        this.pnlDate.setLayout(new FlowLayout(1, 5, 10));
        this.pnlTimeType.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")), "Date&Time type", 0, 0, new Font("Arial", 0, 11), Color.blue));
        this.pnlTimeType.setFocusable(false);
        this.pnlTimeType.setPreferredSize(new Dimension(160, 45));
        this.pnlTimeType.setRequestFocusEnabled(false);
        this.grpDateType.add(this.chkGMTTime);
        this.chkGMTTime.setFont(new Font("Arial", 0, 11));
        this.chkGMTTime.setForeground(Color.blue);
        this.chkGMTTime.setSelected(true);
        this.chkGMTTime.setText("GMT time");
        this.chkGMTTime.setToolTipText("Date&Time as GMT time");
        this.chkGMTTime.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkGMTTime.setMargin(new Insets(0, 0, 0, 0));
        this.pnlTimeType.add(this.chkGMTTime);
        this.grpDateType.add(this.chkLocalTime);
        this.chkLocalTime.setFont(new Font("Arial", 0, 11));
        this.chkLocalTime.setForeground(Color.blue);
        this.chkLocalTime.setText("Local time");
        this.chkLocalTime.setToolTipText("Date&Time as local time");
        this.chkLocalTime.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkLocalTime.setMargin(new Insets(0, 0, 0, 0));
        this.pnlTimeType.add(this.chkLocalTime);
        this.pnlDate.add(this.pnlTimeType);
        this.txtStartDate.setFont(new Font("Arial", 0, 11));
        this.txtStartDate.setToolTipText("the date preceding the first transit date. Valid dates: [1.1.1 - 31.12.3000]");
        this.txtStartDate.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")), "Start Date", 0, 0, new Font("Arial", 0, 11), Color.blue));
        this.txtStartDate.setPreferredSize(new Dimension(80, 45));
        this.txtStartDate.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PnlRiseTransSet.this.txtStartDate_FocusLost(focusEvent);
            }
        });
        this.pnlDate.add(this.txtStartDate);
        this.txtNoTransits.setFont(new Font("Arial", 0, 11));
        this.txtNoTransits.setHorizontalAlignment(4);
        this.txtNoTransits.setToolTipText("the number of consecutive rise, transit and set to be determined; valid values: [1,366]");
        this.txtNoTransits.setAutoscrolls(false);
        this.txtNoTransits.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")), "No of Transits", 0, 0, new Font("Arial", 0, 11), Color.blue));
        this.txtNoTransits.setPreferredSize(new Dimension(80, 45));
        this.txtNoTransits.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PnlRiseTransSet.this.txtNoTransits_FocusLost(focusEvent);
            }
        });
        this.pnlDate.add(this.txtNoTransits);
        this.cmbAltitude.setFont(new Font("Arial", 0, 11));
        this.cmbAltitude.setModel(new DefaultComboBoxModel<String>(new String[]{"0\u00b0", "-0.56\u00b0 atm. light refraction", "-6\u00b0     civilian twilight", "-12\u00b0    nautical twilight", "-18\u00b0    astronomical twilight"}));
        this.cmbAltitude.setToolTipText("the altitude of planet's center, which defines rise and set.");
        this.cmbAltitude.setAutoscrolls(true);
        this.cmbAltitude.setBorder(BorderFactory.createTitledBorder(null, "define rise/set altitude", 0, 0, new Font("Arial", 0, 11), Color.blue));
        this.cmbAltitude.setPreferredSize(new Dimension(165, 45));
        this.cmbAltitude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PnlRiseTransSet.this.cmbAltitude_ActionPerformed(actionEvent);
            }
        });
        this.pnlDate.add(this.cmbAltitude);
        this.BtnApply.setFont(new Font("Arial", 0, 11));
        this.BtnApply.setText("Apply");
        this.BtnApply.setToolTipText("start to generate the sequence of rise, transit and set date&times.");
        this.BtnApply.setBorder(new SoftBevelBorder(0));
        this.BtnApply.setPreferredSize(new Dimension(60, 25));
        this.BtnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PnlRiseTransSet.this.BtnApply_ActionPerformed(actionEvent);
            }
        });
        this.pnlDate.add(this.BtnApply);
        this.BtnClose.setFont(new Font("Arial", 0, 11));
        this.BtnClose.setText("Close");
        this.BtnClose.setToolTipText("close the form without evaluation.");
        this.BtnClose.setBorder(new SoftBevelBorder(0));
        this.BtnClose.setPreferredSize(new Dimension(60, 25));
        this.BtnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PnlRiseTransSet.this.BtnClose_ActionPerformed(actionEvent);
            }
        });
        this.pnlDate.add(this.BtnClose);
        this.add(this.pnlDate);
        this.scrpResults.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")), "Rise time + azimuth, Transit time + altitude, Set time + azimuth      ", 0, 0, new Font("Courier New", 0, 11), Color.blue));
        this.scrpResults.setFont(new Font("Arial", 0, 11));
        this.scrpResults.setPreferredSize(new Dimension(740, 240));
        this.txaResults.setColumns(10);
        this.txaResults.setEditable(false);
        this.txaResults.setFont(new Font("Courier New", 0, 12));
        this.txaResults.setRows(10);
        this.txaResults.setTabSize(35);
        this.txaResults.setBorder(null);
        this.scrpResults.setViewportView(this.txaResults);
        this.add(this.scrpResults);
    }

    private void btnBrowseLocations_ActionPerformed(ActionEvent actionEvent) {
        if (this._dialogLoc != null) {
            this._dialogLoc.setVisible(true);
        } else {
            this._locations = new PnlLocations(this);
            this._dialogLoc = new JDialog(this._dialog, "Observer Locations", false);
            this._dialogLoc.getContentPane().add(this._locations);
            URL uRL = this.getClass().getResource("images/observe.gif");
            this._dialogLoc.setIconImage(new ImageIcon(uRL).getImage());
            ComponentAdapter componentAdapter = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    PnlRiseTransSet.this.dialog_ComponentResized(componentEvent);
                }
            };
            this._dialogLoc.addComponentListener(componentAdapter);
            this._dialogLoc.setMinimumSize(new Dimension(200, 200));
            this._dialogLoc.setDefaultCloseOperation(1);
            this._dialogLoc.setSize(220, 350);
            this._dialogLoc.setLocationRelativeTo(this.btnBrowseLocations);
            this._dialogLoc.setResizable(true);
            this._dialogLoc.setVisible(true);
        }
    }

    private void txtTimeZone_FocusLost(FocusEvent focusEvent) {
        String string = this.txtTimeZone.getText().trim();
        if (string.length() > 0) {
            try {
                int n = Integer.valueOf(string);
                if (n >= -12 && n <= 12) {
                    this._noTimeZone = n;
                    this.txtTimeZone.setText(String.valueOf(n));
                    String string2 = this.formatDuration((long)this._noTimeZone * this._sundayObsMillis / 24L);
                    this.txtTzOffset.setText(string2);
                    if (this._dialogLoc != null && this._dialogLoc.isVisible()) {
                        this._locations.clearSelection();
                    }
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.txtTimeZone.setText(String.valueOf(this._noTimeZone));
        Toolkit.getDefaultToolkit().beep();
        this.txtTimeZone.requestFocusInWindow();
    }

    private void txtLatitude_FocusLost(FocusEvent focusEvent) {
        String string = this.txtLatitude.getText().trim();
        try {
            this._latDegrees = NumberConverter.checkDecimalValue(string, -90.0, 90.0);
            if (this._dialogLoc != null && this._dialogLoc.isVisible()) {
                this._locations.clearSelection();
            }
        }
        catch (NumberFormatException numberFormatException) {
            Toolkit.getDefaultToolkit().beep();
            this.txtLatitude.requestFocusInWindow();
        }
        string = NumberConverter.format(this._latDegrees);
        this.txtLatitude.setText(string);
    }

    private void txtLongitude_FocusLost(FocusEvent focusEvent) {
        String string = this.txtLongitude.getText().trim();
        try {
            this._longDegrees = NumberConverter.checkDecimalValue(string, -180.0, 180.0);
            if (this._dialogLoc != null && this._dialogLoc.isVisible()) {
                this._locations.clearSelection();
            }
        }
        catch (NumberFormatException numberFormatException) {
            Toolkit.getDefaultToolkit().beep();
            this.txtLongitude.requestFocusInWindow();
        }
        string = NumberConverter.format(this._longDegrees);
        this.txtLongitude.setText(string);
    }

    private void cmbAltitude_ActionPerformed(ActionEvent actionEvent) {
        this._indexRiseSet = this.cmbAltitude.getSelectedIndex();
        this._altRiseSet = ALTITUDES_RISE_SET[this._indexRiseSet];
    }

    private void cmbPlanets_ActionPerformed(ActionEvent actionEvent) {
        this._selPlanet = (Planet)this.cmbPlanets.getSelectedItem();
    }

    private void txtStartDate_FocusLost(FocusEvent focusEvent) {
        String string = this.txtStartDate.getText().trim();
        if (string.length() > 0) {
            try {
                Date date = _dateFormat.parse(string);
                this.GMT_CALENDAR.setTime(date);
                long l = this.GMT_CALENDAR.getTimeInMillis();
                if (l >= MIN_DATE_MILLIS && l < MAX_DATE_MILLIS) {
                    this._startDate = date;
                    string = _dateFormat.format(date);
                    this.txtStartDate.setText(string);
                    return;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        string = _dateFormat.format(this._startDate);
        this.txtStartDate.setText(string);
        Toolkit.getDefaultToolkit().beep();
        this.txtStartDate.requestFocusInWindow();
    }

    private void txtNoTransits_FocusLost(FocusEvent focusEvent) {
        String string = this.txtNoTransits.getText().trim();
        if (string.length() > 0) {
            try {
                int n = Integer.valueOf(string);
                if (n > 0 && n <= 366) {
                    this._noTransits = n;
                    this.txtNoTransits.setText(String.valueOf(n));
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Toolkit.getDefaultToolkit().beep();
        this.txtNoTransits.setText(String.valueOf(this._noTransits));
        this.txtNoTransits.requestFocusInWindow();
    }

    private void BtnClose_ActionPerformed(ActionEvent actionEvent) {
        this._dialog.dispose();
    }

    private void BtnApply_ActionPerformed(ActionEvent actionEvent) {
        if (this._objObserver.orbParamsModified) {
            String string = "Some orbital parameters of the observer or planet were modified. So rise, transit and set times make no sense.\nClose the view and start it again. This window will be closed now.";
            JOptionPane.showMessageDialog(null, string, "Orbital parameters modified.", 2);
            this._dialog.dispose();
            return;
        }
        if (this._selPlanet.orbParamsModified) {
            String string = "Some orbital parameters of the observer or planet were modified. So rise, transit and set times make no sense.\nSelect another planet or close the view and start it again.";
            JOptionPane.showMessageDialog(null, string, "Orbital parameters modified.", 2);
            return;
        }
        if (_horizonSys == null) {
            _horizonSys = new HorizontSystem(this._arrPlanets, this._longDegrees, this._latDegrees);
        } else {
            _horizonSys.setLongitudeAndLatitude(this._longDegrees, this._latDegrees);
        }
        this._longRadians = Math.toRadians(this._longDegrees);
        this._latRadians = Math.toRadians(this._latDegrees);
        this.getSequenceOfRiseTransSet(this._startDate, this._noTransits);
    }

    private void Dialog_WindowClosed(WindowEvent windowEvent) {
        this._parent.PnlRiseTransSetClosed();
        this._dialog.removeWindowListener(this._dialogWindowListener);
    }

    private void dialog_ComponentResized(ComponentEvent componentEvent) {
        JDialog jDialog = (JDialog)componentEvent.getComponent();
        int n = jDialog.getWidth() - 20;
        int n2 = jDialog.getHeight() - 40 - this.getInsets().top - this.getInsets().bottom;
        if (jDialog.getContentPane().getComponentCount() > 0) {
            Component component = jDialog.getContentPane().getComponent(0);
            component.setPreferredSize(new Dimension(n, n2));
        }
    }

    @Override
    public void setLocation(Location location) {
        this._longDegrees = location.geoLongitude;
        String string = NumberConverter.format(this._longDegrees);
        this.txtLongitude.setText(string);
        this._latDegrees = location.geoLatitude;
        string = NumberConverter.format(this._latDegrees);
        this.txtLatitude.setText(string);
        this._noTimeZone = location.timeZone;
        this.txtTimeZone.setText(String.valueOf(this._noTimeZone));
        string = this.formatDuration((long)this._noTimeZone * this._sundayObsMillis / 24L);
        this.txtTzOffset.setText(string);
    }

    private void getSequenceOfRiseTransSet(Date date, int n) {
        Object object;
        SimpleDateFormat simpleDateFormat;
        long l;
        this.GMT_CALENDAR.setTime(date);
        long l2 = this.GMT_CALENDAR.getTimeInMillis();
        if (this.chkGMTTime.isSelected()) {
            l = 0L;
            simpleDateFormat = new SimpleDateFormat(GMT_PATTERN_NO_ERA);
        } else {
            l = (long)this._noTimeZone * this._sundayObsMillis / 24L;
            l2 -= l;
            object = this._noTimeZone >= 0 ? "+" : "";
            String string = PREF_LOCAL_PATTERN + (String)object + String.valueOf(this._noTimeZone) + "'";
            simpleDateFormat = new SimpleDateFormat(string);
        }
        simpleDateFormat.setCalendar(this.GMT_CALENDAR);
        this._resultBuffer = new StringBuffer();
        this._resultBuffer.append(HEADER_RISE);
        this._resultBuffer.append("  Az\t");
        this._resultBuffer.append(HEADER_TRANS);
        this._resultBuffer.append("  Alt.\t");
        this._resultBuffer.append(HEADER_SET);
        this._resultBuffer.append("  Az\n");
        this._resultBuffer.append(UNDERLINE34);
        this._resultBuffer.append(UNDERLINE34);
        this._resultBuffer.append("__________________________________\n");
        this.txaResults.setText(null);
        object = this.findFirstLowerAndUpperTransit(l2);
        Object object2 = object[0];
        Object object3 = object[1];
        String string = CalUtil.formatGmtDateNoEra((long)object2);
        String string2 = CalUtil.formatGmtDateNoEra((long)object3);
        String string3 = CalUtil.formatDate((long)object3, l, simpleDateFormat);
        long[] lArray = this.findNextTransit((long)object3, true);
        long l3 = lArray[0];
        StringBuffer stringBuffer = this.recordRiseTransSet((long)object2, (long)object3, l3, l, simpleDateFormat);
        this._resultBuffer.append(stringBuffer);
        for (int i = 1; i < n; ++i) {
            object2 = l3;
            lArray = this.findNextTransit((long)object2, true);
            object3 = lArray[0];
            lArray = this.findNextTransit((long)object3, true);
            l3 = lArray[0];
            stringBuffer = this.recordRiseTransSet((long)object2, (long)object3, l3, l, simpleDateFormat);
            this._resultBuffer.append(stringBuffer);
        }
        this.txaResults.setText(this._resultBuffer.toString());
        Toolkit.getDefaultToolkit().beep();
    }

    private StringBuffer recordRiseTransSet(long l, long l2, long l3, long l4, SimpleDateFormat simpleDateFormat) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        block8: {
            string6 = EMPTY_DATE;
            string5 = EMPTY_ANGLE;
            string4 = EMPTY_DATE;
            string3 = EMPTY_ANGLE;
            string2 = EMPTY_ANGLE;
            string = CalUtil.formatDate(l2, l4, simpleDateFormat);
            double d = this.getAltitude(l2);
            string2 = this.formatAngleInDegrees(d);
            if (d > this._altRiseSet) {
                double d2;
                block7: {
                    d = this.getAltitude(l);
                    if (d < this._altRiseSet) {
                        try {
                            long l5 = this.getRiseOrSetTime(true, l, l2);
                            string6 = CalUtil.formatDate(l5, l4, simpleDateFormat);
                            d2 = this.getAzimuth(l5);
                            string5 = this.formatAngleInDegrees(d2);
                        }
                        catch (AppException appException) {
                            if (appException.excId != -1) break block7;
                            System.out.println(appException.getMessage());
                        }
                    }
                }
                if ((d = this.getAltitude(l3)) < this._altRiseSet) {
                    try {
                        long l6 = this.getRiseOrSetTime(false, l2, l3);
                        string4 = CalUtil.formatDate(l6, l4, simpleDateFormat);
                        d2 = this.getAzimuth(l6);
                        string3 = this.formatAngleInDegrees(d2);
                    }
                    catch (AppException appException) {
                        if (appException.excId != -1) break block8;
                        System.out.println(appException.getMessage());
                    }
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string6);
        stringBuffer.append(string5 + "\t");
        stringBuffer.append(string);
        stringBuffer.append(string2 + "\t");
        stringBuffer.append(string4);
        stringBuffer.append(string3 + "\n");
        stringBuffer.trimToSize();
        return stringBuffer;
    }

    private long[] findFirstLowerAndUpperTransit(long l) {
        long l2;
        long[] lArray = this.getTransitTime(l);
        long l3 = lArray[0];
        long l4 = lArray[1];
        if (l4 == 1L) {
            if (l3 < l) {
                lArray = this.findNextTransit(l3, true);
                l3 = lArray[0];
                lArray = this.findNextTransit(l3, true);
                l2 = lArray[0];
            } else {
                l2 = l3;
                lArray = this.findNextTransit(l2, false);
                l3 = lArray[0];
            }
        } else {
            lArray = this.findNextTransit(l3, true);
            l2 = lArray[0];
            l4 = lArray[1];
        }
        long[] lArray2 = new long[]{l3, l2};
        return lArray2;
    }

    private long[] findNextTransit(long l, boolean bl) {
        long l2 = l;
        long l3 = bl ? 1L : -1L;
        long l4 = (this._rotPeriodMillis < this._sundayObsMillis ? this._rotPeriodMillis / 2L : this._sundayObsMillis / 2L) * l3;
        double[] dArray = this.getHourAngleAndDerivative(l2);
        double d = dArray[0];
        d = l3 > 0L ? (d < 1.0E-4 ? Math.PI * 2 : d) : (d > 6.2830853071795865 ? 0.0 : d);
        double d2 = 0.0;
        while (Math.abs(d2) < 1.5707963267948966) {
            dArray = this.getHourAngleAndDerivative(l2 += l4);
            double d3 = dArray[0];
            d2 = d3 - d;
        }
        long[] lArray = this.getTransitTime(l2);
        return lArray;
    }

    private long[] getTransitTime(long l) {
        long l2;
        long l3;
        double d = 0.0;
        long l4 = l;
        double d2 = 1.0;
        int n = 0;
        double[] dArray = this.getTanHourAngleAndDerivative(l4);
        double d3 = dArray[0];
        long l5 = l3 = this._rotPeriodMillis < this._sundayObsMillis ? this._rotPeriodMillis / 2L : this._sundayObsMillis / 2L;
        if (Math.abs(d3) > 15.0) {
            dArray = this.getTanHourAngleAndDerivative(l4 += l3 * (long)Math.signum(d3) / 2L);
        }
        String string = CalUtil.formatGmtDateNoEra(l4);
        double d4 = 0.0;
        while (Math.abs(d2) > 1.0E-5 && n < 20) {
            d3 = dArray[0];
            d = dArray[1];
            long l6 = -((long)(d3 / d)) + l4;
            if (Math.abs(l6 - l4) > l3 / 2L) {
                long l7 = l6 - l4 > 0L ? 1L : -1L;
                l6 = l4 + l7 * l3 / 2L;
            }
            if (Math.abs(d2 = (dArray = this.getTanHourAngleAndDerivative(l6))[0]) < 0.5 && (d4 = (d3 - d2) / (double)(l4 - l6)) < 0.0) {
                dArray[1] = d4;
            }
            l4 = l6;
            ++n;
        }
        if (n >= 20 && Math.abs(d2) > 1.0E-5) {
            System.out.println("-Methode getTransitTime: number of maximum iterations exceeded, starting with " + string);
            l2 = 0L;
        } else {
            dArray = this.getHourAngleAndDerivative(l4);
            d3 = dArray[0];
            l2 = d3 > 3.241592653589793 || d3 < 3.041592653589793 ? 1L : -1L;
        }
        long[] lArray = new long[]{l4, l2};
        return lArray;
    }

    private long getRiseOrSetTime(boolean bl, long l, long l2) throws AppException {
        int n;
        long l3 = l;
        long l4 = l2;
        double d = this.getAltitude(l3);
        double d2 = this.getAltitude(l4);
        if (bl && d > this._altRiseSet || !bl && d2 > this._altRiseSet) {
            String string = CalUtil.formatGmtDateNoEra(l3);
            String string2 = CalUtil.formatGmtDateNoEra(l4);
            AppException appException = new AppException(1, "-Method getRiseOrSetTime: there exists no rise or set within " + string + " - " + string2);
            throw appException;
        }
        double d3 = bl ? 1.0 : -1.0;
        double d4 = 1.0;
        long l5 = 0L;
        for (n = 0; Math.abs(d4) > 1.0E-5 && n < 20; ++n) {
            long l6;
            double d5 = l4 - l3;
            double d6 = (d2 - d) / d5;
            l5 = l3 - (long)((d - this._altRiseSet) / d6);
            double d7 = this.getAltitude(l5);
            d4 = (d7 - this._altRiseSet) * d3;
            if (d4 <= 0.0) {
                l3 = l5;
                l6 = l3 + (l4 - l3) / 2L;
                d7 = (this.getAltitude(l6) - this._altRiseSet) * d3;
                l4 = d7 > 0.0 ? l6 : l4;
            } else {
                l4 = l5;
                l6 = l4 - (l4 - l3) / 2L;
                d7 = (this.getAltitude(l6) - this._altRiseSet) * d3;
                long l7 = l3 = d7 <= 0.0 ? l6 : l3;
            }
            if (l3 > l4) {
                String string = CalUtil.formatGmtDateNoEra(l3);
                String string3 = CalUtil.formatGmtDateNoEra(l4);
                AppException appException = new AppException(-1, "-Method getRiseOrSetTime: iteration error; t1 must be < t2: t1=  " + string + ", t2= " + string3);
                throw appException;
            }
            d = this.getAltitude(l3);
            d2 = this.getAltitude(l4);
        }
        if (n >= 20 && Math.abs(d4) > 1.0E-5) {
            String string = CalUtil.formatGmtDateNoEra(l);
            String string4 = CalUtil.formatGmtDateNoEra(l2);
            AppException appException = new AppException(-1, "-Method getRiseOrSetTime: maximum number of iterations exceeded within " + string + " - " + string4);
            throw appException;
        }
        return l5;
    }

    private double getRa(long l) {
        double[] dArray = _horizonSys.getRaDecDerivAtDate(l, this._selPlanet, this._objObserver);
        double d = (dArray[0] + Math.PI * 2) % (Math.PI * 2);
        return d;
    }

    private double getLmst(long l) {
        double d = this._objObserver.getGmst(l);
        double d2 = (d + this._longRadians + Math.PI * 2) % (Math.PI * 2);
        return d2;
    }

    private double[] getTanHourAngleAndDerivative(long l) {
        double[] dArray = this.getHourAngleAndDerivative(l);
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = Math.tan(d);
        double d4 = Math.cos(d);
        double d5 = d2 / (d4 * d4);
        double[] dArray2 = new double[]{d3, d5};
        return dArray2;
    }

    private double[] getHourAngleAndDerivative(long l) {
        double[] dArray = _horizonSys.getRaDecDerivAtDate(l, this._selPlanet, this._objObserver);
        double d = dArray[0];
        double d2 = dArray[2];
        double d3 = this._objObserver.getGmst(l);
        double d4 = d3 + this._longRadians;
        double d5 = (d - d4 + Math.PI * 2) % (Math.PI * 2);
        double d6 = d2 - Math.PI * 2 / (double)this._rotPeriodMillis;
        if (d6 >= 0.0) {
            d6 = Math.PI * -2 / (double)this._rotPeriodMillis;
        }
        double[] dArray2 = new double[]{d5, d6};
        return dArray2;
    }

    private double getAltitude(long l) {
        double[] dArray = _horizonSys.getAziAltAtDate(l, this._selPlanet, this._objObserver);
        double d = dArray[1];
        return d;
    }

    private double getAzimuth(long l) {
        double[] dArray = _horizonSys.getAziAltAtDate(l, this._selPlanet, this._objObserver);
        double d = dArray[0];
        return d;
    }

    private String formatAngleInDegrees(double d) {
        double d2 = d * 57.29577951308232;
        double d3 = Math.signum(d2) * (double)((int)(Math.abs(d2) * 100.0)) / 100.0;
        return " " + String.valueOf(d3) + "\u00b0";
    }

    private String formatDuration(long l) {
        this.GMT_CALENDAR.setTimeInMillis(Math.abs(l));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Math.signum(l) < 0.0f ? "- " : " ");
        int n = this.GMT_CALENDAR.get(6) - 1;
        if (n != 0) {
            stringBuffer.append(String.valueOf(n) + "d ");
        }
        int n2 = this.GMT_CALENDAR.get(11);
        stringBuffer.append(String.valueOf(n2) + "h");
        int n3 = this.GMT_CALENDAR.get(12);
        if (n3 != 0) {
            String string = n3 < 10 ? ":0" : ":";
            stringBuffer.append(string + String.valueOf(n3) + "m");
        }
        return stringBuffer.toString();
    }
}

