/*
 * Decompiled with CFR 0.152.
 */
package boplanets.gui;

import boplanets.planetSystem.Planet;

public abstract class CoordinateSystem {
    protected static final int VIEW_ECLIPTIC = 0;
    protected static final int VIEW_LOG_ECLIPTIC = 1;
    protected static final int VIEW_EQUATOR = 2;
    protected static final int VIEW_HORIZONT = 3;
    protected int _viewType;

    public abstract void setOrbParamsOfObserver(Planet var1);

    public abstract void setMinMaxCoordinates(Planet[] var1);

    public abstract double[] getNextCoordinates(Planet var1, double[] var2);

    protected abstract double[] getSpecMapParams(int var1, int var2);

    protected static double[] getMapParams(int n, int n2, double[] dArray, double[] dArray2) {
        double d = n - 14;
        double d2 = n2 - 12;
        double d3 = dArray[1] - dArray[0];
        double d4 = d / d3;
        double d5 = d3 / 10.0;
        double d6 = dArray2[1] - dArray2[0];
        double d7 = d2 / d6;
        double d8 = d6 / 10.0;
        d5 = Math.rint(d5 * 100.0) / 100.0;
        d8 = Math.rint(d8 * 100.0) / 100.0;
        double d9 = Math.abs(dArray[0]) * d4 + 7.0;
        double d10 = Math.abs(dArray2[1]) * d7 + 6.0;
        double[] dArray3 = new double[]{d9, d10, d4, d7, d5, d8};
        return dArray3;
    }

    protected static void setEquatorials(Planet planet, double[] dArray) {
        planet.ra = dArray[0];
        planet.dec = dArray[1];
    }

    protected static void setHorizontals(Planet planet, double[] dArray) {
        planet.azi = dArray[0];
        planet.alt = dArray[1];
    }
}

